/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.metrics.simple.Counter;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputCheckingSearcher
extends Searcher {
    private final Counter utfRejections;
    private final Counter repeatedConsecutiveTermsInPhraseRejections;
    private final Counter repeatedTermsInPhraseRejections;
    private static final Logger log = Logger.getLogger(InputCheckingSearcher.class.getName());
    private final int MAX_REPEATED_CONSECUTIVE_TERMS_IN_PHRASE = 5;
    private final int MAX_REPEATED_TERMS_IN_PHRASE = 10;

    public InputCheckingSearcher(MetricReceiver metrics) {
        this.utfRejections = metrics.declareCounter("double_encoded_utf8_rejections");
        this.repeatedTermsInPhraseRejections = metrics.declareCounter("repeated_terms_in_phrase_rejections");
        this.repeatedConsecutiveTermsInPhraseRejections = metrics.declareCounter("repeated_consecutive_terms_in_phrase_rejections");
    }

    @Override
    public Result search(Query query, Execution execution) {
        try {
            this.checkQuery(query);
        }
        catch (IllegalInputException e) {
            log.log(Level.FINE, () -> "Rejected query '" + query.toString() + "' on cause of: " + Exceptions.toMessageString((Throwable)e));
            return new Result(query, ErrorMessage.createIllegalQuery(e.getMessage()));
        }
        return execution.search(query);
    }

    private void checkQuery(Query query) {
        this.doubleEncodedUtf8(query);
        this.checkPhrases(query.getModel().getQueryTree().getRoot());
    }

    private void checkPhrases(Item queryItem) {
        if (queryItem instanceof PhraseItem) {
            PhraseItem phrase = (PhraseItem)queryItem;
            this.repeatedConsecutiveTermsInPhraseCheck(phrase);
            this.repeatedTermsInPhraseCheck(phrase);
        } else if (queryItem instanceof CompositeItem) {
            CompositeItem asComposite = (CompositeItem)queryItem;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                this.checkPhrases(i.next());
            }
        }
    }

    private void repeatedConsecutiveTermsInPhraseCheck(PhraseItem phrase) {
        if (phrase.getItemCount() > 5) {
            String prev = null;
            int repeatedCount = 0;
            for (int i = 0; i < phrase.getItemCount(); ++i) {
                Item item = phrase.getItem(i);
                if (item instanceof TermItem) {
                    TermItem term = (TermItem)item;
                    String current = term.getIndexedString();
                    if (prev != null) {
                        if (prev.equals(current)) {
                            if (++repeatedCount >= 5) {
                                this.repeatedConsecutiveTermsInPhraseRejections.add();
                                throw new IllegalInputException("More than 5 occurrences of term '" + current + "' in a row detected in phrase : " + phrase.toString());
                            }
                        } else {
                            repeatedCount = 0;
                        }
                    }
                    prev = current;
                    continue;
                }
                prev = null;
                repeatedCount = 0;
            }
        }
    }

    private void repeatedTermsInPhraseCheck(PhraseItem phrase) {
        if (phrase.getItemCount() > 10) {
            HashMap<String, Count> repeatedCount = new HashMap<String, Count>();
            for (int i = 0; i < phrase.getItemCount(); ++i) {
                Item item = phrase.getItem(i);
                if (!(item instanceof TermItem)) continue;
                TermItem term = (TermItem)item;
                String current = term.getIndexedString();
                Count count = (Count)repeatedCount.get(current);
                if (count != null) {
                    if (count.get() >= 10) {
                        this.repeatedTermsInPhraseRejections.add();
                        throw new IllegalInputException("Phrase contains more than 10 occurrences of term '" + current + "' in phrase : " + phrase.toString());
                    }
                    count.inc();
                    continue;
                }
                repeatedCount.put(current, new Count(1));
            }
        }
    }

    private void doubleEncodedUtf8(Query query) {
        int singleCharacterTerms = this.countSingleCharacterUserTerms(query.getModel().getQueryTree());
        if (singleCharacterTerms <= 4) {
            return;
        }
        String userInput = query.getModel().getQueryString();
        ByteBuffer asOctets = ByteBuffer.allocate(userInput.length());
        boolean asciiOnly = true;
        for (int i = 0; i < userInput.length(); ++i) {
            char c = userInput.charAt(i);
            if (c > '\u00ff') {
                return;
            }
            if (c > '\u007f') {
                asciiOnly = false;
            }
            asOctets.put((byte)c);
        }
        if (asciiOnly) {
            return;
        }
        asOctets.flip();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            decoder.decode(asOctets);
        }
        catch (CharacterCodingException e) {
            return;
        }
        this.utfRejections.add();
        throw new IllegalInputException("The user input has been determined to be double encoded UTF-8. Please investigate whether this is a false positive.");
    }

    private int countSingleCharacterUserTerms(Item queryItem) {
        if (queryItem instanceof CompositeItem) {
            int sum = 0;
            CompositeItem asComposite = (CompositeItem)queryItem;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                sum += this.countSingleCharacterUserTerms(i.next());
            }
            return sum;
        }
        if (queryItem instanceof WordItem) {
            WordItem word = (WordItem)queryItem;
            return word.isFromQuery() && word.stringValue().length() == 1 ? 1 : 0;
        }
        return 0;
    }

    private static final class Count {
        private int v;

        Count(int initial) {
            this.v = initial;
        }

        void inc() {
            ++this.v;
        }

        int get() {
            return this.v;
        }
    }
}

