/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.google.common.collect.ImmutableMap;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.compiled.DimensionalValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DimensionalMap<VALUE> {
    private final Map<CompoundName, DimensionalValue<VALUE>> values;

    private DimensionalMap(Map<CompoundName, DimensionalValue<VALUE>> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public VALUE get(CompoundName key, Map<String, String> context) {
        DimensionalValue<VALUE> variants = this.values.get(key);
        if (variants == null) {
            return null;
        }
        return variants.get(context);
    }

    public Set<Map.Entry<CompoundName, DimensionalValue<VALUE>>> entrySet() {
        return this.values.entrySet();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public static class Builder<VALUE> {
        private final Map<CompoundName, DimensionalValue.Builder<VALUE>> entries = new HashMap<CompoundName, DimensionalValue.Builder<VALUE>>();

        public void put(CompoundName key, DimensionBinding binding, VALUE value) {
            DimensionalValue.Builder<VALUE> entry = this.entries.get(key);
            if (entry == null) {
                entry = new DimensionalValue.Builder();
                this.entries.put(key, entry);
            }
            entry.add(value, binding);
        }

        public DimensionalMap<VALUE> build() {
            HashMap map = new HashMap();
            for (Map.Entry<CompoundName, DimensionalValue.Builder<VALUE>> entry : this.entries.entrySet()) {
                map.put(entry.getKey(), entry.getValue().build(this.entries));
            }
            return new DimensionalMap(map);
        }
    }
}

