/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.compiled.DimensionalValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Binding
implements Comparable<Binding> {
    private static final int maxDimensions = 31;
    private final int generality;
    private final String[] dimensions;
    private final String[] dimensionValues;
    private final int hashCode;
    public static final Binding nullBinding = new Binding(Integer.MAX_VALUE, Collections.emptyMap());

    public static Binding createFrom(DimensionBinding dimensionBinding) {
        if (dimensionBinding.getDimensions().size() > 31) {
            throw new IllegalArgumentException("More than 31 dimensions is not supported");
        }
        int generality = 0;
        HashMap<String, String> context = new HashMap<String, String>();
        if (dimensionBinding.getDimensions() == null || dimensionBinding.getDimensions().isEmpty()) {
            generality = Integer.MAX_VALUE;
        } else {
            for (int i = 0; i <= 31; ++i) {
                String value;
                String string = value = i < dimensionBinding.getDimensions().size() ? dimensionBinding.getValues().get(i) : null;
                if (value == null) {
                    generality = (int)((double)generality + Math.pow(2.0, 31 - i - 1));
                    continue;
                }
                context.put(dimensionBinding.getDimensions().get(i), value);
            }
        }
        return new Binding(generality, context);
    }

    private Binding(int generality, Map<String, String> bindings) {
        this.generality = generality;
        this.dimensions = new String[bindings.size()];
        this.dimensionValues = new String[bindings.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            this.dimensions[i] = entry.getKey();
            this.dimensionValues[i] = entry.getValue();
            ++i;
        }
        this.hashCode = Arrays.hashCode(this.dimensions) + 11 * Arrays.hashCode(this.dimensionValues);
    }

    Binding(DimensionalValue.BindingSpec spec, Map<String, String> bindings) {
        this.generality = 0;
        this.dimensions = spec.dimensions();
        this.dimensionValues = new String[spec.dimensions().length];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensionValues[i] = bindings.get(this.dimensions[i]);
        }
        this.hashCode = Arrays.hashCode(this.dimensions) + 11 * Arrays.hashCode(this.dimensionValues);
    }

    public boolean generalizes(Binding other) {
        if (this.dimensions.length >= other.dimensions.length) {
            return false;
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            int otherIndexOfDimension = this.indexOf(this.dimensions[i], other.dimensions);
            if (otherIndexOfDimension < 0) {
                return false;
            }
            if (this.dimensionValues[i].equals(other.dimensionValues[otherIndexOfDimension])) continue;
            return false;
        }
        return true;
    }

    private int indexOf(String value, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public boolean isNull() {
        return this.dimensions.length == 0;
    }

    String[] dimensions() {
        return this.dimensions;
    }

    String[] dimensionValues() {
        return this.dimensionValues;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Binding[");
        for (int i = 0; i < this.dimensions.length; ++i) {
            b.append(this.dimensions[i]).append("=").append(this.dimensionValues[i]).append(",");
        }
        if (this.dimensions.length > 0) {
            b.setLength(b.length() - 1);
        }
        b.append("] (generality " + this.generality + ")");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding other = (Binding)o;
        return Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.dimensionValues, other.dimensionValues);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean matches(Map<String, String> context) {
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.dimensionValues[i].equals(context.get(this.dimensions[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Binding other) {
        return Integer.compare(this.generality, other.generality);
    }
}

