/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.Properties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SubstituteString {
    private final List<Component> components;
    private final String stringValue;
    private final boolean hasRelative;

    public static SubstituteString create(String value) {
        int lastEnd = 0;
        int start = value.indexOf("%{");
        if (start < 0) {
            return null;
        }
        ArrayList<Component> components = new ArrayList<Component>();
        while (start >= 0) {
            int end = value.indexOf("}", start + 2);
            if (end < 0) {
                throw new IllegalArgumentException("Unterminated value substitution '" + value.substring(start) + "'");
            }
            String propertyName = value.substring(start + 2, end);
            if (propertyName.contains("%{")) {
                throw new IllegalArgumentException("Unterminated value substitution '" + value.substring(start) + "'");
            }
            components.add(new StringComponent(value.substring(lastEnd, start)));
            if (propertyName.startsWith(".")) {
                components.add(new RelativePropertyComponent(propertyName.substring(1)));
            } else {
                components.add(new PropertyComponent(propertyName));
            }
            lastEnd = end + 1;
            start = value.indexOf("%{", lastEnd);
        }
        components.add(new StringComponent(value.substring(lastEnd)));
        return new SubstituteString(components, value);
    }

    public SubstituteString(List<Component> components, String stringValue) {
        this.components = components;
        this.stringValue = stringValue;
        this.hasRelative = components.stream().anyMatch(component -> component instanceof RelativePropertyComponent);
    }

    public boolean hasRelative() {
        return this.hasRelative;
    }

    public String substitute(Map<String, String> context, Properties substitution) {
        StringBuilder b = new StringBuilder();
        for (Component component : this.components) {
            b.append(component.getValue(context, substitution));
        }
        return b.toString();
    }

    public List<Component> components() {
        return this.components;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubstituteString)) {
            return false;
        }
        return this.stringValue.equals(((SubstituteString)other).stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public static final class RelativePropertyComponent
    extends Component {
        private final String fieldName;

        public RelativePropertyComponent(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getValue(Map<String, String> context, Properties substitution) {
            throw new IllegalStateException("Should be resolved during compilation");
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "%{" + this.fieldName + "}";
        }
    }

    public static final class PropertyComponent
    extends Component {
        private final String propertyName;

        public PropertyComponent(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getValue(Map<String, String> context, Properties substitution) {
            Object value = substitution.get(this.propertyName, context, substitution);
            if (value == null) {
                return "";
            }
            return String.valueOf(value);
        }

        public String toString() {
            return "%{" + this.propertyName + "}";
        }
    }

    public static final class StringComponent
    extends Component {
        private final String value;

        public StringComponent(String value) {
            this.value = value;
        }

        @Override
        public String getValue(Map<String, String> context, Properties substitution) {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static abstract class Component {
        protected abstract String getValue(Map<String, String> var1, Properties var2);
    }
}

