/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.SearchChainResolver;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import com.yahoo.search.federation.sourceref.UnresolvedSourceRefException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SourceRefResolver {
    private final SearchChainResolver searchChainResolver;

    public SourceRefResolver(SearchChainResolver searchChainResolver) {
        this.searchChainResolver = searchChainResolver;
    }

    public Set<SearchChainInvocationSpec> resolve(ComponentSpecification sourceRef, Properties sourceToProviderMap, IndexFacts indexFacts) throws UnresolvedSearchChainException {
        try {
            return new LinkedHashSet<SearchChainInvocationSpec>(Arrays.asList(this.searchChainResolver.resolve(sourceRef, sourceToProviderMap)));
        }
        catch (UnresolvedSourceRefException e) {
            return this.resolveClustersWithDocument(sourceRef, sourceToProviderMap, indexFacts);
        }
    }

    private Set<SearchChainInvocationSpec> resolveClustersWithDocument(ComponentSpecification sourceRef, Properties sourceToProviderMap, IndexFacts indexFacts) throws UnresolvedSearchChainException {
        if (this.hasOnlyName(sourceRef)) {
            LinkedHashSet<SearchChainInvocationSpec> clusterSearchChains = new LinkedHashSet<SearchChainInvocationSpec>();
            List<String> clusters = indexFacts.clustersHavingSearchDefinition(sourceRef.getName());
            for (String cluster : clusters) {
                clusterSearchChains.add(this.resolveClusterSearchChain(cluster, sourceRef, sourceToProviderMap));
            }
            if (!clusterSearchChains.isEmpty()) {
                return clusterSearchChains;
            }
        }
        throw UnresolvedSourceRefException.createForMissingSourceRef(sourceRef);
    }

    private SearchChainInvocationSpec resolveClusterSearchChain(String cluster, ComponentSpecification sourceRef, Properties sourceToProviderMap) throws UnresolvedSearchChainException {
        try {
            return this.searchChainResolver.resolve(new ComponentSpecification(cluster), sourceToProviderMap);
        }
        catch (UnresolvedSearchChainException e) {
            throw new UnresolvedSearchChainException("Failed to resolve cluster search chain '" + cluster + "' when using source ref '" + sourceRef + "' as a document name.");
        }
    }

    private boolean hasOnlyName(ComponentSpecification sourceSpec) {
        return new ComponentSpecification(sourceSpec.getName()).equals((Object)sourceSpec);
    }
}

