/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.collections.CopyOnWriteHashMap;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PureWeightedInteger;
import com.yahoo.prelude.query.PureWeightedString;
import com.yahoo.prelude.query.SimpleTaggableItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class WeightedSetItem
extends SimpleTaggableItem {
    private String indexName = "";
    private CopyOnWriteHashMap<Object, Integer> set = new CopyOnWriteHashMap(1000);

    public WeightedSetItem(String indexName) {
        this.indexName = indexName == null ? "" : indexName;
    }

    public Integer addToken(long value, int weight) {
        return this.addInternal(value, weight);
    }

    public Integer addToken(String token, int weight) {
        if (token == null) {
            throw new IllegalArgumentException("token must be a string");
        }
        return this.addInternal(token, weight);
    }

    private Integer addInternal(Object token, int weight) {
        Integer newWeight = weight;
        Integer oldWeight = (Integer)this.set.put(token, (Object)newWeight);
        if (oldWeight != null && oldWeight > newWeight) {
            this.set.put(token, (Object)oldWeight);
            return oldWeight;
        }
        return newWeight;
    }

    public Integer addToken(String token) {
        return this.addToken(token, 1);
    }

    public Integer getTokenWeight(String token) {
        return (Integer)this.set.get((Object)token);
    }

    public Integer removeToken(String token) {
        return (Integer)this.set.remove((Object)token);
    }

    public int getNumTokens() {
        return this.set.size();
    }

    public Iterator<Map.Entry<Object, Integer>> getTokens() {
        return this.set.entrySet().iterator();
    }

    @Override
    public void setIndexName(String index) {
        this.indexName = index == null ? "" : index;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WEIGHTEDSET;
    }

    @Override
    public String getName() {
        return this.getItemType().name();
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.indexName);
        buffer.append("{");
        for (Map.Entry entry : this.set.entrySet()) {
            buffer.append("[");
            buffer.append(entry.getValue());
            buffer.append("]:\"");
            buffer.append(entry.getKey());
            buffer.append("\",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("}");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("index", this.indexName);
        for (Map.Entry entry : this.set.entrySet()) {
            WordItem subitem = new WordItem(entry.getKey().toString(), this.indexName);
            subitem.setWeight((Integer)entry.getValue());
            discloser.addChild(subitem);
        }
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        int itemCount = 1;
        for (Map.Entry entry : this.set.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof Long) {
                new PureWeightedInteger((Long)key, (Integer)entry.getValue()).encode(buffer);
            } else {
                new PureWeightedString(key.toString(), (Integer)entry.getValue()).encode(buffer);
            }
            ++itemCount;
        }
        return itemCount;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.set.size(), (ByteBuffer)buffer);
        WeightedSetItem.putString(this.indexName, buffer);
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public WeightedSetItem clone() {
        WeightedSetItem clone = (WeightedSetItem)super.clone();
        clone.set = this.set.clone();
        return clone;
    }
}

