/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.textualrepresentation.Discloser;

public abstract class SegmentItem
extends CompositeItem
implements BlockItem {
    private boolean locked = false;
    private String rawWord;
    private String value;
    private boolean isFromQuery;
    private boolean isFromUser;
    private boolean stemmed;
    private SegmentingRule segmentingRule = SegmentingRule.LANGUAGE_DEFAULT;
    private Substring origin;

    public SegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed) {
        this(rawWord, current, isFromQuery, stemmed, null);
    }

    public SegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed, Substring origin) {
        this.rawWord = rawWord;
        this.value = current;
        this.stemmed = stemmed;
        this.isFromQuery = isFromQuery;
        this.isFromUser = isFromQuery;
        this.origin = origin;
    }

    @Override
    public String getRawWord() {
        return this.rawWord;
    }

    public String getNormalized() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public boolean isFromQuery() {
        return this.isFromQuery;
    }

    @Override
    public boolean isStemmed() {
        return this.stemmed;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public int getNumWords() {
        return this.getItemCount();
    }

    @Override
    public void addItem(Item item) {
        if (this.locked) {
            this.dontAdd();
        }
        super.addItem(item);
    }

    @Override
    public void addItem(int index, Item item) {
        if (this.locked) {
            this.dontAdd();
        }
        super.addItem(index, item);
    }

    private void dontAdd() {
        throw new IllegalArgumentException("Tried to add item to an immutable segment.");
    }

    @Override
    public Item removeItem(int index) {
        if (this.locked) {
            this.dontRemove();
        }
        return super.removeItem(index);
    }

    @Override
    public boolean removeItem(Item item) {
        if (this.locked) {
            this.dontRemove();
        }
        return super.removeItem(item);
    }

    private void dontRemove() {
        throw new IllegalArgumentException("Tried to remove an item from an immutable segment.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentItem clone() {
        SegmentItem copy;
        SegmentItem segmentItem = this;
        synchronized (segmentItem) {
            boolean tmpLock = this.locked;
            this.locked = false;
            copy = (SegmentItem)super.clone();
            this.locked = tmpLock;
            copy.locked = tmpLock;
        }
        return copy;
    }

    @Override
    public boolean isWords() {
        return true;
    }

    public boolean isFromUser() {
        return this.isFromUser;
    }

    public void setFromUser(boolean isFromUser) {
        this.isFromUser = isFromUser;
    }

    @Override
    public Substring getOrigin() {
        return this.origin;
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("isFromQuery", this.isFromQuery);
        discloser.addProperty("isFromUser", this.isFromUser);
        discloser.addProperty("locked", this.locked);
        discloser.addProperty("rawWord", this.rawWord);
        discloser.addProperty("stemmed", this.stemmed);
    }

    @Override
    public SegmentingRule getSegmentingRule() {
        return this.segmentingRule;
    }

    public void setSegmentingRule(SegmentingRule segmentingRule) {
        this.segmentingRule = segmentingRule;
    }
}

