/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yahoo.search.yql.Location;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class OperatorNode<T extends Operator> {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Location location;
    private final T operator;
    private Map<String, Object> annotations = ImmutableMap.of();
    private final Object[] args;
    private static final Function<Object, Object> COPY = new Function<Object, Object>(){

        @Nullable
        public Object apply(@Nullable Object input) {
            if (input instanceof List) {
                ArrayList newList = Lists.newArrayListWithExpectedSize((int)((List)input).size());
                for (Object val : (List)input) {
                    newList.add(COPY.apply(val));
                }
                return newList;
            }
            if (input instanceof OperatorNode) {
                return ((OperatorNode)input).copy();
            }
            if (input instanceof String || input instanceof Number || input instanceof Boolean) {
                return input;
            }
            throw new IllegalArgumentException("Unexpected value type in OperatorNode tree: " + input);
        }
    };

    public static <T extends Operator> OperatorNode<T> create(T operator, Object ... args) {
        operator.checkArguments(args == null ? EMPTY_ARGS : args);
        return new OperatorNode<T>(operator, args);
    }

    public static <T extends Operator> OperatorNode<T> create(Location loc, T operator, Object ... args) {
        operator.checkArguments(args == null ? EMPTY_ARGS : args);
        return new OperatorNode<T>(loc, operator, args);
    }

    public static <T extends Operator> OperatorNode<T> create(Location loc, Map<String, Object> annotations, T operator, Object ... args) {
        operator.checkArguments(args == null ? EMPTY_ARGS : args);
        return new OperatorNode<T>(loc, annotations, operator, args);
    }

    private OperatorNode(T operator, Object ... args) {
        this.location = null;
        this.operator = operator;
        this.args = args == null ? EMPTY_ARGS : args;
    }

    private OperatorNode(Location loc, T operator, Object ... args) {
        this.location = loc;
        this.operator = operator;
        this.args = args == null ? EMPTY_ARGS : args;
    }

    private OperatorNode(Location loc, Map<String, Object> annotations, T operator, Object ... args) {
        this.location = loc;
        this.operator = operator;
        this.annotations = ImmutableMap.copyOf(annotations);
        this.args = args == null ? EMPTY_ARGS : args;
    }

    public T getOperator() {
        return this.operator;
    }

    public Object[] getArguments() {
        if (this.args.length == 0) {
            return this.args;
        }
        Object[] copy = new Object[this.args.length];
        System.arraycopy(this.args, 0, copy, 0, this.args.length);
        return copy;
    }

    public <T> T getArgument(int i) {
        return (T)this.args[i];
    }

    public <T> T getArgument(int i, Class<T> clazz) {
        return clazz.cast(this.getArgument(i));
    }

    public Location getLocation() {
        return this.location;
    }

    public Object getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public OperatorNode<T> putAnnotation(String name, Object value) {
        if (this.annotations.isEmpty()) {
            this.annotations = Maps.newLinkedHashMap();
        } else if (this.annotations instanceof ImmutableMap) {
            this.annotations = Maps.newLinkedHashMap(this.annotations);
        }
        this.annotations.put(name, value);
        return this;
    }

    public Map<String, Object> getAnnotations() {
        return ImmutableMap.copyOf(this.annotations);
    }

    public OperatorNode<T> transform(Function<Object, Object> argumentTransform) {
        if (this.args.length == 0) {
            return this;
        }
        Object[] newArgs = new Object[this.args.length];
        boolean changed = false;
        for (int i = 0; i < this.args.length; ++i) {
            Object target = this.args[i];
            if (target instanceof List) {
                ArrayList newList = Lists.newArrayListWithExpectedSize((int)((List)target).size());
                for (Object val : (List)target) {
                    newList.add(argumentTransform.apply(val));
                }
                newArgs[i] = newList;
            } else {
                newArgs[i] = argumentTransform.apply(this.args[i]);
            }
            changed = changed || newArgs[i] != this.args[i];
        }
        if (changed) {
            return new OperatorNode<T>(this.location, this.annotations, this.operator, newArgs);
        }
        return this;
    }

    public void visit(OperatorVisitor visitor) {
        if (visitor.enter(this)) {
            for (Object target : this.args) {
                if (target instanceof List) {
                    for (Object val : (List)target) {
                        if (!(val instanceof OperatorNode)) continue;
                        ((OperatorNode)val).visit(visitor);
                    }
                    continue;
                }
                if (!(target instanceof OperatorNode)) continue;
                ((OperatorNode)target).visit(visitor);
            }
        }
        visitor.exit(this);
    }

    public OperatorNode<T> copy() {
        Object[] newArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            newArgs[i] = COPY.apply(this.args[i]);
        }
        return new OperatorNode<T>(this.location, (Map<String, Object>)ImmutableMap.copyOf(this.annotations), this.operator, newArgs);
    }

    public void toString(StringBuilder output) {
        output.append("(").append(this.operator.name());
        if (this.location != null) {
            output.append(" L").append(this.location.getCharacterOffset()).append(":").append(this.location.getLineNumber());
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            output.append(" {");
            Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(output, this.annotations);
            output.append("}");
        }
        boolean first = true;
        for (Object arg : this.args) {
            if (!first) {
                output.append(",");
            }
            first = false;
            output.append(" ");
            if (arg instanceof OperatorNode) {
                ((OperatorNode)arg).toString(output);
                continue;
            }
            if (arg instanceof Iterable) {
                output.append("[");
                Joiner.on((String)", ").appendTo(output, (Iterable)arg);
                output.append("]");
                continue;
            }
            output.append(arg.toString());
        }
        output.append(")");
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        this.toString(output);
        return output.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorNode that = (OperatorNode)o;
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        return this.operator.equals(that.operator);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

