/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.search.query.profile.CopyOnWriteContent;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProfileVariant
implements Cloneable,
Comparable<QueryProfileVariant> {
    private List<QueryProfile> inherited = null;
    private DimensionValues dimensionValues;
    private Map<String, Object> values;
    private boolean frozen = false;
    private QueryProfile owner;

    public QueryProfileVariant(DimensionValues dimensionValues, QueryProfile owner) {
        this.dimensionValues = dimensionValues;
        this.owner = owner;
    }

    public DimensionValues getDimensionValues() {
        return this.dimensionValues;
    }

    public Map<String, Object> values() {
        if (this.values == null) {
            if (this.frozen) {
                return Collections.emptyMap();
            }
            this.values = new HashMap<String, Object>();
        }
        return this.values;
    }

    public List<QueryProfile> inherited() {
        if (this.inherited == null) {
            if (this.frozen) {
                return Collections.emptyList();
            }
            this.inherited = new ArrayList<QueryProfile>();
        }
        return this.inherited;
    }

    public void set(String key, Object newValue) {
        Object oldValue;
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        if ((oldValue = this.values.get(key)) == null) {
            this.values.put(key, newValue);
        } else {
            Object combinedOrNull = QueryProfile.combineValues(newValue, oldValue);
            if (combinedOrNull != null) {
                this.values.put(key, combinedOrNull);
            }
        }
    }

    public void inherit(QueryProfile profile) {
        if (this.inherited == null) {
            this.inherited = new ArrayList<QueryProfile>(1);
        }
        this.inherited.add(profile);
    }

    @Override
    public int compareTo(QueryProfileVariant other) {
        return this.dimensionValues.compareTo(other.dimensionValues);
    }

    public boolean matches(DimensionValues givenDimensionValues) {
        return this.dimensionValues.matches(givenDimensionValues);
    }

    public void accept(boolean allowContent, QueryProfileType type, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        if (allowContent) {
            String key = visitor.getLocalKey();
            if (key != null) {
                if (type != null) {
                    type.unalias(key);
                }
                visitor.acceptValue(key, this.values().get(key), dimensionBinding, this.owner);
                if (visitor.isDone()) {
                    return;
                }
            } else {
                for (Map.Entry<String, Object> entry : this.values().entrySet()) {
                    visitor.acceptValue(entry.getKey(), entry.getValue(), dimensionBinding, this.owner);
                    if (!visitor.isDone()) continue;
                    return;
                }
            }
        }
        for (QueryProfile profile : this.inherited()) {
            if (visitor.visitInherited()) {
                profile.accept(allowContent, visitor, dimensionBinding.createFor(profile.getDimensions()), this.owner);
            }
            if (!visitor.isDone()) continue;
            return;
        }
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        if (this.inherited != null) {
            this.inherited = ImmutableList.copyOf(this.inherited);
        }
        if (this.values != null) {
            this.values = ImmutableMap.copyOf(this.values);
        }
        this.frozen = true;
    }

    public QueryProfileVariant clone() {
        if (this.frozen) {
            return this;
        }
        try {
            QueryProfileVariant clone = (QueryProfileVariant)super.clone();
            if (this.inherited != null) {
                clone.inherited = new ArrayList<QueryProfile>(this.inherited);
            }
            clone.values = CopyOnWriteContent.deepClone(this.values);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "query profile variant for " + this.dimensionValues;
    }
}

