/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.BackedOverridableQueryProfile;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.QueryProfileVariant;
import com.yahoo.search.query.profile.QueryProfileVariants;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.DimensionalMap;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryProfileCompiler {
    private static final Logger log = Logger.getLogger(QueryProfileCompiler.class.getName());

    public static CompiledQueryProfileRegistry compile(QueryProfileRegistry input) {
        CompiledQueryProfileRegistry output = new CompiledQueryProfileRegistry(input.getTypeRegistry());
        for (QueryProfile inputProfile : input.allComponents()) {
            output.register(QueryProfileCompiler.compile(inputProfile, output));
        }
        return output;
    }

    public static CompiledQueryProfile compile(QueryProfile in, CompiledQueryProfileRegistry registry) {
        DimensionalMap.Builder<CompoundName, Object> values = new DimensionalMap.Builder<CompoundName, Object>();
        DimensionalMap.Builder<CompoundName, QueryProfileType> types = new DimensionalMap.Builder<CompoundName, QueryProfileType>();
        DimensionalMap.Builder<CompoundName, Boolean> references = new DimensionalMap.Builder<CompoundName, Boolean>();
        DimensionalMap.Builder<CompoundName, Boolean> unoverridables = new DimensionalMap.Builder<CompoundName, Boolean>();
        HashSet<DimensionBindingForPath> variants = new HashSet<DimensionBindingForPath>();
        QueryProfileCompiler.collectVariants(CompoundName.empty, in, DimensionBinding.nullBinding, variants);
        variants.add(new DimensionBindingForPath(DimensionBinding.nullBinding, CompoundName.empty));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Compiling " + in.toString() + " having " + variants.size() + " variants");
        }
        int i = 0;
        for (DimensionBindingForPath variant : variants) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("    Compiling variant " + i++ + ": " + variant);
            }
            for (Map.Entry<String, Object> entry : in.listValues(variant.path(), variant.binding().getContext(), null).entrySet()) {
                values.put(variant.path().append(entry.getKey()), variant.binding(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : in.listTypes(variant.path(), variant.binding().getContext()).entrySet()) {
                types.put(variant.path().append((CompoundName)entry.getKey()), variant.binding(), (QueryProfileType)((Object)entry.getValue()));
            }
            for (CompoundName compoundName : in.listReferences(variant.path(), variant.binding().getContext())) {
                references.put(variant.path().append(compoundName), variant.binding(), Boolean.TRUE);
            }
            for (CompoundName compoundName : in.listUnoverridable(variant.path(), variant.binding().getContext())) {
                unoverridables.put(variant.path().append(compoundName), variant.binding(), Boolean.TRUE);
            }
        }
        return new CompiledQueryProfile(in.getId(), in.getType(), values.build(), types.build(), references.build(), unoverridables.build(), registry);
    }

    private static void collectVariants(CompoundName path, QueryProfile profile, DimensionBinding currentVariant, Set<DimensionBindingForPath> allVariants) {
        for (QueryProfile inheritedProfile : profile.inherited()) {
            QueryProfileCompiler.collectVariants(path, inheritedProfile, currentVariant, allVariants);
        }
        QueryProfileCompiler.collectVariantsFromValues(path, profile.getContent(), currentVariant, allVariants);
        QueryProfileCompiler.collectVariantsInThis(path, profile, currentVariant, allVariants);
        if (profile instanceof BackedOverridableQueryProfile) {
            QueryProfileCompiler.collectVariantsInThis(path, ((BackedOverridableQueryProfile)profile).getBacking(), currentVariant, allVariants);
        }
    }

    private static void collectVariantsInThis(CompoundName path, QueryProfile profile, DimensionBinding currentVariant, Set<DimensionBindingForPath> allVariants) {
        QueryProfileVariants profileVariants = profile.getVariants();
        if (profileVariants != null) {
            for (QueryProfileVariant variant : profile.getVariants().getVariants()) {
                DimensionBinding combinedVariant = DimensionBinding.createFrom(profile.getDimensions(), variant.getDimensionValues()).combineWith(currentVariant);
                if (combinedVariant.isInvalid()) continue;
                QueryProfileCompiler.collectVariantsFromValues(path, variant.values(), combinedVariant, allVariants);
                for (QueryProfile variantInheritedProfile : variant.inherited()) {
                    QueryProfileCompiler.collectVariants(path, variantInheritedProfile, combinedVariant, allVariants);
                }
            }
        }
    }

    private static void collectVariantsFromValues(CompoundName path, Map<String, Object> values, DimensionBinding currentVariant, Set<DimensionBindingForPath> allVariants) {
        if (!values.isEmpty()) {
            allVariants.add(new DimensionBindingForPath(currentVariant, path));
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (!(entry.getValue() instanceof QueryProfile)) continue;
            QueryProfileCompiler.collectVariants(path.append(entry.getKey()), (QueryProfile)entry.getValue(), currentVariant, allVariants);
        }
    }

    private static class DimensionBindingForPath {
        private final DimensionBinding binding;
        private final CompoundName path;

        public DimensionBindingForPath(DimensionBinding binding, CompoundName path) {
            this.binding = binding;
            this.path = path;
        }

        public DimensionBinding binding() {
            return this.binding;
        }

        public CompoundName path() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DimensionBindingForPath)) {
                return false;
            }
            DimensionBindingForPath other = (DimensionBindingForPath)o;
            return other.binding.equals(this.binding) && other.path.equals((Object)this.path);
        }

        public int hashCode() {
            return this.binding.hashCode() + 17 * this.path.hashCode();
        }

        public String toString() {
            return this.binding + " for path " + this.path;
        }
    }
}

