/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.google.common.base.Joiner;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ComponentAdaptor;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.Target;
import com.yahoo.search.federation.sourceref.UnresolvedProviderException;
import com.yahoo.search.federation.sourceref.UnresolvedSearchChainException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class SourcesTarget
extends Target {
    private ComponentRegistry<ComponentAdaptor<SearchChainInvocationSpec>> providerSources = new ComponentRegistry<ComponentAdaptor<SearchChainInvocationSpec>>(){};
    private SearchChainInvocationSpec defaultProviderSource;

    public SourcesTarget(ComponentId sourceId) {
        super(sourceId);
    }

    @Override
    public SearchChainInvocationSpec responsibleSearchChain(Properties queryProperties) throws UnresolvedSearchChainException {
        ComponentSpecification providerSpecification = this.providerSpecificationForSource(queryProperties);
        if (providerSpecification == null) {
            return this.defaultProviderSource;
        }
        return this.lookupProviderSource(providerSpecification);
    }

    @Override
    public String searchRefDescription() {
        StringBuilder builder = new StringBuilder(this.sourceId().stringValue());
        builder.append("[provider = ").append(Joiner.on((String)", ").join(this.allProviderIdsStringValue())).append("]");
        return builder.toString();
    }

    private SortedSet<String> allProviderIdsStringValue() {
        TreeSet<String> result = new TreeSet<String>();
        for (ComponentAdaptor providerSource : this.providerSources.allComponents()) {
            result.add(providerSource.getId().stringValue());
        }
        return result;
    }

    private SearchChainInvocationSpec lookupProviderSource(ComponentSpecification providerSpecification) throws UnresolvedSearchChainException {
        ComponentAdaptor providerSource = (ComponentAdaptor)this.providerSources.getComponent(providerSpecification);
        if (providerSource == null) {
            throw UnresolvedProviderException.createForMissingProvider(this.sourceId(), providerSpecification);
        }
        return (SearchChainInvocationSpec)providerSource.model;
    }

    @Override
    public void freeze() {
        if (this.defaultProviderSource == null) {
            throw new RuntimeException("Null default provider source for source " + this.sourceId() + ".");
        }
        this.providerSources.freeze();
    }

    public void addSource(ComponentId providerId, SearchChainInvocationSpec searchChainInvocationSpec, boolean isDefaultProviderForSource) {
        this.providerSources.register(providerId, (Object)new ComponentAdaptor(providerId, (Object)searchChainInvocationSpec));
        if (isDefaultProviderForSource) {
            this.setDefaultProviderSource(searchChainInvocationSpec);
        }
    }

    private void setDefaultProviderSource(SearchChainInvocationSpec searchChainInvocationSpec) {
        if (this.defaultProviderSource != null) {
            throw new RuntimeException("Tried to set two default providers for source " + this.sourceId() + ".");
        }
        this.defaultProviderSource = searchChainInvocationSpec;
    }

    ComponentId sourceId() {
        return this.localId;
    }

    private ComponentSpecification providerSpecificationForSource(Properties queryProperties) {
        String spec = queryProperties.getString("source." + this.sourceId().stringValue() + ".provider");
        return ComponentSpecification.fromString((String)spec);
    }

    public SearchChainInvocationSpec defaultProviderSource() {
        return this.defaultProviderSource;
    }

    public List<SearchChainInvocationSpec> allProviderSources() {
        ArrayList<SearchChainInvocationSpec> allProviderSources = new ArrayList<SearchChainInvocationSpec>();
        for (ComponentAdaptor component : this.providerSources.allComponents()) {
            allProviderSources.add((SearchChainInvocationSpec)component.model);
        }
        return allProviderSources;
    }
}

