/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.net.HostName;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.Pinger;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SearchCluster
implements NodeManager<Node> {
    private static final Logger log = Logger.getLogger(SearchCluster.class.getName());
    private final DispatchConfig dispatchConfig;
    private final int size;
    private final String clusterId;
    private final ImmutableMap<Integer, Group> groups;
    private final ImmutableMultimap<String, Node> nodesByHost;
    private final ImmutableList<Group> orderedGroups;
    private final ClusterMonitor<Node> clusterMonitor;
    private final VipStatus vipStatus;
    private final Optional<Node> directDispatchTarget;
    private final FS4ResourcePool fs4ResourcePool;

    public SearchCluster(String clusterId, DispatchConfig dispatchConfig, FS4ResourcePool fs4ResourcePool, int containerClusterSize, VipStatus vipStatus) {
        this.clusterId = clusterId;
        this.dispatchConfig = dispatchConfig;
        this.size = dispatchConfig.node().size();
        this.fs4ResourcePool = fs4ResourcePool;
        this.vipStatus = vipStatus;
        ImmutableList<Node> nodes = SearchCluster.toNodes(dispatchConfig);
        ImmutableMap.Builder groupsBuilder = new ImmutableMap.Builder();
        for (Map.Entry<Integer, List<Node>> group : nodes.stream().collect(Collectors.groupingBy(Node::group)).entrySet()) {
            Group g = new Group(group.getKey(), group.getValue());
            groupsBuilder.put((Object)group.getKey(), (Object)g);
        }
        this.groups = groupsBuilder.build();
        LinkedHashMap groupIntroductionOrder = new LinkedHashMap();
        nodes.forEach(node -> groupIntroductionOrder.put(node.group(), (Group)this.groups.get((Object)node.group)));
        this.orderedGroups = ImmutableList.builder().addAll(groupIntroductionOrder.values()).build();
        ImmutableMultimap.Builder nodesByHostBuilder = new ImmutableMultimap.Builder();
        for (Node node2 : nodes) {
            nodesByHostBuilder.put((Object)node2.hostname(), (Object)node2);
        }
        this.nodesByHost = nodesByHostBuilder.build();
        this.directDispatchTarget = SearchCluster.findDirectDispatchTarget(HostName.getLocalhost(), this.size, containerClusterSize, this.nodesByHost, this.groups);
        this.clusterMonitor = new ClusterMonitor<Node>(this);
        for (Node node2 : nodes) {
            this.working(node2);
            this.clusterMonitor.add(node2, true);
        }
    }

    private static Optional<Node> findDirectDispatchTarget(String selfHostname, int searchClusterSize, int containerClusterSize, ImmutableMultimap<String, Node> nodesByHost, ImmutableMap<Integer, Group> groups) {
        ImmutableCollection localSearchNodes = nodesByHost.get((Object)selfHostname);
        if (localSearchNodes.size() != 1) {
            return Optional.empty();
        }
        Node localSearchNode = (Node)localSearchNodes.iterator().next();
        Group localSearchGroup = (Group)groups.get((Object)localSearchNode.group());
        if (localSearchGroup.nodes().size() != 1) {
            return Optional.empty();
        }
        if (containerClusterSize < searchClusterSize) {
            return Optional.empty();
        }
        return Optional.of(localSearchNode);
    }

    private static ImmutableList<Node> toNodes(DispatchConfig dispatchConfig) {
        Predicate<DispatchConfig.Node> filter;
        ImmutableList.Builder nodesBuilder = new ImmutableList.Builder();
        if (dispatchConfig.useLocalNode()) {
            String hostName = HostName.getLocalhost();
            filter = node -> node.host().equals(hostName);
        } else {
            filter = node -> true;
        }
        for (DispatchConfig.Node node2 : dispatchConfig.node()) {
            if (!filter.test(node2)) continue;
            nodesBuilder.add((Object)new Node(node2.key(), node2.host(), node2.fs4port(), node2.group()));
        }
        return nodesBuilder.build();
    }

    public DispatchConfig dispatchConfig() {
        return this.dispatchConfig;
    }

    public int size() {
        return this.size;
    }

    public ImmutableMap<Integer, Group> groups() {
        return this.groups;
    }

    public ImmutableList<Group> orderedGroups() {
        return this.orderedGroups;
    }

    public Optional<Group> group(int n) {
        if (this.orderedGroups.size() > n) {
            return Optional.of((Group)this.orderedGroups.get(n));
        }
        return Optional.empty();
    }

    public int groupSize() {
        if (this.groups.size() == 0) {
            return this.size();
        }
        return this.size() / this.groups.size();
    }

    public int groupsWithSufficientCoverage() {
        int covered = 0;
        for (Group g : this.orderedGroups) {
            if (!g.hasSufficientCoverage()) continue;
            ++covered;
        }
        return covered;
    }

    public ImmutableMultimap<String, Node> nodesByHost() {
        return this.nodesByHost;
    }

    public Optional<Node> directDispatchTarget() {
        if (!this.directDispatchTarget.isPresent()) {
            return Optional.empty();
        }
        Group localSearchGroup = (Group)this.groups.get((Object)this.directDispatchTarget.get().group());
        if (!localSearchGroup.hasSufficientCoverage()) {
            return Optional.empty();
        }
        if (!this.directDispatchTarget.get().isWorking()) {
            return Optional.empty();
        }
        return this.directDispatchTarget;
    }

    @Override
    public void working(Node node) {
        node.setWorking(true);
        if (this.usesDirectDispatchTo(node)) {
            this.vipStatus.addToRotation(this.clusterId);
        }
    }

    @Override
    public void failed(Node node) {
        node.setWorking(false);
        if (this.usesDirectDispatchTo(node)) {
            this.vipStatus.removeFromRotation(this.clusterId);
        }
    }

    private void updateSufficientCoverage(Group group, boolean sufficientCoverage) {
        if (this.usesDirectDispatchTo(group) && sufficientCoverage != group.hasSufficientCoverage()) {
            if (sufficientCoverage) {
                this.vipStatus.addToRotation(this.clusterId);
            } else {
                this.vipStatus.removeFromRotation(this.clusterId);
            }
        }
        group.setHasSufficientCoverage(sufficientCoverage);
    }

    private boolean usesDirectDispatchTo(Node node) {
        if (!this.directDispatchTarget.isPresent()) {
            return false;
        }
        return this.directDispatchTarget.get().equals(node);
    }

    private boolean usesDirectDispatchTo(Group group) {
        if (!this.directDispatchTarget.isPresent()) {
            return false;
        }
        return this.directDispatchTarget.get().group() == group.id();
    }

    @Override
    public void ping(Node node, Executor executor) {
        Pinger pinger = new Pinger(node, this.clusterMonitor, this.fs4ResourcePool);
        FutureTask<Pong> futurePong = new FutureTask<Pong>(pinger);
        executor.execute(futurePong);
        Pong pong = this.getPong(futurePong, node);
        futurePong.cancel(true);
        if (pong.badResponse()) {
            this.clusterMonitor.failed(node, pong.getError(0));
        } else {
            this.clusterMonitor.responded(node);
        }
    }

    @Override
    public void pingIterationCompleted() {
        Group group;
        int i;
        int numGroups = this.orderedGroups.size();
        if (numGroups == 1) {
            Group group2 = (Group)this.groups.values().iterator().next();
            group2.aggregateActiveDocuments();
            this.updateSufficientCoverage(group2, true);
            return;
        }
        long[] activeDocumentsInGroup = new long[numGroups];
        long sumOfActiveDocuments = 0L;
        for (i = 0; i < numGroups; ++i) {
            group = (Group)this.orderedGroups.get(i);
            group.aggregateActiveDocuments();
            activeDocumentsInGroup[i] = group.getActiveDocuments();
            sumOfActiveDocuments += activeDocumentsInGroup[i];
        }
        for (i = 0; i < numGroups; ++i) {
            group = (Group)this.orderedGroups.get(i);
            long activeDocuments = activeDocumentsInGroup[i];
            long averageDocumentsInOtherGroups = (sumOfActiveDocuments - activeDocuments) / (long)(numGroups - 1);
            boolean sufficientCoverage = this.isGroupCoverageSufficient(group.workingNodes(), group.nodes().size(), activeDocuments, averageDocumentsInOtherGroups);
            this.updateSufficientCoverage(group, sufficientCoverage);
        }
    }

    private boolean isGroupCoverageSufficient(int workingNodes, int nodesInGroup, long activeDocuments, long averageDocumentsInOtherGroups) {
        boolean sufficientCoverage = true;
        if (averageDocumentsInOtherGroups > 0L) {
            double coverage = 100.0 * (double)activeDocuments / (double)averageDocumentsInOtherGroups;
            boolean bl = sufficientCoverage = coverage >= this.dispatchConfig.minActivedocsPercentage();
        }
        if (sufficientCoverage) {
            sufficientCoverage = this.isGroupNodeCoverageSufficient(workingNodes, nodesInGroup);
        }
        return sufficientCoverage;
    }

    private boolean isGroupNodeCoverageSufficient(int workingNodes, int nodesInGroup) {
        int nodesAllowedDown = this.dispatchConfig.maxNodesDownPerGroup() + (int)((double)nodesInGroup * (100.0 - this.dispatchConfig.minGroupCoverage()) / 100.0);
        return workingNodes + nodesAllowedDown >= nodesInGroup;
    }

    private Pong getPong(FutureTask<Pong> futurePong, Node node) {
        try {
            return futurePong.get(this.clusterMonitor.getConfiguration().getFailLimit(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Exception pinging " + node, e);
            return new Pong(ErrorMessage.createUnspecifiedError("Ping was interrupted: " + node));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception pinging " + node, e);
            return new Pong(ErrorMessage.createUnspecifiedError("Execution was interrupted: " + node));
        }
        catch (TimeoutException e) {
            return new Pong(ErrorMessage.createNoAnswerWhenPingingNode("Ping thread timed out"));
        }
    }

    private void logIfInsufficientCoverage(boolean sufficient, int groupId, int nodes) {
        if (!sufficient) {
            log.warning(() -> String.format("Coverage of group %s is only %d/%d (requires %d)", groupId, nodes, this.groupSize(), this.groupSize() - this.dispatchConfig.maxNodesDownPerGroup()));
        }
    }

    public boolean isPartialGroupCoverageSufficient(int groupId, List<Node> nodes) {
        if (this.orderedGroups.size() == 1) {
            boolean sufficient = nodes.size() >= this.groupSize() - this.dispatchConfig.maxNodesDownPerGroup();
            this.logIfInsufficientCoverage(sufficient, groupId, nodes.size());
            return sufficient;
        }
        int nodesInGroup = ((Group)this.groups.get((Object)groupId)).nodes().size();
        long sumOfActiveDocuments = 0L;
        int otherGroups = 0;
        for (Group g : this.orderedGroups) {
            if (g.id() == groupId) continue;
            sumOfActiveDocuments += g.getActiveDocuments();
            ++otherGroups;
        }
        long activeDocuments = 0L;
        for (Node n : nodes) {
            activeDocuments += n.getActiveDocuments();
        }
        long averageDocumentsInOtherGroups = sumOfActiveDocuments / (long)otherGroups;
        boolean sufficient = this.isGroupCoverageSufficient(nodes.size(), nodesInGroup, activeDocuments, averageDocumentsInOtherGroups);
        this.logIfInsufficientCoverage(sufficient, groupId, nodes.size());
        return sufficient;
    }
}

