/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.google.inject.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.HashMap;
import java.util.Map;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class FieldCollapsingSearcher
extends Searcher {
    private static final CompoundName collapse = new CompoundName("collapse");
    private static final CompoundName collapsefield = new CompoundName("collapsefield");
    private static final CompoundName collapsesize = new CompoundName("collapsesize");
    private static final CompoundName collapseSummaryName = new CompoundName("collapse.summary");
    private int maxQueries = 4;
    private int defaultCollapseSize;
    private double extraFactor;

    public FieldCollapsingSearcher() {
        this((String)null);
    }

    public FieldCollapsingSearcher(String collapseField) {
        this(1, 2.0, collapseField);
    }

    @Inject
    public FieldCollapsingSearcher(QrSearchersConfig config) {
        QrSearchersConfig.Com.Yahoo.Prelude.Searcher.FieldCollapsingSearcher s = config.com().yahoo().prelude().searcher().FieldCollapsingSearcher();
        this.init(s.collapsesize(), s.extrafactor());
    }

    public FieldCollapsingSearcher(int collapseSize, double extraFactor, String collapseField) {
        this.init(collapseSize, extraFactor);
    }

    private void init(int collapseSize, double extraFactor) {
        this.defaultCollapseSize = collapseSize;
        this.extraFactor = extraFactor;
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result resultSource;
        int hitsAfterCollapse;
        String collapseField = query.properties().getString(collapsefield);
        if (collapseField == null) {
            return execution.search(query);
        }
        int collapseSize = query.properties().getInteger(collapsesize, this.defaultCollapseSize);
        query.properties().set(collapse, "0");
        int hitsToRequest = query.getHits() != 0 ? (int)Math.ceil((double)(query.getOffset() + query.getHits() + 1) * this.extraFactor) : 0;
        int nextOffset = 0;
        boolean moreHitsAvailable = true;
        HashMap<String, Integer> knownCollapses = new HashMap<String, Integer>();
        Result result = new Result(query);
        int performedQueries = 0;
        String collapseSummary = query.properties().getString(collapseSummaryName);
        do {
            resultSource = this.search(query.clone(), execution, nextOffset, hitsToRequest);
            String summaryClass = collapseSummary == null ? query.getPresentation().getSummary() : collapseSummary;
            this.fill(resultSource, summaryClass, execution);
            this.collapse(result, knownCollapses, resultSource, collapseField, collapseSize);
            hitsAfterCollapse = result.getHitCount();
            if (resultSource.getTotalHitCount() < (long)(hitsToRequest + nextOffset)) {
                moreHitsAvailable = false;
            }
            nextOffset += hitsToRequest;
            if (hitsAfterCollapse >= query.getOffset() + query.getHits()) continue;
            hitsToRequest = (int)Math.ceil((double)hitsToRequest * this.extraFactor);
        } while (hitsToRequest != 0 && hitsAfterCollapse < query.getOffset() + query.getHits() && moreHitsAvailable && ++performedQueries <= this.maxQueries);
        result.mergeWith(resultSource);
        result.hits().trim(query.getOffset(), query.getHits());
        query.properties().set(collapse, "1");
        return result;
    }

    private Result search(Query query, Execution execution, int offset, int hits) {
        query.setOffset(offset);
        query.setHits(hits);
        return execution.search(query);
    }

    private void collapse(Result result, Map<String, Integer> knownCollapses, Result resultSource, String collapseField, int collapseSize) {
        for (Hit unknownHit : resultSource.hits()) {
            String collapseId;
            if (!(unknownHit instanceof FastHit)) {
                result.hits().add(unknownHit);
                continue;
            }
            FastHit hit = (FastHit)unknownHit;
            Object peek = hit.getField(collapseField);
            String string = collapseId = peek != null ? peek.toString() : null;
            if (collapseId == null) {
                result.hits().add(hit);
                continue;
            }
            if (knownCollapses.containsKey(collapseId)) {
                int numHitsThisField = knownCollapses.get(collapseId);
                if (numHitsThisField >= collapseSize) continue;
                result.hits().add(hit);
                knownCollapses.put(collapseId, ++numHitsThisField);
                continue;
            }
            knownCollapses.put(collapseId, 1);
            result.hits().add(hit);
        }
    }
}

