/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;

public class NearItem
extends CompositeItem {
    protected int distance;
    public static final int defaultDistance = 2;

    public NearItem() {
        this.setDistance(2);
    }

    public NearItem(int distance) {
        this.setDistance(distance);
    }

    public void setDistance(int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException("Can not use negative distance '" + distance + "'.");
        }
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAR;
    }

    @Override
    public String getName() {
        return "NEAR";
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.distance, (ByteBuffer)buffer);
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("limit", this.distance);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.distance);
        buffer.append(")");
        buffer.append(" ");
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 23 * this.distance;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        NearItem other = (NearItem)object;
        return this.distance == other.distance;
    }
}

