/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import com.yahoo.prelude.hitfield.AnnotateStringFieldPart;
import com.yahoo.prelude.hitfield.BoldCloseFieldPart;
import com.yahoo.prelude.hitfield.BoldOpenFieldPart;
import com.yahoo.prelude.hitfield.FieldIterator;
import com.yahoo.prelude.hitfield.FieldPart;
import com.yahoo.prelude.hitfield.ImmutableFieldPart;
import com.yahoo.prelude.hitfield.MarkupFieldPart;
import com.yahoo.prelude.hitfield.SeparatorFieldPart;
import com.yahoo.prelude.hitfield.StringFieldPart;
import com.yahoo.prelude.hitfield.TokenFieldIterator;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.text.XML;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HitField {
    private final String name;
    private final String rawContent;
    private final boolean isCJK;
    private boolean xmlProperty;
    private List<FieldPart> tokenizedContent = null;
    private String content;
    private Object original;

    public HitField(String f, String c) {
        this(f, c, c.indexOf(31) > -1);
    }

    public HitField(String f, XMLString c) {
        this(f, c, c.toString().indexOf(31) > -1);
    }

    public HitField(String f, String c, boolean cjk) {
        this(f, c, cjk, false);
    }

    public HitField(String f, XMLString c, boolean cjk) {
        this(f, c.toString(), cjk, true);
    }

    public HitField(String f, String c, boolean cjk, boolean xmlProperty) {
        this.name = f;
        this.rawContent = c;
        this.content = null;
        this.isCJK = cjk;
        this.xmlProperty = xmlProperty;
    }

    public String getName() {
        return this.name;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    private List<FieldPart> tokenizeUnknown() {
        ArrayList<FieldPart> pre = new ArrayList<FieldPart>();
        if (this.rawContent.length() == 0) {
            return pre;
        }
        int i = 0;
        int j = 0;
        i = this.rawContent.indexOf(30);
        if (i == 0) {
            pre.add(new SeparatorFieldPart(this.rawContent.substring(0, 1)));
            j = 1;
            i = this.rawContent.indexOf(30, j);
        }
        while (i != -1) {
            this.tokenizeSnippet(pre, this.rawContent.substring(j, i));
            pre.add(new SeparatorFieldPart(this.rawContent.substring(i, i + 1)));
            j = ++i;
            i = this.rawContent.indexOf(30, j);
        }
        if (j < this.rawContent.length()) {
            this.tokenizeSnippet(pre, this.rawContent.substring(j));
        }
        return pre;
    }

    private boolean isAnnotationChar(char c) {
        return c == '\ufff9' || c == '\ufffa' || c == '\ufffb';
    }

    private void tokenizeSnippet(List<FieldPart> resultParts, String content) {
        int head;
        int tail = 0;
        boolean justFinishedIncompleteAnnotation = false;
        int numRawHighLightChars = 0;
        ArrayList<FieldPart> localParts = new ArrayList<FieldPart>();
        if (content.length() == 0) {
            return;
        }
        boolean prevHeadLetterOrDigital = Character.isLetterOrDigit(content.charAt(0));
        for (head = 0; head < content.length(); ++head) {
            boolean currHeadLetterOrDigital;
            char headChar = content.charAt(head);
            if (this.isAnnotationChar(headChar)) {
                if (headChar == '\ufff9') {
                    int nextHead = content.indexOf(65531, head);
                    boolean incompleteAnnotation = nextHead == -1;
                    boolean skippedInvalidHighlightChar = false;
                    if (head > tail) {
                        int currHead = head;
                        if (incompleteAnnotation && content.charAt(head - 1) == '\u001f' && numRawHighLightChars % 2 == 1) {
                            --currHead;
                            skippedInvalidHighlightChar = true;
                        }
                        localParts.add(this.createToken(content.substring(tail, currHead), prevHeadLetterOrDigital));
                    }
                    if (!skippedInvalidHighlightChar) {
                        localParts.add(new AnnotateStringFieldPart(content, head));
                    }
                    head = nextHead;
                } else if (headChar == '\ufffa') {
                    localParts.clear();
                    head = content.indexOf(65531, head);
                    justFinishedIncompleteAnnotation = true;
                } else if (headChar == '\ufffb') {
                    localParts.clear();
                    justFinishedIncompleteAnnotation = true;
                }
                if (head == -1) {
                    head = content.length();
                } else if (head + 1 < content.length()) {
                    prevHeadLetterOrDigital = Character.isLetterOrDigit(content.charAt(head + 1));
                }
                tail = head + 1;
                continue;
            }
            if (headChar == '\u001f') {
                if (justFinishedIncompleteAnnotation) {
                    tail = head + 1;
                } else {
                    ++numRawHighLightChars;
                }
            }
            if ((currHeadLetterOrDigital = Character.isLetterOrDigit(headChar)) != prevHeadLetterOrDigital & head > tail) {
                localParts.add(this.createToken(content.substring(tail, head), prevHeadLetterOrDigital));
                tail = head;
                prevHeadLetterOrDigital = currHeadLetterOrDigital;
            }
            justFinishedIncompleteAnnotation = false;
        }
        if (head > tail) {
            localParts.add(this.createToken(content.substring(tail), prevHeadLetterOrDigital));
        }
        resultParts.addAll(localParts);
    }

    private FieldPart createToken(String substring, boolean isToken) {
        if (this.xmlProperty) {
            return new ImmutableFieldPart(substring, isToken);
        }
        return new StringFieldPart(substring, isToken);
    }

    private List<FieldPart> tokenizePretokenized() {
        String[] pre = this.rawContent.split("\u001f+");
        ArrayList<FieldPart> tokenized = new ArrayList<FieldPart>(pre.length);
        for (int i = 0; i < pre.length; ++i) {
            tokenized.add(this.createToken(pre[i], true));
        }
        return tokenized;
    }

    private void tokenizeContent() {
        List<FieldPart> pre = this.isCJK ? this.tokenizePretokenized() : this.tokenizeUnknown();
        this.setTokenizedContentUnchecked(pre);
    }

    public List<FieldPart> getTokenizedContent() {
        ArrayList<FieldPart> l = new ArrayList<FieldPart>();
        ListIterator<FieldPart> i = this.tokenIterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    private List<FieldPart> ensureTokenized() {
        if (this.tokenizedContent == null) {
            this.tokenizeContent();
        }
        return this.tokenizedContent;
    }

    public ListIterator<FieldPart> listIterator() {
        return new FieldIterator(this.ensureTokenized(), this);
    }

    public ListIterator<FieldPart> tokenIterator() {
        return new TokenFieldIterator(this.ensureTokenized(), this);
    }

    public void setTokenizedContent(List<FieldPart> list) {
        this.tokenizedContent = new ArrayList<FieldPart>(list.size());
        Iterator<FieldPart> i = list.iterator();
        while (i.hasNext()) {
            this.tokenizedContent.add(i.next());
        }
        this.content = null;
    }

    private void setTokenizedContentUnchecked(List<FieldPart> list) {
        this.tokenizedContent = list;
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            StringBuilder buf = new StringBuilder();
            Iterator<FieldPart> iter = this.ensureTokenized().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().getContent());
            }
            this.content = buf.toString();
        }
        return this.content;
    }

    public String getContent(String boldOpenTag, String boldCloseTag, String separatorTag) {
        StringBuilder buf = new StringBuilder();
        for (FieldPart f : this.ensureTokenized()) {
            if (f instanceof BoldOpenFieldPart && boldOpenTag != null && boldOpenTag.length() > 0) {
                buf.append(boldOpenTag);
                continue;
            }
            if (f instanceof BoldCloseFieldPart && boldCloseTag != null && boldCloseTag.length() > 0) {
                buf.append(boldCloseTag);
                continue;
            }
            if (f instanceof SeparatorFieldPart && separatorTag != null && separatorTag.length() > 0) {
                buf.append(separatorTag);
                continue;
            }
            buf.append(f.getContent());
        }
        return buf.toString();
    }

    public void markDirty() {
        this.content = null;
    }

    public String quotedContent(boolean inAttribute) {
        StringBuilder xml = new StringBuilder();
        for (FieldPart f : this.ensureTokenized()) {
            if (f.isFinal()) {
                xml.append(f.getContent());
                continue;
            }
            xml.append(XML.xmlEscape((String)f.getContent(), (boolean)inAttribute));
        }
        return xml.toString();
    }

    public String quotedContent(String boldOpenTag, String boldCloseTag, String separatorTag, boolean inAttribute) {
        StringBuilder xml = new StringBuilder();
        for (FieldPart f : this.ensureTokenized()) {
            if (f instanceof BoldOpenFieldPart && boldOpenTag != null && boldOpenTag.length() > 0) {
                xml.append(boldOpenTag);
                continue;
            }
            if (f instanceof BoldCloseFieldPart && boldCloseTag != null && boldCloseTag.length() > 0) {
                xml.append(boldCloseTag);
                continue;
            }
            if (f instanceof SeparatorFieldPart && separatorTag != null && separatorTag.length() > 0) {
                xml.append(separatorTag);
                continue;
            }
            if (f.isFinal()) {
                xml.append(f.getContent());
                continue;
            }
            xml.append(XML.xmlEscape((String)f.getContent(), (boolean)inAttribute));
        }
        return xml.toString();
    }

    public String bareContent(boolean XMLQuote, boolean inAttribute) {
        StringBuilder bareContent = new StringBuilder();
        for (FieldPart f : this.ensureTokenized()) {
            if (f instanceof MarkupFieldPart) continue;
            if (XMLQuote) {
                bareContent.append(XML.xmlEscape((String)f.getContent(), (boolean)inAttribute));
                continue;
            }
            bareContent.append(f.getContent());
        }
        return bareContent.toString();
    }

    public String toString() {
        return this.getContent();
    }

    public Object getOriginal() {
        return this.original;
    }

    public void setOriginal(Object original) {
        this.original = original;
    }
}

