/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.document.DocumentId;
import com.yahoo.document.GlobalId;
import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.fs4.DocumentInfo;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class PacketWrapper
implements Cloneable {
    private static Logger log = Logger.getLogger(PacketWrapper.class.getName());
    private final int keySize;
    private ArrayList<BasicPacket> resultPackets = new ArrayList(3);
    private LinkedHashMap<DocsumPacketKey, BasicPacket> packets;
    private final Optional<Integer> distributionKey;
    private static ResultPacketComparator<BasicPacket> resultPacketComparator = new ResultPacketComparator();

    public PacketWrapper(CacheKey key, DocsumPacketKey[] packetKeys, BasicPacket[] bpackets, Optional<Integer> distributionKey) {
        this.keySize = key.byteSize();
        this.resultPackets.add(bpackets[0]);
        this.packets = new LinkedHashMap();
        this.distributionKey = distributionKey;
        Packet[] ppackets = new Packet[packetKeys.length];
        for (int i = 0; i < packetKeys.length; ++i) {
            ppackets[i] = (Packet)bpackets[i + 1];
        }
        this.addDocsums(packetKeys, ppackets);
    }

    public PacketWrapper(CacheKey key, BasicPacket[] packets) {
        this.keySize = key == null ? 0 : key.byteSize();
        this.resultPackets.add(packets[0]);
        this.packets = new LinkedHashMap();
        this.distributionKey = Optional.empty();
        for (int i = 0; i < packets.length - 1; ++i) {
            this.packets.put(new DocsumPacketKey(new GlobalId(new DocumentId("doc:test:" + i).getGlobalId()), i, null), packets[i + 1]);
        }
    }

    public QueryResultPacket getFirstResultPacket() {
        if (this.resultPackets.size() > 0) {
            return (QueryResultPacket)this.resultPackets.get(0);
        }
        return null;
    }

    public Optional<Integer> distributionKey() {
        return this.distributionKey;
    }

    public List<DocumentInfo> getDocuments(int offset, int hits) {
        ArrayList<DocumentInfo> docs = new ArrayList<DocumentInfo>(hits);
        int currentOffset = 0;
        QueryResultPacket r = this.getFirstResultPacket();
        if ((long)offset >= r.getTotalDocumentCount()) {
            return docs;
        }
        for (QueryResultPacket queryResultPacket : this.resultPackets) {
            if (queryResultPacket.getOffset() > offset + currentOffset) {
                return null;
            }
            if (queryResultPacket.getOffset() + queryResultPacket.getDocumentCount() <= currentOffset + offset) continue;
            List<DocumentInfo> documents = queryResultPacket.getDocuments();
            int packetOffset = offset + currentOffset - queryResultPacket.getOffset();
            int afterLastDoc = Math.min(documents.size(), packetOffset + hits);
            Iterator<DocumentInfo> j = documents.subList(packetOffset, afterLastDoc).iterator();
            while (docs.size() < hits && j.hasNext()) {
                docs.add(j.next());
                ++currentOffset;
            }
            if (hits != docs.size() && (long)(offset + docs.size()) < queryResultPacket.getTotalDocumentCount()) continue;
            return docs;
        }
        return null;
    }

    public void addResultPacket(QueryResultPacket resultPacket) {
        if (resultPacket.getDocumentCount() == 0) {
            return;
        }
        int insertionPoint = Collections.binarySearch(this.resultPackets, resultPacket, resultPacketComparator);
        if (insertionPoint < 0) {
            this.resultPackets.add(insertionPoint ^= 0xFFFFFFFF, resultPacket);
            this.cleanResultPackets();
        } else {
            QueryResultPacket r = (QueryResultPacket)this.resultPackets.get(insertionPoint);
            if (resultPacket.getDocumentCount() > r.getDocumentCount()) {
                this.resultPackets.set(insertionPoint, resultPacket);
                this.cleanResultPackets();
            }
        }
    }

    private void cleanResultPackets() {
        if (this.resultPackets.size() == 1) {
            return;
        }
        QueryResultPacket previous = (QueryResultPacket)this.resultPackets.get(0);
        for (int i = 1; i < this.resultPackets.size(); ++i) {
            QueryResultPacket r = (QueryResultPacket)this.resultPackets.get(i);
            if (r.getOffset() + r.getDocumentCount() <= previous.getOffset() + previous.getDocumentCount()) {
                this.resultPackets.remove(i--);
                continue;
            }
            previous = r;
        }
        for (int marker = 0; marker < this.resultPackets.size() - 2; ++marker) {
            QueryResultPacket r0 = (QueryResultPacket)this.resultPackets.get(marker);
            QueryResultPacket r1 = (QueryResultPacket)this.resultPackets.get(marker + 1);
            QueryResultPacket r2 = (QueryResultPacket)this.resultPackets.get(marker + 2);
            int nextOffset = r0.getOffset() + r0.getDocumentCount();
            if (r1.getOffset() >= nextOffset || r2.getOffset() > nextOffset) continue;
            this.resultPackets.remove(marker + 1);
        }
    }

    public List<BasicPacket> getResultPackets() {
        return this.resultPackets;
    }

    public void addDocsums(DocsumPacketKey[] packetKeys, BasicPacket[] bpackets, int offset) {
        Packet[] ppackets = new Packet[packetKeys.length];
        for (int i = 0; i < packetKeys.length; ++i) {
            ppackets[i] = (Packet)bpackets[i + offset];
        }
        this.addDocsums(packetKeys, ppackets);
    }

    public void addDocsums(DocsumPacketKey[] packetKeys, Packet[] packets) {
        if (packetKeys == null || packets == null) {
            log.warning("addDocsums called with " + (packetKeys == null ? "packetKeys == null " : "") + (packets == null ? "packets == null" : ""));
            return;
        }
        for (int i = 0; i < packetKeys.length && i < packets.length; ++i) {
            if (packetKeys[i] == null) {
                log.warning("addDocsums called, but packetsKeys[" + i + "] is null");
                continue;
            }
            if (packets[i] instanceof DocsumPacket) {
                DocsumPacket dp = (DocsumPacket)packets[i];
                if (packetKeys[i].getGlobalId().equals((Object)dp.getGlobalId()) && dp.getData().length > 0) {
                    this.packets.put(packetKeys[i], packets[i]);
                    log.fine("addDocsums " + i + " globalId: " + dp.getGlobalId());
                    continue;
                }
                log.warning("not caching bad Docsum for globalId " + packetKeys[i].getGlobalId() + ": " + dp);
                continue;
            }
            log.warning("addDocsums called, but packets[" + i + "] is not a DocsumPacket instance");
        }
    }

    public int getNumPackets() {
        return this.packets.size();
    }

    BasicPacket getPacket(GlobalId globalId, int partid, String summaryClass) {
        return this.getPacket(new DocsumPacketKey(globalId, partid, summaryClass));
    }

    BasicPacket getPacket(DocsumPacketKey packetKey) {
        return this.packets.get(packetKey);
    }

    long getTimestamp() {
        return this.getFirstResultPacket().getTimestamp();
    }

    public void setTimestamp(long timestamp) {
        this.getFirstResultPacket().setTimestamp(timestamp);
    }

    public int getPacketsSize() {
        int l;
        int size = 0;
        for (QueryResultPacket queryResultPacket : this.resultPackets) {
            l = queryResultPacket.getLength();
            if (l < 0) {
                log.warning("resultpacket length " + l);
                l = 10240;
            }
            size += l;
        }
        for (BasicPacket basicPacket : this.packets.values()) {
            l = basicPacket.getLength();
            if (l < 0) {
                log.warning("BasicPacket length " + l);
                l = 10240;
            }
            size += l;
        }
        return size += this.keySize;
    }

    public Object clone() {
        try {
            PacketWrapper other = (PacketWrapper)super.clone();
            other.resultPackets = (ArrayList)this.resultPackets.clone();
            if (this.packets != null) {
                other.packets = (LinkedHashMap)this.packets.clone();
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("A non-cloneable superclass has been inserted.", e);
        }
    }

    private static class ResultPacketComparator<T extends BasicPacket>
    implements Comparator<T> {
        private ResultPacketComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            QueryResultPacket r1 = (QueryResultPacket)o1;
            QueryResultPacket r2 = (QueryResultPacket)o2;
            return r1.getOffset() - r2.getOffset();
        }
    }
}

