/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.Value;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.hitfield.JSONString;

public class JSONField
extends DocsumField {
    public JSONField(String name) {
        super(name);
    }

    public String toString() {
        return "field " + this.getName() + " type JSONString";
    }

    static Inspector convertTop(Inspector value) {
        if (value.type() == Type.ARRAY && value.entryCount() > 0) {
            Inspector first = value.entry(0);
            if (first.type() == Type.ARRAY && first.entryCount() == 2) {
                WsConv1 conv = new WsConv1();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.OBJECT && first.fieldCount() == 2 && first.field("item").valid() && first.field("weight").valid()) {
                WsConv2 conv = new WsConv2();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.LONG) {
                ArrConv conv = new ArrConv();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.DOUBLE) {
                ArrConv conv = new ArrConv();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
        }
        return value;
    }

    @Override
    public Object convert(Inspector value) {
        if (value.valid()) {
            return new JSONString(JSONField.convertTop(value));
        }
        return new JSONString("");
    }

    private static class WsConv2
    extends CompatibilityConverter
    implements ArrayTraverser {
        private WsConv2() {
        }

        public void entry(int idx, Inspector value) {
            Value.ArrayValue obj = new Value.ArrayValue();
            obj.add(this.stringify(value.field("item")));
            obj.add(value.field("weight"));
            this.target.add((Inspector)obj);
        }
    }

    private static class WsConv1
    extends CompatibilityConverter
    implements ArrayTraverser {
        private WsConv1() {
        }

        public void entry(int idx, Inspector value) {
            Value.ArrayValue obj = new Value.ArrayValue();
            obj.add(this.stringify(value.entry(0)));
            obj.add(value.entry(1));
            this.target.add((Inspector)obj);
        }
    }

    private static class ArrConv
    extends CompatibilityConverter
    implements ArrayTraverser {
        private ArrConv() {
        }

        public void entry(int idx, Inspector value) {
            this.target.add(this.stringify(value));
        }
    }

    private static class CompatibilityConverter {
        Value.ArrayValue target = new Value.ArrayValue();

        private CompatibilityConverter() {
        }

        Inspector stringify(Inspector value) {
            if (value.type() == Type.STRING) {
                return value;
            }
            if (value.type() == Type.LONG) {
                String str = String.valueOf(value.asLong());
                return new Value.StringValue(str);
            }
            if (value.type() == Type.DOUBLE) {
                String str = String.valueOf(value.asDouble());
                return new Value.StringValue(str);
            }
            String str = value.toString();
            return new Value.StringValue(str);
        }
    }
}

