/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.SearchDefinition;
import com.yahoo.search.config.IndexInfoConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class IndexModel {
    private static final Logger log = Logger.getLogger(IndexModel.class.getName());
    private Map<String, List<String>> masterClusters;
    private Map<String, SearchDefinition> searchDefinitions;
    private SearchDefinition unionSearchDefinition;

    public IndexModel(Map<String, List<String>> masterClusters, Collection<SearchDefinition> searchDefinitions) {
        this.masterClusters = masterClusters;
        this.searchDefinitions = searchDefinitions.stream().collect(Collectors.toMap(sd -> sd.getName(), sd -> sd));
        this.unionSearchDefinition = this.unionOf(searchDefinitions);
    }

    @Deprecated
    public IndexModel(Map<String, List<String>> masterClusters, Map<String, SearchDefinition> searchDefinitions, SearchDefinition unionSearchDefinition) {
        this.masterClusters = masterClusters;
        this.searchDefinitions = searchDefinitions;
        this.unionSearchDefinition = unionSearchDefinition;
    }

    public IndexModel(IndexInfoConfig indexInfo, QrSearchersConfig clusters) {
        this(indexInfo, IndexModel.toClusters(clusters));
    }

    public IndexModel(IndexInfoConfig indexInfo, Map<String, List<String>> clusters) {
        if (indexInfo != null) {
            this.searchDefinitions = IndexModel.toSearchDefinitions(indexInfo);
            this.unionSearchDefinition = this.unionOf(this.searchDefinitions.values());
        } else {
            this.searchDefinitions = null;
            this.unionSearchDefinition = null;
        }
        this.masterClusters = clusters;
    }

    private static Map<String, List<String>> toClusters(QrSearchersConfig config) {
        if (config == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> clusters = new HashMap<String, List<String>>();
        for (int i = 0; i < config.searchcluster().size(); ++i) {
            ArrayList<String> docTypes = new ArrayList<String>();
            String clusterName = config.searchcluster(i).name();
            for (int j = 0; j < config.searchcluster(i).searchdef().size(); ++j) {
                docTypes.add(config.searchcluster(i).searchdef(j));
            }
            clusters.put(clusterName, docTypes);
        }
        return clusters;
    }

    private static Map<String, SearchDefinition> toSearchDefinitions(IndexInfoConfig c) {
        SearchDefinition sd;
        HashMap<String, SearchDefinition> searchDefinitions = new HashMap<String, SearchDefinition>();
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = new SearchDefinition(info.name());
            for (IndexInfoConfig.Indexinfo.Command command : info.command()) {
                sd.addCommand(command.indexname(), command.command());
            }
            searchDefinitions.put(info.name(), sd);
        }
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = (SearchDefinition)searchDefinitions.get(info.name());
            for (IndexInfoConfig.Indexinfo.Alias alias : info.alias()) {
                String aliasString = alias.alias();
                String indexString = alias.indexname();
                sd.addAlias(aliasString, indexString);
            }
        }
        return searchDefinitions;
    }

    private SearchDefinition unionOf(Collection<SearchDefinition> searchDefinitions) {
        SearchDefinition union = new SearchDefinition("unionOfAllKnown");
        for (SearchDefinition sd : searchDefinitions) {
            for (Index index : sd.indices().values()) {
                union.getOrCreateIndex(index.getName());
                for (String command : index.allCommands()) {
                    union.addCommand(index.getName(), command);
                }
                for (String alias : index.aliases()) {
                    try {
                        union.addAlias(alias, index.getName());
                    }
                    catch (IllegalArgumentException e) {
                        log.fine("Conflicting alias '" + alias + " of " + index + " in " + sd + " will not take effect for queries which does not specify that search definition");
                    }
                }
            }
        }
        return union;
    }

    public Map<String, List<String>> getMasterClusters() {
        return this.masterClusters;
    }

    public Map<String, SearchDefinition> getSearchDefinitions() {
        return this.searchDefinitions;
    }

    @Deprecated
    public SearchDefinition getUnionSearchDefinition() {
        return this.unionSearchDefinition;
    }
}

