/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacketData;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.prelude.query.Item;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.Ranking;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;
import java.util.List;

public class QueryPacket
extends Packet {
    private final String serverId;
    private final Query query;
    private QueryPacketData queryPacketData;
    private int sessionOffset = 0;
    private int sessionSize = 0;
    private int ignoreableOffset = 0;
    private int ignoreableSize = 0;
    private static final int QF_PARSEDQUERY = 2;
    private static final int QF_RANKP = 4;
    private static final int QF_SORTSPEC = 128;
    private static final int QF_LOCATION = 2048;
    private static final int QF_PROPERTIES = 0x100000;
    private static final int QF_GROUPSPEC = 0x400000;
    private static final int QF_SESSIONID = 0x800000;
    private static final int QFLAG_EXTENDED_COVERAGE = 1;
    private static final int QFLAG_COVERAGE_NODES = 2;
    private static final int QFLAG_ESTIMATE = 128;
    private static final int QFLAG_DROP_SORTDATA = 16384;
    private static final int QFLAG_NO_RESULTCACHE = 65536;
    private static final int QFLAG_DUMP_FEATURES = 262144;

    private QueryPacket(String serverId, Query query) {
        this.serverId = serverId;
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    public static QueryPacket create(String serverId, Query query) {
        return new QueryPacket(serverId, query);
    }

    public int getOffset() {
        return this.query.getOffset();
    }

    public int getLastOffset() {
        return this.getOffset() + this.getHits();
    }

    public int getHits() {
        return this.query.getHits();
    }

    private byte[] getSummaryClassAsUtf8() {
        if (this.query.getPresentation().getSummary() != null) {
            return Utf8.toBytes((String)this.query.getPresentation().getSummary());
        }
        return new byte[0];
    }

    private int getSessionKeySkipLength() {
        return this.sessionSize > 0 ? this.sessionSize + 4 : 0;
    }

    public byte[] getOpaqueCacheKey() {
        byte[] utf8Summary = this.getSummaryClassAsUtf8();
        byte[] stripped = new byte[this.encodedBody.length - (this.ignoreableSize + this.getSessionKeySkipLength()) + utf8Summary.length + 1];
        System.arraycopy(this.encodedBody, 0, stripped, 0, this.ignoreableOffset);
        stripped[1] = (byte)(stripped[1] & 0x7F);
        System.arraycopy(utf8Summary, 0, stripped, this.ignoreableOffset, utf8Summary.length);
        stripped[this.ignoreableOffset + utf8Summary.length] = 0;
        System.arraycopy(this.encodedBody, this.ignoreableOffset + this.ignoreableSize, stripped, this.ignoreableOffset + utf8Summary.length + 1, this.sessionOffset - (this.ignoreableOffset + this.ignoreableSize));
        System.arraycopy(this.encodedBody, this.sessionOffset + this.getSessionKeySkipLength(), stripped, utf8Summary.length + 1 + (this.sessionOffset - this.ignoreableSize), this.encodedBody.length - (this.sessionOffset + this.getSessionKeySkipLength()));
        return stripped;
    }

    @Override
    public void encodeBody(ByteBuffer buffer) {
        this.queryPacketData = new QueryPacketData();
        int relativeZero = buffer.position();
        boolean sendSessionKey = this.query.getGroupingSessionCache() || this.query.getRanking().getQueryCache();
        int featureFlag = this.getFeatureInt(sendSessionKey);
        buffer.putInt(featureFlag);
        this.ignoreableOffset = buffer.position() - relativeZero;
        IntegerCompressor.putCompressedPositiveNumber((int)this.getOffset(), (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.getHits(), (ByteBuffer)buffer);
        buffer.putInt(Math.max(1, (int)this.query.getTimeLeft()));
        this.ignoreableSize = buffer.position() - relativeZero - this.ignoreableOffset;
        buffer.putInt(this.getFlagInt());
        int startOfFieldToSave = buffer.position();
        Item.putString(this.query.getRanking().getProfile(), buffer);
        this.queryPacketData.setRankProfile(buffer, startOfFieldToSave);
        if ((featureFlag & 0x100000) != 0) {
            startOfFieldToSave = buffer.position();
            this.query.encodeAsProperties(buffer, true);
            this.queryPacketData.setPropertyMaps(buffer, startOfFieldToSave);
        }
        if ((featureFlag & 0x80) != 0) {
            int sortSpecLengthPosition = buffer.position();
            buffer.putInt(0);
            int sortSpecLength = this.query.getRanking().getSorting().encode(buffer);
            buffer.putInt(sortSpecLengthPosition, sortSpecLength);
        }
        if ((featureFlag & 0x400000) != 0) {
            List<Grouping> groupingList = GroupingExecutor.getGroupingList(this.query);
            BufferSerializer gbuf = new BufferSerializer(new GrowableByteBuffer());
            gbuf.putInt(null, groupingList.size());
            for (Grouping g : groupingList) {
                g.serialize((Serializer)gbuf);
            }
            gbuf.getBuf().flip();
            byte[] blob = new byte[gbuf.getBuf().limit()];
            gbuf.getBuf().get(blob);
            buffer.putInt(blob.length);
            buffer.put(blob);
        }
        this.sessionOffset = buffer.position() - relativeZero;
        if (sendSessionKey) {
            Utf8String key = this.query.getSessionId(this.serverId).asUtf8String();
            this.sessionSize = key.getByteLength();
            buffer.putInt(key.getByteLength());
            buffer.put(key.getBytes());
        }
        if ((featureFlag & 0x800) != 0) {
            startOfFieldToSave = buffer.position();
            int locationLengthPosition = buffer.position();
            buffer.putInt(0);
            int locationLength = this.query.getRanking().getLocation().encode(buffer);
            buffer.putInt(locationLengthPosition, locationLength);
            this.queryPacketData.setLocation(buffer, startOfFieldToSave);
        }
        startOfFieldToSave = buffer.position();
        int stackItemPosition = buffer.position();
        buffer.putInt(0);
        int stackLengthPosition = buffer.position();
        buffer.putInt(0);
        int stackPosition = buffer.position();
        int stackItemCount = this.query.encode(buffer);
        int stackLength = buffer.position() - stackPosition;
        buffer.putInt(stackItemPosition, stackItemCount);
        buffer.putInt(stackLengthPosition, stackLength);
        this.queryPacketData.setQueryStack(buffer, startOfFieldToSave);
    }

    private int getFeatureInt(boolean sendSessionId) {
        int features = 6;
        features |= this.query.getRanking().getSorting() != null ? 128 : 0;
        features |= this.query.getRanking().getLocation() != null ? 2048 : 0;
        features |= this.query.hasEncodableProperties() ? 0x100000 : 0;
        features |= GroupingExecutor.hasGroupingList(this.query) ? 0x400000 : 0;
        return features |= sendSessionId ? 0x800000 : 0;
    }

    private int getFlagInt() {
        int flags = QueryPacket.getQueryFlags(this.query);
        this.queryPacketData.setQueryFlags(flags);
        return flags |= 0x4000;
    }

    @Override
    public int getCode() {
        return 218;
    }

    @Override
    public String toString() {
        return "Query x packet [query: " + this.query + "]";
    }

    static int getQueryFlags(Query query) {
        int flags = 3;
        flags |= query.properties().getBoolean(Model.ESTIMATE) ? 128 : 0;
        flags |= query.getNoCache() ? 65536 : 0;
        return flags |= query.properties().getBoolean(Ranking.RANKFEATURES, false) ? 262144 : 0;
    }

    public QueryPacketData getQueryPacketData() {
        if (this.queryPacketData == null) {
            throw new IllegalStateException("Trying to fetch a hit tag without having encoded the packet first.");
        }
        return this.queryPacketData;
    }
}

