/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FutureResult
extends FutureTask<Result> {
    private final Query query;
    private final Execution execution;
    private static final Logger log = Logger.getLogger(FutureResult.class.getName());

    public FutureResult(Callable<Result> callable, Execution execution, Query query) {
        super(callable);
        this.query = query;
        this.execution = execution;
    }

    @Override
    public Result get() {
        try {
            return (Result)super.get();
        }
        catch (InterruptedException e) {
            return new Result(this.getQuery(), this.createInterruptedError(e));
        }
        catch (ExecutionException e) {
            return new Result(this.getQuery(), this.createExecutionError(e));
        }
    }

    @Override
    public Result get(long timeout, TimeUnit timeunit) {
        return this.getIfAvailable(timeout, timeunit).orElseGet(() -> new Result(this.getQuery(), this.createTimeoutError()));
    }

    public Optional<Result> getIfAvailable(long timeout, TimeUnit timeunit) {
        try {
            return Optional.of((Result)super.get(timeout, timeunit));
        }
        catch (InterruptedException e) {
            return Optional.of(new Result(this.getQuery(), this.createInterruptedError(e)));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof com.yahoo.search.federation.TimeoutException) {
                return Optional.empty();
            }
            return Optional.of(new Result(this.getQuery(), this.createExecutionError(e)));
        }
        catch (TimeoutException e) {
            return Optional.empty();
        }
    }

    public Query getQuery() {
        return this.query;
    }

    private ErrorMessage createInterruptedError(Exception e) {
        return ErrorMessage.createUnspecifiedError("'" + this.execution + "' was interrupted while executing: " + Exceptions.toMessageString((Throwable)e));
    }

    private ErrorMessage createExecutionError(Exception e) {
        log.log(Level.WARNING, "Exception on executing " + this.execution + " for " + this.query, e);
        return ErrorMessage.createErrorInPluginSearcher("Error in '" + this.execution + "': " + Exceptions.toMessageString((Throwable)e), e.getCause());
    }

    public ErrorMessage createTimeoutError() {
        return ErrorMessage.createTimeout("Error executing '" + this.execution + "':  Chain timed out.");
    }
}

