/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import java.util.List;

final class SingleValueQueryProfileVisitor
extends QueryProfileVisitor {
    private Object value = null;
    private final List<String> name;
    private int nameIndex = -1;
    private final boolean allowQueryProfileResult;
    private boolean enteringContent = true;

    public SingleValueQueryProfileVisitor(List<String> name, boolean allowQueryProfileResult) {
        this.name = name;
        this.allowQueryProfileResult = allowQueryProfileResult;
    }

    @Override
    public String getLocalKey() {
        return this.name.get(this.nameIndex);
    }

    @Override
    public boolean enter(String name) {
        if (this.nameIndex + 1 < this.name.size()) {
            ++this.nameIndex;
            this.enteringContent = true;
        } else {
            this.enteringContent = false;
        }
        return this.enteringContent;
    }

    @Override
    public void leave(String name) {
        --this.nameIndex;
    }

    @Override
    public void onValue(String key, Object value, DimensionBinding binding, QueryProfile owner) {
        if (this.nameIndex == this.name.size() - 1) {
            this.value = value;
        }
    }

    @Override
    public void onQueryProfile(QueryProfile profile, DimensionBinding binding, QueryProfile owner) {
        if (this.enteringContent) {
            return;
        }
        this.value = this.allowQueryProfileResult ? profile : profile.getValue();
    }

    @Override
    public boolean isDone() {
        return this.value != null;
    }

    public Object getResult() {
        return this.value;
    }

    public String toString() {
        return "a single value visitor (hash " + this.hashCode() + ") with current value " + this.value;
    }
}

