/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.fs4.QueryPacket;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.CloseableInvoker;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.searchchain.Execution;
import java.io.IOException;
import java.util.Optional;

public abstract class SearchInvoker
extends CloseableInvoker {
    private final Optional<Node> node;
    private ResponseMonitor<SearchInvoker> monitor;

    protected SearchInvoker(Optional<Node> node) {
        this.node = node;
    }

    public Result search(Query query, QueryPacket queryPacket, Execution execution) throws IOException {
        this.sendSearchRequest(query, queryPacket);
        Result result = this.getSearchResult(execution);
        this.setFinalStatus(result.hits().getError() == null);
        return result;
    }

    protected abstract void sendSearchRequest(Query var1, QueryPacket var2) throws IOException;

    protected abstract Result getSearchResult(Execution var1) throws IOException;

    protected void setMonitor(ResponseMonitor<SearchInvoker> monitor) {
        this.monitor = monitor;
    }

    protected void responseAvailable() {
        if (this.monitor != null) {
            this.monitor.responseAvailable(this);
        }
    }

    protected Optional<Integer> distributionKey() {
        return this.node.map(Node::key);
    }
}

