/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.fs4.QueryPacket;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.io.IOException;
import java.util.Optional;

public class SearchErrorInvoker
extends SearchInvoker {
    private final ErrorMessage message;
    private Query query;
    private final Coverage coverage;
    private ResponseMonitor<SearchInvoker> monitor;

    public SearchErrorInvoker(ErrorMessage message, Coverage coverage) {
        super(Optional.empty());
        this.message = message;
        this.coverage = coverage;
    }

    public SearchErrorInvoker(ErrorMessage message) {
        this(message, null);
    }

    @Override
    protected void sendSearchRequest(Query query, QueryPacket queryPacket) throws IOException {
        this.query = query;
        if (this.monitor != null) {
            this.monitor.responseAvailable(this);
        }
    }

    @Override
    protected Result getSearchResult(Execution execution) throws IOException {
        Result res = new Result(this.query, this.message);
        if (this.coverage != null) {
            res.setCoverage(this.coverage);
        }
        return res;
    }

    @Override
    protected void release() {
    }

    @Override
    protected void setMonitor(ResponseMonitor<SearchInvoker> monitor) {
        this.monitor = monitor;
    }
}

