/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.google.common.collect.ImmutableMap;
import com.yahoo.compress.Compressor;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.Client;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.RpcClient;
import com.yahoo.search.dispatch.RpcFillInvoker;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.Map;
import java.util.Optional;

public class RpcResourcePool {
    public static final CompoundName dispatchCompression = new CompoundName("dispatch.compression");
    private static final CompoundName dispatchSummaries = new CompoundName("dispatch.summaries");
    private final Compressor compressor = new Compressor();
    private final Client client;
    private final ImmutableMap<Integer, Client.NodeConnection> nodeConnections;

    public RpcResourcePool(Client client, Map<Integer, Client.NodeConnection> nodeConnections) {
        this.client = client;
        this.nodeConnections = ImmutableMap.copyOf(nodeConnections);
    }

    public RpcResourcePool(DispatchConfig dispatchConfig) {
        this.client = new RpcClient();
        ImmutableMap.Builder nodeConnectionsBuilder = new ImmutableMap.Builder();
        for (DispatchConfig.Node node : dispatchConfig.node()) {
            nodeConnectionsBuilder.put((Object)node.key(), (Object)this.client.createConnection(node.host(), node.port()));
        }
        this.nodeConnections = nodeConnectionsBuilder.build();
    }

    public Optional<FillInvoker> getFillInvoker(Query query, VespaBackEndSearcher searcher, DocumentDatabase documentDb) {
        if (query.properties().getBoolean(dispatchSummaries, true) && !searcher.summaryNeedsQuery(query) && query.getRanking().getLocation() == null) {
            return Optional.of(new RpcFillInvoker(this, documentDb));
        }
        return Optional.empty();
    }

    public FillInvoker getFillInvoker(DocumentDatabase documentDb) {
        return new RpcFillInvoker(this, documentDb);
    }

    public Compressor compressor() {
        return this.compressor;
    }

    public Client client() {
        return this.client;
    }

    public ImmutableMap<Integer, Client.NodeConnection> nodeConnections() {
        return this.nodeConnections;
    }

    public void release() {
        for (Client.NodeConnection nodeConnection : this.nodeConnections.values()) {
            nodeConnection.close();
        }
    }
}

