/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.parser.AnyParser;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.util.ListIterator;
import java.util.Stack;

@After(value={"com.yahoo.search.querytransform.WandSearcher"})
@Before(value={"Stemming", "AccentRemoval"})
public class RecallSearcher
extends Searcher {
    public static final CompoundName recallName = new CompoundName("recall");

    @Override
    public Result search(Query query, Execution execution) {
        Object err;
        String recall = query.properties().getString(recallName);
        if (recall == null) {
            return execution.search(query);
        }
        AnyParser parser = new AnyParser(ParserEnvironment.fromExecutionContext(execution.context()));
        QueryTree root = parser.parse(Parsable.fromQueryModel(query.getModel()).setQuery("foo").setFilter(recall));
        if (root.getRoot() instanceof NullItem) {
            err = "Failed to parse recall parameter.";
        } else if (!(root.getRoot() instanceof CompositeItem)) {
            err = "Expected CompositeItem root node, got " + root.getClass().getSimpleName() + ".";
        } else if (RecallSearcher.hasRankItem(root.getRoot())) {
            query.getModel().getQueryTree().setRoot(root.getRoot());
            err = "Recall contains at least one rank item.";
        } else {
            WordItem placeholder = RecallSearcher.findOrigWordItem(root.getRoot(), "foo");
            if (placeholder == null) {
                err = "Could not find placeholder workQuery root.";
            } else {
                RecallSearcher.updateFilterTerms(root);
                CompositeItem parent = placeholder.getParent();
                parent.setItem(parent.getItemIndex(placeholder), query.getModel().getQueryTree().getRoot());
                query.getModel().getQueryTree().setRoot(root.getRoot());
                query.trace("ANDed recall tree with root workQuery node.", true, 3);
                return execution.search(query);
            }
        }
        return new Result(query, ErrorMessage.createInvalidQueryParameter((String)err));
    }

    private static boolean hasRankItem(Item root) {
        Stack<Item> stack = new Stack<Item>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Item item = (Item)stack.pop();
            if (item instanceof RankItem) {
                return true;
            }
            if (!(item instanceof CompositeItem)) continue;
            CompositeItem lst = (CompositeItem)item;
            ListIterator<Item> it = lst.getItemIterator();
            while (it.hasNext()) {
                stack.push((Item)it.next());
            }
        }
        return false;
    }

    private static WordItem findOrigWordItem(Item root, String value) {
        Stack<Item> stack = new Stack<Item>();
        stack.push(root);
        while (!stack.isEmpty()) {
            WordItem word;
            Item item = (Item)stack.pop();
            if (item.getCreator() == Item.ItemCreator.ORIG && item instanceof WordItem && (word = (WordItem)item).getWord().equals(value)) {
                return word;
            }
            if (!(item instanceof CompositeItem)) continue;
            CompositeItem lst = (CompositeItem)item;
            ListIterator<Item> it = lst.getItemIterator();
            while (it.hasNext()) {
                stack.push((Item)it.next());
            }
        }
        return null;
    }

    private static void updateFilterTerms(Item root) {
        Stack<Item> stack = new Stack<Item>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Item item = (Item)stack.pop();
            if (item.getCreator() == Item.ItemCreator.FILTER) {
                item.setRanked(false);
            }
            if (!(item instanceof CompositeItem)) continue;
            CompositeItem lst = (CompositeItem)item;
            ListIterator<Item> it = lst.getItemIterator();
            while (it.hasNext()) {
                stack.push((Item)it.next());
            }
        }
    }
}

