/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.collections.TinyIdentitySet;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.fs4.DocumentInfo;
import com.yahoo.fs4.FS4Properties;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryPacketData;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.fastsearch.RankProfile;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.textualrepresentation.TextualQueryRepresentation;
import com.yahoo.prelude.querytransform.QueryRewrite;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.protect.Validator;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class VespaBackEndSearcher
extends PingableSearcher {
    static final CompoundName PACKET_COMPRESSION_LIMIT = new CompoundName("packetcompressionlimit");
    static final CompoundName PACKET_COMPRESSION_TYPE = new CompoundName("packetcompressiontype");
    private static final CompoundName TRACE_DISABLE = new CompoundName("trace.disable");
    private String serverId;
    private Map<String, DocumentDatabase> documentDbs = new LinkedHashMap<String, DocumentDatabase>();
    private DocumentDatabase defaultDocumentDb = null;
    private String defaultDocsumClass = null;
    private String name;

    static Iterator<Hit> hitIterator(Result result) {
        return result.hits().unorderedDeepIterator();
    }

    public final String getName() {
        return this.name;
    }

    protected final String getDefaultDocsumClass() {
        return this.defaultDocsumClass;
    }

    private void setDefaultDocsumClass(String docsumClass) {
        this.defaultDocsumClass = docsumClass;
    }

    @Override
    public final Logger getLogger() {
        return super.getLogger();
    }

    protected abstract Result doSearch2(Query var1, QueryPacket var2, Execution var3);

    protected abstract void doPartialFill(Result var1, String var2);

    public boolean summaryNeedsQuery(Query query) {
        if (query.getRanking().getQueryCache()) {
            return false;
        }
        DocumentDatabase documentDb = this.getDocumentDatabase(query);
        DocsumDefinition docsumDefinition = documentDb.getDocsumDefinitionSet().getDocsum(query.getPresentation().getSummary());
        if (docsumDefinition.isDynamic()) {
            return true;
        }
        RankProfile rankProfile = documentDb.rankProfiles().get(query.getRanking().getProfile());
        if (rankProfile == null) {
            return true;
        }
        if (rankProfile.hasSummaryFeatures()) {
            return true;
        }
        return query.getRanking().getListFeatures();
    }

    public String getServerId() {
        return this.serverId;
    }

    protected DocumentDatabase getDocumentDatabase(Query query) {
        String docTypeName;
        DocumentDatabase db;
        if (query.getModel().getRestrict().size() == 1 && (db = this.documentDbs.get(docTypeName = (String)query.getModel().getRestrict().toArray()[0])) != null) {
            return db;
        }
        return this.defaultDocumentDb;
    }

    private void resolveDocumentDatabase(Query query) {
        DocumentDatabase docDb = this.getDocumentDatabase(query);
        if (docDb != null) {
            query.getModel().setDocumentDb(docDb.getName());
        }
    }

    public final void init(String serverId, SummaryParameters docSumParams, ClusterParams clusterParams, DocumentdbInfoConfig documentdbInfoConfig) {
        this.serverId = serverId;
        this.name = clusterParams.searcherName;
        Validator.ensureNotNull((String)"Name of Vespa backend integration", (Object)this.getName());
        this.setDefaultDocsumClass(docSumParams.defaultClass);
        if (documentdbInfoConfig != null) {
            for (DocumentdbInfoConfig.Documentdb docDb : documentdbInfoConfig.documentdb()) {
                DocumentDatabase db = new DocumentDatabase(docDb);
                if (this.documentDbs.isEmpty()) {
                    this.defaultDocumentDb = db;
                }
                this.documentDbs.put(docDb.name(), db);
            }
        }
    }

    protected void transformQuery(Query query) {
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result;
        Item root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query, ErrorMessage.createNullQuery(query.getHttpRequest().getUri().toString()));
        }
        QueryRewrite.optimizeByRestrict(query);
        QueryRewrite.optimizeAndNot(query);
        QueryRewrite.collapseSingleComposites(query);
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        this.resolveDocumentDatabase(query);
        this.transformQuery(query);
        VespaBackEndSearcher.traceQuery(this.name, "search", query, query.getOffset(), query.getHits(), 1, Optional.empty());
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        QueryPacket queryPacket = this.createQueryPacket(this.serverId, query);
        if (this.isLoggingFine()) {
            this.getLogger().fine("made QueryPacket: " + queryPacket);
        }
        if ((result = null) == null) {
            result = this.doSearch2(query, queryPacket, execution);
            if (this.isLoggingFine()) {
                this.getLogger().fine("Result NOT retrieved from cache");
            }
            if (query.getTraceLevel() >= 1) {
                query.trace(this.getName() + " dispatch response: " + result, false, 1);
            }
            result.trace(this.getName());
        }
        return result;
    }

    protected QueryPacket createQueryPacket(String serverId, Query query) {
        QueryPacket queryPacket = QueryPacket.create(serverId, query);
        int compressionLimit = query.properties().getInteger(PACKET_COMPRESSION_LIMIT, 0);
        queryPacket.setCompressionLimit(compressionLimit);
        if (compressionLimit != 0) {
            queryPacket.setCompressionType(query.properties().getString(PACKET_COMPRESSION_TYPE, "lz4"));
        }
        return queryPacket;
    }

    private List<Result> partitionHits(Result result, String summaryClass) {
        ArrayList<Result> parts = new ArrayList<Result>();
        TinyIdentitySet queryMap = new TinyIdentitySet(4);
        Iterator<Hit> i = VespaBackEndSearcher.hitIterator(result);
        while (i.hasNext()) {
            int idx;
            FastHit fastHit;
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || (fastHit = (FastHit)hit).isFilled(summaryClass)) continue;
            Query q = fastHit.getQuery();
            if (q == null) {
                q = result.hits().getQuery();
            }
            if ((idx = queryMap.indexOf((Object)q)) < 0) {
                idx = queryMap.size();
                Result r = new Result(q);
                parts.add(r);
                queryMap.add((Object)q);
            }
            ((Result)parts.get(idx)).hits().add(fastHit);
        }
        return parts;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        if (result.isFilled(summaryClass)) {
            return;
        }
        List<Result> parts = this.partitionHits(result, summaryClass);
        if (parts.size() > 0) {
            for (Result r : parts) {
                this.doPartialFill(r, summaryClass);
                this.mergeErrorsInto(result, r);
            }
            result.hits().setSorted(false);
            result.analyzeHits();
        }
    }

    private void mergeErrorsInto(Result destination, Result source) {
        ErrorHit eh = source.hits().getErrorHit();
        if (eh != null) {
            for (ErrorMessage error : eh.errors()) {
                destination.hits().addError(error);
            }
        }
    }

    static void traceQuery(String sourceName, String type, Query query, int offset, int hits, int level, Optional<String> quotedSummaryClass) {
        if (query.getTraceLevel() < level || query.properties().getBoolean(TRACE_DISABLE)) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(sourceName).append(" " + type + " to dispatch: ").append("query=[").append(query.getModel().getQueryTree().getRoot().toString()).append("]");
        s.append(" timeout=").append(query.getTimeout()).append("ms");
        s.append(" offset=").append(offset).append(" hits=").append(hits);
        if (query.getRanking().hasRankProfile()) {
            s.append(" rankprofile[").append(query.getRanking().getProfile()).append("]");
        }
        if (query.getRanking().getFreshness() != null) {
            s.append(" freshness=").append(query.getRanking().getFreshness().getRefTime());
        }
        if (query.getRanking().getSorting() != null) {
            s.append(" sortspec=").append(query.getRanking().getSorting().fieldOrders().toString());
        }
        if (query.getRanking().getLocation() != null) {
            s.append(" location=").append(query.getRanking().getLocation().toString());
        }
        if (query.getGroupingSessionCache()) {
            s.append(" groupingSessionCache=true");
        }
        if (query.getRanking().getQueryCache()) {
            s.append(" ranking.queryCache=true");
        }
        if (query.getGroupingSessionCache() || query.getRanking().getQueryCache()) {
            s.append(" sessionId=").append(query.getSessionId());
        }
        List<Grouping> grouping = GroupingExecutor.getGroupingList(query);
        s.append(" grouping=").append(grouping.size()).append(" : ");
        for (Grouping g : grouping) {
            s.append(g.toString());
        }
        if (!query.getRanking().getProperties().isEmpty()) {
            s.append(" rankproperties=").append(query.getRanking().getProperties().toString());
        }
        if (!query.getRanking().getFeatures().isEmpty()) {
            s.append(" rankfeatures=").append(query.getRanking().getFeatures().toString());
        }
        if (query.getModel().getRestrict() != null) {
            s.append(" restrict=").append(query.getModel().getRestrict().toString());
        }
        if (quotedSummaryClass.isPresent()) {
            s.append(" summary=").append(quotedSummaryClass.get());
        }
        query.trace(s.toString(), false, level);
        if (query.isTraceable(level + 1)) {
            query.trace("Current state of query tree: " + new TextualQueryRepresentation(query.getModel().getQueryTree().getRoot()), false, level + 1);
        }
        if (query.isTraceable(level + 2)) {
            query.trace("YQL+ representation: " + query.yqlRepresentation(), level + 2);
        }
    }

    private void addBackendTrace(Query query, QueryResultPacket resultPacket) {
        if (resultPacket.propsArray == null) {
            return;
        }
        Value.ArrayValue traces = new Value.ArrayValue();
        for (FS4Properties properties : resultPacket.propsArray) {
            if (!properties.getName().equals("trace")) continue;
            for (FS4Properties.Entry entry : properties.getEntries()) {
                traces.add((com.yahoo.data.access.Inspector)new SlimeAdapter((Inspector)BinaryFormat.decode((byte[])entry.getValue()).get()));
            }
        }
        query.trace(traces, query.getTraceLevel());
    }

    void addMetaInfo(Query query, QueryPacketData queryPacketData, QueryResultPacket resultPacket, Result result) {
        result.setTotalHitCount(resultPacket.getTotalDocumentCount());
        this.addBackendTrace(query, resultPacket);
        if (resultPacket.getGroupData() != null) {
            byte[] data = resultPacket.getGroupData();
            ArrayList<Grouping> list = new ArrayList<Grouping>();
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(ByteBuffer.wrap(data)));
            int cnt = buf.getInt(null);
            for (int i = 0; i < cnt; ++i) {
                Grouping g = new Grouping();
                g.deserialize((Deserializer)buf);
                list.add(g);
            }
            GroupingListHit hit = new GroupingListHit(list, this.getDocsumDefinitionSet(query));
            hit.setQuery(result.getQuery());
            hit.setSource(this.getName());
            hit.setQueryPacketData(queryPacketData);
            result.hits().add(hit);
        }
        if (resultPacket.getCoverageFeature()) {
            result.setCoverage(new Coverage(resultPacket.getCoverageDocs(), resultPacket.getActiveDocs(), resultPacket.getNodesReplied()).setSoonActive(resultPacket.getSoonActiveDocs()).setDegradedReason(resultPacket.getDegradedReason()).setNodesTried(resultPacket.getNodesQueried()));
        }
    }

    FillHitResult fillHit(FastHit hit, DocsumPacket packet, String summaryClass) {
        byte[] docsumdata;
        if (packet != null && (docsumdata = packet.getData()).length > 0) {
            return new FillHitResult(true, this.decodeSummary(summaryClass, hit, docsumdata));
        }
        return new FillHitResult(false);
    }

    public FillHitsResult fillHits(Result result, Packet[] packets, String summaryClass) throws IOException {
        int skippedHits = 0;
        String lastError = null;
        int packetIndex = 0;
        Iterator<Hit> i = VespaBackEndSearcher.hitIterator(result);
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || hit.isFilled(summaryClass)) continue;
            FastHit fastHit = (FastHit)hit;
            packets[packetIndex].ensureInstanceOf(DocsumPacket.class, this.getName());
            DocsumPacket docsum = (DocsumPacket)packets[packetIndex];
            ++packetIndex;
            FillHitResult fr = this.fillHit(fastHit, docsum, summaryClass);
            if (!fr.ok) {
                ++skippedHits;
            }
            if (fr.error == null) continue;
            result.hits().addError(ErrorMessage.createTimeout(fr.error));
            ++skippedHits;
            lastError = fr.error;
        }
        result.hits().setSorted(false);
        return new FillHitsResult(skippedHits, lastError);
    }

    private void extractDocumentInfo(FastHit hit, DocumentInfo document) {
        hit.setSource(this.getName());
        Double rank = document.getMetric();
        hit.setRelevance(new Relevance(rank));
        hit.setDistributionKey(document.getDistributionKey());
        hit.setGlobalId(document.getGlobalId());
        hit.setPartId(document.getPartId());
    }

    protected DocsumDefinitionSet getDocsumDefinitionSet(Query query) {
        DocumentDatabase db = this.getDocumentDatabase(query);
        return db.getDocsumDefinitionSet();
    }

    private String decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata) {
        DocumentDatabase db = this.getDocumentDatabase(hit.getQuery());
        hit.setField("sddocname", db.getName());
        return this.decodeSummary(summaryClass, hit, docsumdata, db.getDocsumDefinitionSet());
    }

    private String decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata, DocsumDefinitionSet docsumSet) {
        String error = docsumSet.lazyDecode(summaryClass, docsumdata, hit);
        if (error == null) {
            hit.setFilled(summaryClass);
        }
        return error;
    }

    void addUnfilledHits(Result result, List<DocumentInfo> documents, QueryPacketData queryPacketData, Optional<Integer> channelDistributionKey) {
        Query myQuery = result.getQuery();
        for (DocumentInfo document : documents) {
            try {
                FastHit hit = new FastHit();
                hit.setQuery(myQuery);
                if (queryPacketData != null) {
                    hit.setQueryPacketData(queryPacketData);
                }
                hit.setFillable();
                hit.setCached(false);
                this.extractDocumentInfo(hit, document);
                channelDistributionKey.ifPresent(hit::setDistributionKey);
                result.hits().add(hit);
            }
            catch (ConfigurationException e) {
                this.getLogger().log(LogLevel.WARNING, "Skipping hit", e);
            }
            catch (Exception e) {
                this.getLogger().log((Level)LogLevel.ERROR, "Skipping malformed hit", e);
            }
        }
    }

    public static VespaBackEndSearcher getSearcher(String s) {
        try {
            Class<?> c = Class.forName(s);
            if (VespaBackEndSearcher.class.isAssignableFrom(c)) {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = c.getConstructors()) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    if (parameters.length != 0) continue;
                    return (VespaBackEndSearcher)((Object)constructor.newInstance(new Object[0]));
                }
                throw new RuntimeException("Failed initializing " + s);
            }
            throw new RuntimeException(s + " is not com.yahoo.prelude.fastsearch.VespaBackEndSearcher");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure loading class " + s + ", exception :" + e);
        }
    }

    protected boolean isLoggingFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    protected static class FillHitsResult {
        public final int skippedHits;
        public final String error;

        FillHitsResult(int skippedHits, String error) {
            this.skippedHits = skippedHits;
            this.error = error;
        }
    }

    static class FillHitResult {
        final boolean ok;
        final String error;

        FillHitResult(boolean ok) {
            this(ok, null);
        }

        FillHitResult(boolean ok, String error) {
            this.ok = ok;
            this.error = error;
        }
    }
}

