/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.ChannelTimeoutException;
import com.yahoo.fs4.GetDocSumsPacket;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.mplex.Backend;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.fs4.mplex.InvalidChannelException;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import java.io.IOException;
import java.util.Iterator;

public class FS4FillInvoker
extends FillInvoker {
    private final VespaBackEndSearcher searcher;
    private FS4Channel channel;
    private int expectedFillResults = 0;

    public FS4FillInvoker(VespaBackEndSearcher searcher, Query query, FS4ResourcePool fs4ResourcePool, String hostname, int port) {
        this.searcher = searcher;
        Backend backend = fs4ResourcePool.getBackend(hostname, port);
        this.channel = backend.openChannel();
        this.channel.setQuery(query);
    }

    public FS4FillInvoker(VespaBackEndSearcher searcher, Query query, Backend backend) {
        this.searcher = searcher;
        this.channel = backend.openChannel();
        this.channel.setQuery(query);
    }

    @Override
    protected void sendFillRequest(Result result, String summaryClass) {
        if (this.countFastHits(result) > 0) {
            DocsumPacketKey[] summaryPacketKeys = this.getPacketKeys(result, summaryClass);
            if (summaryPacketKeys.length == 0) {
                this.expectedFillResults = 0;
            } else {
                try {
                    this.expectedFillResults = this.requestSummaries(result, summaryClass);
                }
                catch (InvalidChannelException e) {
                    result.hits().addError(ErrorMessage.createBackendCommunicationError("Invalid channel " + this.getName() + " (summary fetch)"));
                    return;
                }
                catch (IOException e) {
                    result.hits().addError(ErrorMessage.createBackendCommunicationError("IO error while talking on channel " + this.getName() + " (summary fetch): " + e.getMessage()));
                    return;
                }
            }
        } else {
            this.expectedFillResults = 0;
        }
    }

    @Override
    protected void getFillResults(Result result, String summaryClass) {
        int skippedHits;
        Packet[] receivedPackets;
        if (this.expectedFillResults == 0) {
            return;
        }
        try {
            receivedPackets = this.getSummaryResponses(result);
        }
        catch (InvalidChannelException e1) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError("Invalid channel " + this.getName() + " (summary fetch)"));
            return;
        }
        catch (ChannelTimeoutException e1) {
            result.hits().addError(ErrorMessage.createTimeout("timeout waiting for summaries from " + this.getName()));
            return;
        }
        if (receivedPackets.length == 0) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError(this.getName() + " got no packets back (summary fetch)"));
            return;
        }
        try {
            VespaBackEndSearcher.FillHitsResult fillHitsResult = this.searcher.fillHits(result, receivedPackets, summaryClass);
            skippedHits = fillHitsResult.skippedHits;
            if (fillHitsResult.error != null) {
                result.hits().addError(ErrorMessage.createTimeout(fillHitsResult.error));
                return;
            }
        }
        catch (TimeoutException e) {
            result.hits().addError(ErrorMessage.createTimeout(e.getMessage()));
            return;
        }
        catch (IOException e) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError("Error filling hits with summary fields, source: " + this.getName() + " Exception thrown: " + e.getMessage()));
            return;
        }
        if (skippedHits > 0) {
            result.hits().addError(ErrorMessage.createEmptyDocsums("Missing hit data for summary '" + summaryClass + "' for " + skippedHits + " hits"));
        }
        result.analyzeHits();
        if (this.channel.getQuery().getTraceLevel() >= 3) {
            int hitNumber = 0;
            Iterator<Hit> i = VespaBackEndSearcher.hitIterator(result);
            while (i.hasNext()) {
                Hit hit = i.next();
                if (!(hit instanceof FastHit)) continue;
                FastHit fastHit = (FastHit)hit;
                String traceMsg = "Hit: " + hitNumber++ + " from " + (fastHit.isCached() ? "cache" : "backend");
                if (!fastHit.isFilled(summaryClass)) {
                    traceMsg = traceMsg + ". Error, hit, not filled";
                }
                this.channel.getQuery().trace(traceMsg, false, 3);
            }
        }
    }

    @Override
    public void release() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private int countFastHits(Result result) {
        int count = 0;
        Iterator<Hit> i = VespaBackEndSearcher.hitIterator(result);
        while (i.hasNext()) {
            if (!(i.next() instanceof FastHit)) continue;
            ++count;
        }
        return count;
    }

    private int requestSummaries(Result result, String summaryClass) throws InvalidChannelException, ClassCastException, IOException {
        boolean couldSend;
        boolean summaryNeedsQuery = this.searcher.summaryNeedsQuery(result.getQuery());
        if (result.getQuery().getTraceLevel() >= 3) {
            result.getQuery().trace((summaryNeedsQuery ? "Resending " : "Not resending ") + "query during document summary fetching", 3);
        }
        GetDocSumsPacket docsumsPacket = GetDocSumsPacket.create(result, summaryClass, summaryNeedsQuery);
        int compressionLimit = result.getQuery().properties().getInteger(FastSearcher.PACKET_COMPRESSION_LIMIT, 0);
        docsumsPacket.setCompressionLimit(compressionLimit);
        if (compressionLimit != 0) {
            docsumsPacket.setCompressionType(result.getQuery().properties().getString(FastSearcher.PACKET_COMPRESSION_TYPE, "lz4"));
        }
        if (!(couldSend = this.channel.sendPacket(docsumsPacket))) {
            throw new IOException("Could not successfully send GetDocSumsPacket.");
        }
        return docsumsPacket.getNumDocsums() + 1;
    }

    private Packet[] getSummaryResponses(Result result) throws InvalidChannelException, ChannelTimeoutException {
        if (this.expectedFillResults == 0) {
            return new Packet[0];
        }
        BasicPacket[] receivedPackets = this.channel.receivePackets(result.getQuery().getTimeLeft(), this.expectedFillResults);
        return FS4FillInvoker.convertBasicPackets(receivedPackets);
    }

    private DocsumPacketKey[] getPacketKeys(Result result, String summaryClass) {
        DocsumPacketKey[] packetKeys = new DocsumPacketKey[result.getHitCount()];
        int x = 0;
        Iterator<Hit> i = VespaBackEndSearcher.hitIterator(result);
        while (i.hasNext()) {
            FastHit fastHit;
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || (fastHit = (FastHit)hit).isFilled(summaryClass)) continue;
            packetKeys[x] = new DocsumPacketKey(fastHit.getGlobalId(), fastHit.getPartId(), summaryClass);
            ++x;
        }
        if (x < packetKeys.length) {
            DocsumPacketKey[] tmp = new DocsumPacketKey[x];
            System.arraycopy(packetKeys, 0, tmp, 0, x);
            return tmp;
        }
        return packetKeys;
    }

    private static Packet[] convertBasicPackets(BasicPacket[] basicPackets) throws ClassCastException {
        Packet[] packets = new Packet[basicPackets.length];
        for (int i = 0; i < basicPackets.length; ++i) {
            packets[i] = (Packet)basicPackets[i];
        }
        return packets;
    }

    private String getName() {
        return this.searcher.getName();
    }
}

