/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.HexByteIterator;
import com.yahoo.fs4.PacketListener;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.log.LogLevel;
import com.yahoo.search.Query;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class PacketDumper
implements PacketListener {
    private static Logger log = Logger.getLogger(PacketDumper.class.getSimpleName());
    private volatile boolean disabled = true;
    private final File logDirectory;
    private final Map<Class<? extends BasicPacket>, DataOutputStream> dumpFiles = new HashMap<Class<? extends BasicPacket>, DataOutputStream>();
    private final String fileNamePattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePacket(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm, String direction) {
        block7: {
            if (this.disabled) {
                return;
            }
            try {
                DataOutputStream stream = this.getOutputStream(packet);
                if (stream == null) break block7;
                DataOutputStream dataOutputStream = stream;
                synchronized (dataOutputStream) {
                    stream.writeChars(packet.getTimestamp() + " " + direction + " packet on channel " + channel.getChannelId());
                    String indent = "    ";
                    Query query = channel.getQuery();
                    if (query != null) {
                        stream.writeChars("\n" + indent + "Query: '" + query.getModel().getQueryString());
                    }
                    this.hexDump(indent, stream, serializedForm);
                    stream.writeChar(10);
                    stream.flush();
                }
            }
            catch (IOException e) {
                log.log(LogLevel.WARNING, "Could not log packet.", e);
            }
        }
    }

    private void hexDump(String indent, DataOutputStream stream, ByteBuffer serializedForm) throws IOException {
        HexByteIterator hexByteIterator = new HexByteIterator(serializedForm);
        long count = 0L;
        int maxNumCharacters = 80;
        while (hexByteIterator.hasNext()) {
            if (count++ % 80L == 0L) {
                stream.writeChar(10);
            }
            stream.writeChars(hexByteIterator.next());
        }
    }

    private synchronized DataOutputStream getOutputStream(BasicPacket packet) {
        return this.dumpFiles.get(packet.getClass());
    }

    @Override
    public void packetSent(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm) {
        this.handlePacket(channel, packet, serializedForm, "Sent");
    }

    @Override
    public void packetReceived(FS4Channel channel, BasicPacket packet, ByteBuffer serializedForm) {
        this.handlePacket(channel, packet, serializedForm, "Received");
    }

    public synchronized void dumpPackets(PacketType packetType, boolean on) throws IOException {
        OutputStream stream = this.dumpFiles.get(packetType.implementationType);
        if (!on && stream != null) {
            this.closeFile(stream, packetType);
        } else if (on && stream == null) {
            this.openFile(packetType);
        }
    }

    private void openFile(PacketType packetType) throws FileNotFoundException {
        if (!this.logDirectory.exists() || this.logDirectory.mkdirs()) {
            throw new RuntimeException("PacketDumper: Could not create log directory " + this.logDirectory);
        }
        String fileName = this.fileNamePattern.replace("%s", packetType.toString());
        boolean append = true;
        DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.logDirectory, fileName), append)));
        this.dumpFiles.put(packetType.implementationType, outputStream);
        this.disabled = this.dumpFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile(OutputStream stream, PacketType packetType) throws IOException {
        try {
            OutputStream outputStream = stream;
            synchronized (outputStream) {
                stream.close();
            }
        }
        finally {
            this.dumpFiles.remove(packetType.implementationType);
            this.disabled = this.dumpFiles.isEmpty();
        }
    }

    public PacketDumper(File logDirectory, String fileNamePattern) {
        this.logDirectory = logDirectory;
        this.fileNamePattern = fileNamePattern;
    }

    public static enum PacketType {
        query(QueryPacket.class),
        result(QueryResultPacket.class);

        Class<? extends BasicPacket> implementationType;

        private PacketType(Class<? extends BasicPacket> implementationType) {
            this.implementationType = implementationType;
        }
    }
}

