/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.BufferTooSmallException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class Packet
extends BasicPacket {
    private static Logger log = Logger.getLogger(Packet.class.getName());
    protected int channel = -1;
    private static final int CHANNEL_ID_OFFSET = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicPacket decode(ByteBuffer buffer) {
        int originalPos = buffer.position();
        int packetLength = this.length = buffer.getInt() + 4;
        try {
            int code = buffer.getInt();
            this.channel = buffer.getInt();
            this.decodeAndDecompressBody(buffer, code, this.length - 12);
        }
        finally {
            int targetPosition = originalPos + packetLength;
            if (buffer.position() != targetPosition) {
                log.warning("Position in buffer is " + buffer.position() + " should be " + targetPosition);
                buffer.position(targetPosition);
            }
        }
        return this;
    }

    @Override
    public final Packet encode(ByteBuffer buffer, int channel) throws BufferTooSmallException {
        this.channel = channel;
        int oldLimit = buffer.limit();
        int startPosition = buffer.position();
        buffer.limit(buffer.capacity());
        try {
            buffer.putInt(8);
            buffer.putInt(this.getCode());
            buffer.putInt(channel);
            this.encodeAndCompressBody(buffer, startPosition);
        }
        catch (BufferOverflowException e) {
            buffer.position(startPosition);
            buffer.limit(oldLimit);
            throw new BufferTooSmallException("Destination buffer too small while encoding packet");
        }
        return this;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public boolean hasChannelId() {
        return true;
    }

    @Override
    protected void patchChannelId(ByteBuffer buf, int channelId) {
        buf.putInt(8, channelId);
    }

    @Override
    public String toString() {
        return "packet with code " + this.getCode() + ", channelId=" + this.getChannel();
    }
}

