/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapEncoder {
    private static final String TYPE_SUFFIX = ".type";
    private static final String TENSOR_TYPE = "tensor";

    public static int encodeSingleValue(String mapName, String key, Object value, ByteBuffer buffer) {
        if (value == null) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(1);
        utf8 = Utf8.toBytes((String)key);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        utf8 = Utf8.toBytes((String)value.toString());
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        return 1;
    }

    public static int encodeMap(String mapName, Map<String, ?> map, ByteBuffer buffer) {
        if (map.isEmpty()) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(map.size());
        for (Map.Entry<String, ?> property : map.entrySet()) {
            String key = property.getKey();
            utf8 = Utf8.toBytes((String)key);
            buffer.putInt(utf8.length);
            buffer.put(utf8);
            utf8 = Utf8.toBytes((String)(property.getValue() != null ? property.getValue().toString() : ""));
            buffer.putInt(utf8.length);
            buffer.put(utf8);
        }
        return 1;
    }

    public static int encodeStringMultiMap(String mapName, Map<String, List<String>> map, ByteBuffer buffer) {
        if (map.isEmpty()) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        buffer.putInt(MapEncoder.countStringEntries(map));
        for (Map.Entry<String, List<String>> property : map.entrySet()) {
            String key = property.getKey();
            for (String value : property.getValue()) {
                utf8 = Utf8.toBytes((String)key);
                buffer.putInt(utf8.length);
                buffer.put(utf8);
                utf8 = Utf8.toBytes((String)value.toString());
                buffer.putInt(utf8.length);
                buffer.put(utf8);
            }
        }
        return 1;
    }

    public static int encodeObjectMultiMap(String mapName, Map<String, List<Object>> map, ByteBuffer buffer) {
        if (map.isEmpty()) {
            return 0;
        }
        byte[] utf8 = Utf8.toBytes((String)mapName);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        MapEncoder.addTensorTypeInfo(map);
        buffer.putInt(MapEncoder.countObjectEntries(map));
        for (Map.Entry<String, List<Object>> property : map.entrySet()) {
            String key = property.getKey();
            for (Object value : property.getValue()) {
                utf8 = Utf8.toBytes((String)key);
                buffer.putInt(utf8.length);
                buffer.put(utf8);
                utf8 = value instanceof Tensor ? TypedBinaryFormat.encode((Tensor)((Tensor)value)) : Utf8.toBytes((String)value.toString());
                buffer.putInt(utf8.length);
                buffer.put(utf8);
            }
        }
        return 1;
    }

    private static void addTensorTypeInfo(Map<String, List<Object>> map) {
        HashMap<String, Tensor> tensorsToTag = new HashMap<String, Tensor>();
        for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
            for (Object value : entry.getValue()) {
                if (!(value instanceof Tensor)) continue;
                tensorsToTag.put(entry.getKey(), (Tensor)value);
            }
        }
        for (Map.Entry<String, List<Object>> entry : tensorsToTag.entrySet()) {
            map.put(entry.getKey(), Arrays.asList(entry.getValue()));
            map.put(entry.getKey() + TYPE_SUFFIX, Arrays.asList(TENSOR_TYPE));
        }
    }

    private static int countStringEntries(Map<String, List<String>> value) {
        int entries = 0;
        for (Map.Entry<String, List<String>> property : value.entrySet()) {
            entries += property.getValue().size();
        }
        return entries;
    }

    private static int countObjectEntries(Map<String, List<Object>> value) {
        int entries = 0;
        for (Map.Entry<String, List<Object>> property : value.entrySet()) {
            entries += property.getValue().size();
        }
        return entries;
    }
}

