/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryPacketData;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.query.Item;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.result.Hit;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetDocSumsPacket
extends Packet {
    public static final String sessionIdKey = "sessionId";
    private static final Logger log = Logger.getLogger(GetDocSumsPacket.class.getName());
    private final Result result;
    private final Query query;
    private final String summaryClass;
    private QueryPacketData queryPacketData = null;
    private int flags = 0;
    private final boolean sendQuery;
    public static final int GDF_MLD = 1;
    public static final int GDF_QUERYSTACK = 4;
    public static final int GDF_RANKP_QFLAGS = 16;
    public static final int GDF_LOCATION = 128;
    public static final int GDF_RESCLASSNAME = 2048;
    public static final int GDF_PROPERTIES = 4096;
    public static final int GDF_FLAGS = 8192;
    public static final int GDFLAG_IGNORE_ROW = 1;

    private GetDocSumsPacket(Result result, String summaryClass, boolean sendQuery) {
        this.result = result;
        this.query = result.getQuery();
        this.summaryClass = summaryClass;
        this.sendQuery = sendQuery;
    }

    public static GetDocSumsPacket create(Result result, String summaryClass, boolean sendQuery) {
        return new GetDocSumsPacket(result, summaryClass, sendQuery);
    }

    @Override
    public void encodeBody(ByteBuffer buffer) {
        this.setFieldsFromHits();
        boolean useQueryCache = this.query.getRanking().getQueryCache();
        if (useQueryCache) {
            this.query.getRanking().getProperties().put(sessionIdKey, this.query.getSessionId().toString());
        }
        long features = 1L;
        if (this.sendQuery) {
            features |= 4L;
        }
        features |= 0x10L;
        if (this.summaryClass != null) {
            features |= 0x800L;
        }
        if (this.query.getRanking().getLocation() != null) {
            features |= 0x80L;
        }
        if (this.query.hasEncodableProperties()) {
            features |= 0x1000L;
        }
        if (this.flags != 0) {
            features |= 0x2000L;
        }
        buffer.putInt((int)features);
        buffer.putInt(0);
        long timeLeft = this.query.getTimeLeft();
        buffer.putInt(Math.max(1, (int)timeLeft));
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Timeout from query(" + this.query.getTimeout() + "), sent to backend: " + timeLeft);
        }
        if (this.queryPacketData != null) {
            this.encodeQueryFromPacketData(buffer, useQueryCache);
        } else {
            this.encodeQuery(buffer);
        }
        if (this.flags != 0) {
            buffer.putInt(this.flags);
        }
        this.encodeDocIds(buffer);
    }

    private void setFieldsFromHits() {
        Iterator<Hit> i = this.result.hits().unorderedDeepIterator();
        while (i.hasNext()) {
            FastHit hit;
            QueryPacketData tag;
            Hit h = i.next();
            if (!(h instanceof FastHit) || (tag = (hit = (FastHit)h).getQueryPacketData()) == null) continue;
            this.queryPacketData = tag;
            break;
        }
    }

    private void encodeQueryFromPacketData(ByteBuffer buffer, boolean reencodePropertyMaps) {
        this.queryPacketData.encodeRankProfile(buffer);
        this.queryPacketData.encodeQueryFlags(buffer);
        this.encodeSummaryClass(buffer);
        if (reencodePropertyMaps || !this.sendQuery) {
            this.query.encodeAsProperties(buffer, this.sendQuery);
        } else {
            this.queryPacketData.encodePropertyMaps(buffer);
        }
        if (this.sendQuery) {
            this.queryPacketData.encodeQueryStack(buffer);
        }
        this.queryPacketData.encodeLocation(buffer);
    }

    private void encodeSummaryClass(ByteBuffer buffer) {
        if (this.summaryClass != null) {
            byte[] tmp = Utf8.toBytes((String)this.summaryClass);
            buffer.putInt(tmp.length);
            buffer.put(tmp);
        }
    }

    private void encodeQuery(ByteBuffer buffer) {
        Item.putString(this.query.getRanking().getProfile(), buffer);
        buffer.putInt(QueryPacket.getQueryFlags(this.query));
        this.encodeSummaryClass(buffer);
        this.query.encodeAsProperties(buffer, this.sendQuery);
        if (this.sendQuery) {
            int itemCountPosition = buffer.position();
            buffer.putInt(0);
            int dumpLengthPosition = buffer.position();
            buffer.putInt(0);
            int count = this.query.encode(buffer);
            buffer.putInt(itemCountPosition, count);
            buffer.putInt(dumpLengthPosition, buffer.position() - dumpLengthPosition - 4);
        }
        if (this.query.getRanking().getLocation() != null) {
            int locationLengthPosition = buffer.position();
            buffer.putInt(0);
            int locationLength = this.query.getRanking().getLocation().encode(buffer);
            buffer.putInt(locationLengthPosition, locationLength);
        }
    }

    private void encodeDocIds(ByteBuffer buffer) {
        byte[] emptyGid = new byte[12];
        Iterator<Hit> i = this.result.hits().unorderedDeepIterator();
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || hit.isFilled(this.summaryClass)) continue;
            FastHit fastHit = (FastHit)hit;
            buffer.put(fastHit.getGlobalId() != null ? fastHit.getGlobalId().getRawId() : emptyGid);
            buffer.putInt(fastHit.getPartId());
            buffer.putInt(0);
        }
    }

    @Override
    public int getCode() {
        return 219;
    }

    @Override
    public String toString() {
        return "Get docsums x packet fetching " + this.getNumDocsums() + " docsums and packet length of " + this.getLength() + " bytes.";
    }

    public int getNumDocsums() {
        int num = 0;
        Iterator<Hit> i = this.result.hits().unorderedDeepIterator();
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || hit.isFilled(this.summaryClass)) continue;
            ++num;
        }
        return num;
    }

    public String getSummaryClass() {
        return this.summaryClass;
    }
}

