/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.BackedOverridableQueryProfile;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.QueryProfileVariant;
import com.yahoo.search.query.profile.QueryProfileVariants;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.DimensionalMap;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class QueryProfileCompiler {
    private static final Logger log = Logger.getLogger(QueryProfileCompiler.class.getName());

    public static CompiledQueryProfileRegistry compile(QueryProfileRegistry input) {
        CompiledQueryProfileRegistry output = new CompiledQueryProfileRegistry(input.getTypeRegistry());
        for (QueryProfile inputProfile : input.allComponents()) {
            output.register(QueryProfileCompiler.compile(inputProfile, output));
        }
        return output;
    }

    public static CompiledQueryProfile compile(QueryProfile in, CompiledQueryProfileRegistry registry) {
        try {
            DimensionalMap.Builder<ValueWithSource> values = new DimensionalMap.Builder<ValueWithSource>();
            DimensionalMap.Builder<QueryProfileType> types = new DimensionalMap.Builder<QueryProfileType>();
            DimensionalMap.Builder<Boolean> references = new DimensionalMap.Builder<Boolean>();
            DimensionalMap.Builder<Boolean> unoverridables = new DimensionalMap.Builder<Boolean>();
            Set<DimensionBindingForPath> variants = QueryProfileCompiler.collectVariants(CompoundName.empty, in, DimensionBinding.nullBinding);
            variants.add(new DimensionBindingForPath(DimensionBinding.nullBinding, CompoundName.empty));
            log.fine(() -> "Compiling " + in + " having " + variants.size() + " variants");
            for (DimensionBindingForPath variant : variants) {
                log.finer(() -> "  Compiling variant " + variant);
                for (Map.Entry<String, ValueWithSource> entry : in.visitValues(variant.path(), variant.binding().getContext()).valuesWithSource().entrySet()) {
                    CompoundName fullName = variant.path().append(entry.getKey());
                    values.put(fullName, variant.binding(), entry.getValue());
                    if (entry.getValue().isUnoverridable()) {
                        unoverridables.put(fullName, variant.binding(), Boolean.TRUE);
                    }
                    if (entry.getValue().isQueryProfile()) {
                        references.put(fullName, variant.binding(), Boolean.TRUE);
                    }
                    if (entry.getValue().queryProfileType() == null) continue;
                    types.put(fullName, variant.binding(), entry.getValue().queryProfileType());
                }
            }
            return new CompiledQueryProfile(in.getId(), in.getType(), values.build(), types.build(), references.build(), unoverridables.build(), registry);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + in, e);
        }
    }

    private static Set<DimensionBindingForPath> collectVariants(CompoundName path, QueryProfile profile, DimensionBinding currentVariant) {
        HashSet<DimensionBindingForPath> variants = new HashSet<DimensionBindingForPath>();
        variants.addAll(QueryProfileCompiler.collectVariantsFromValues(path, profile.getContent(), currentVariant));
        variants.addAll(QueryProfileCompiler.collectVariantsInThis(path, profile, currentVariant));
        if (profile instanceof BackedOverridableQueryProfile) {
            variants.addAll(QueryProfileCompiler.collectVariantsInThis(path, ((BackedOverridableQueryProfile)profile).getBacking(), currentVariant));
        }
        for (QueryProfile inheritedProfile : profile.inherited()) {
            Set<DimensionBindingForPath> parentVariants = QueryProfileCompiler.collectVariants(path, inheritedProfile, currentVariant);
            variants.addAll(parentVariants);
            variants.addAll(QueryProfileCompiler.combined(variants, parentVariants));
        }
        variants.addAll(QueryProfileCompiler.wildcardExpanded(variants));
        return variants;
    }

    private static Set<DimensionBindingForPath> wildcardExpanded(Set<DimensionBindingForPath> variants) {
        HashSet<DimensionBindingForPath> expanded = new HashSet<DimensionBindingForPath>();
        for (DimensionBindingForPath variant : variants) {
            if (!QueryProfileCompiler.hasWildcardBeforeEnd(variant.binding())) continue;
            expanded.addAll(QueryProfileCompiler.wildcardExpanded(variant, variants));
        }
        return expanded;
    }

    private static boolean hasWildcardBeforeEnd(DimensionBinding variant) {
        for (int i = 0; i < variant.getValues().size() - 1; ++i) {
            if (variant.getValues().get(i) != null) continue;
            return true;
        }
        return false;
    }

    private static Set<DimensionBindingForPath> wildcardExpanded(DimensionBindingForPath variantToExpand, Set<DimensionBindingForPath> variants) {
        HashSet<DimensionBindingForPath> expanded = new HashSet<DimensionBindingForPath>();
        for (DimensionBindingForPath variant : variants) {
            DimensionBinding combined;
            if (variant.binding().isNull() || !variant.path().hasPrefix(variantToExpand.path()) || (combined = variantToExpand.binding().combineWith(variant.binding())).isInvalid()) continue;
            expanded.add(new DimensionBindingForPath(combined, variantToExpand.path()));
        }
        return expanded;
    }

    private static Set<DimensionBindingForPath> combined(Set<DimensionBindingForPath> v1s, Set<DimensionBindingForPath> v2s) {
        HashSet<DimensionBindingForPath> combinedVariants = new HashSet<DimensionBindingForPath>();
        for (DimensionBindingForPath v1 : v1s) {
            if (v1.binding().isNull()) continue;
            for (DimensionBindingForPath v2 : v2s) {
                DimensionBinding combined;
                if (v2.binding().isNull() || (combined = v1.binding().combineWith(v2.binding())).isInvalid()) continue;
                combinedVariants.add(new DimensionBindingForPath(combined, v1.path()));
            }
        }
        return combinedVariants;
    }

    private static Set<DimensionBindingForPath> collectVariantsInThis(CompoundName path, QueryProfile profile, DimensionBinding currentVariant) {
        QueryProfileVariants profileVariants = profile.getVariants();
        HashSet<DimensionBindingForPath> variants = new HashSet<DimensionBindingForPath>();
        if (profileVariants != null) {
            for (QueryProfileVariant variant : profile.getVariants().getVariants()) {
                DimensionBinding combinedVariant = DimensionBinding.createFrom(profile.getDimensions(), variant.getDimensionValues()).combineWith(currentVariant);
                if (combinedVariant.isInvalid()) continue;
                variants.add(new DimensionBindingForPath(combinedVariant, path));
                variants.addAll(QueryProfileCompiler.collectVariantsFromValues(path, variant.values(), combinedVariant));
                for (QueryProfile variantInheritedProfile : variant.inherited()) {
                    variants.addAll(QueryProfileCompiler.collectVariants(path, variantInheritedProfile, combinedVariant));
                }
            }
        }
        return variants;
    }

    private static Set<DimensionBindingForPath> collectVariantsFromValues(CompoundName path, Map<String, Object> values, DimensionBinding currentVariant) {
        HashSet<DimensionBindingForPath> variants = new HashSet<DimensionBindingForPath>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (!(entry.getValue() instanceof QueryProfile)) continue;
            variants.addAll(QueryProfileCompiler.collectVariants(path.append(entry.getKey()), (QueryProfile)entry.getValue(), currentVariant));
        }
        return variants;
    }

    private static class DimensionBindingForPath {
        private final DimensionBinding binding;
        private final CompoundName path;

        public DimensionBindingForPath(DimensionBinding binding, CompoundName path) {
            this.binding = binding;
            this.path = path;
        }

        public DimensionBinding binding() {
            return this.binding;
        }

        public CompoundName path() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DimensionBindingForPath)) {
                return false;
            }
            DimensionBindingForPath other = (DimensionBindingForPath)o;
            return other.binding.equals(this.binding) && other.path.equals((Object)this.path);
        }

        public int hashCode() {
            return this.binding.hashCode() + 17 * this.path.hashCode();
        }

        public String toString() {
            return this.binding + " for path " + this.path;
        }
    }
}

