/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.FreezableSimpleComponent;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.query.profile.AllValuesQueryProfileVisitor;
import com.yahoo.search.query.profile.BackedOverridableQueryProfile;
import com.yahoo.search.query.profile.CopyOnWriteContent;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.FieldDescriptionQueryProfileVisitor;
import com.yahoo.search.query.profile.QueryProfileCompiler;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.QueryProfileVariant;
import com.yahoo.search.query.profile.QueryProfileVariants;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import com.yahoo.search.query.profile.SingleValueQueryProfileVisitor;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileFieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryProfile
extends FreezableSimpleComponent
implements Cloneable {
    private final String source;
    private QueryProfileType type = null;
    private Object value = null;
    private QueryProfileVariants variants = null;
    private List<String> resolvedDimensions = null;
    private List<QueryProfile> inherited = null;
    private CopyOnWriteContent content = new CopyOnWriteContent();
    private Map<String, Boolean> overridable = null;
    private static final Pattern namePattern = Pattern.compile("[$a-zA-Z_/][-$a-zA-Z0-9_/()]*");

    public QueryProfile(ComponentId id) {
        this(id, id.stringValue());
    }

    public QueryProfile(String idString) {
        this(new ComponentId(idString));
    }

    public QueryProfile(ComponentId id, String sourceName) {
        super(id);
        this.source = sourceName;
        if (!id.isAnonymous()) {
            QueryProfile.validateName(id.getName());
        }
    }

    public String getSource() {
        return this.source;
    }

    public QueryProfileType getType() {
        return this.type;
    }

    public void setType(QueryProfileType type) {
        this.type = type;
    }

    public QueryProfileVariants getVariants() {
        return this.variants;
    }

    public List<QueryProfile> inherited() {
        if (this.isFrozen()) {
            return this.inherited;
        }
        if (this.inherited == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.inherited);
    }

    public void addInherited(QueryProfile profile) {
        this.addInherited(profile, (DimensionValues)null);
    }

    public final void addInherited(QueryProfile profile, String[] dimensionValues) {
        this.addInherited(profile, DimensionValues.createFrom(dimensionValues));
    }

    public void addInherited(QueryProfile profile, DimensionValues dimensionValues) {
        this.ensureNotFrozen();
        DimensionBinding dimensionBinding = DimensionBinding.createFrom(this.getDimensions(), dimensionValues);
        if (dimensionBinding.isNull()) {
            if (this.inherited == null) {
                this.inherited = new ArrayList<QueryProfile>();
            }
            this.inherited.add(profile);
        } else {
            if (this.variants == null) {
                this.variants = new QueryProfileVariants(dimensionBinding.getDimensions(), this);
            }
            this.variants.inherit(profile, dimensionBinding.getValues());
        }
    }

    public Map<String, Object> declaredContent() {
        this.ensureNotFrozen();
        return this.content.unmodifiableMap();
    }

    public Boolean isDeclaredOverridable(String name, Map<String, String> context) {
        return this.isDeclaredOverridable(new CompoundName(name), DimensionBinding.createFrom(this.getDimensions(), context));
    }

    public void setDimensions(String[] dimensions) {
        this.ensureNotFrozen();
        this.variants = new QueryProfileVariants(dimensions, this);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.ensureNotFrozen();
        this.value = value;
    }

    public List<String> getDimensions() {
        if (this.isFrozen()) {
            return this.resolvedDimensions;
        }
        if (this.variants != null) {
            return this.variants.getDimensions();
        }
        if (this.inherited == null) {
            return null;
        }
        for (QueryProfile inheritedProfile : this.inherited) {
            List<String> inheritedDimensions = inheritedProfile.getDimensions();
            if (inheritedDimensions == null) continue;
            return inheritedDimensions;
        }
        return null;
    }

    public final void setOverridable(String fieldName, boolean overridable, Map<String, String> context) {
        this.setOverridable(new CompoundName(fieldName), overridable, DimensionBinding.createFrom(this.getDimensions(), context));
    }

    public final Map<String, Object> listValues(String prefix) {
        return this.listValues(new CompoundName(prefix));
    }

    public final Map<String, Object> listValues(CompoundName prefix) {
        return this.listValues(prefix, null);
    }

    public final Map<String, Object> listValues(String prefix, Map<String, String> context) {
        return this.listValues(new CompoundName(prefix), context);
    }

    public final Map<String, Object> listValues(CompoundName prefix, Map<String, String> context) {
        return this.listValues(prefix, context, null);
    }

    public Map<String, Object> listValues(CompoundName prefix, Map<String, String> context, Properties substitution) {
        Map<String, Object> values = this.visitValues(prefix, context).values();
        if (substitution == null) {
            return values;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (entry.getValue().getClass() == String.class || !(entry.getValue() instanceof SubstituteString)) continue;
            entry.setValue(((SubstituteString)entry.getValue()).substitute(context, substitution));
        }
        return values;
    }

    AllValuesQueryProfileVisitor visitValues(CompoundName prefix, Map<String, String> context) {
        DimensionBinding dimensionBinding = DimensionBinding.createFrom(this.getDimensions(), context);
        AllValuesQueryProfileVisitor visitor = new AllValuesQueryProfileVisitor(prefix);
        this.accept(visitor, dimensionBinding, null);
        return visitor;
    }

    public final Object get(String name) {
        return this.get(name, (Map<String, String>)null);
    }

    public final Object get(String name, Map<String, String> context) {
        return this.get(name, context, null);
    }

    public final Object get(String name, String[] dimensionValues) {
        return this.get(name, dimensionValues, null);
    }

    public final Object get(String name, String[] dimensionValues, Properties substitution) {
        return this.get(name, DimensionValues.createFrom(dimensionValues), substitution);
    }

    public final Object get(String name, DimensionValues dimensionValues, Properties substitution) {
        return this.get(name, DimensionBinding.createFrom(this.getDimensions(), dimensionValues), substitution);
    }

    public final Object get(String name, Map<String, String> context, Properties substitution) {
        return this.get(name, DimensionBinding.createFrom(this.getDimensions(), context), substitution);
    }

    public final Object get(CompoundName name, Map<String, String> context, Properties substitution) {
        return this.get(name, DimensionBinding.createFrom(this.getDimensions(), context), substitution);
    }

    final Object get(String name, DimensionBinding binding, Properties substitution) {
        return this.get(new CompoundName(name), binding, substitution);
    }

    final Object get(CompoundName name, DimensionBinding binding, Properties substitution) {
        Object node = this.get(name, binding);
        if (node != null && node.getClass() == String.class) {
            return node;
        }
        if (node instanceof SubstituteString) {
            return ((SubstituteString)node).substitute(binding.getContext(), substitution);
        }
        return node;
    }

    final Object get(CompoundName name, DimensionBinding dimensionBinding) {
        return this.lookup(name, false, dimensionBinding);
    }

    public final Object lookup(String name, Map<String, String> context) {
        return this.lookup(new CompoundName(name), true, DimensionBinding.createFrom(this.getDimensions(), context));
    }

    public final void set(String name, Object value, QueryProfileRegistry registry) {
        this.set(name, value, (Map<String, String>)null, registry);
    }

    public final void set(CompoundName name, Object value, Map<String, String> context, QueryProfileRegistry registry) {
        this.set(name, value, DimensionBinding.createFrom(this.getDimensions(), context), registry);
    }

    public final void set(String name, Object value, Map<String, String> context, QueryProfileRegistry registry) {
        this.set(new CompoundName(name), value, DimensionBinding.createFrom(this.getDimensions(), context), registry);
    }

    public final void set(String name, Object value, String[] dimensionValues, QueryProfileRegistry registry) {
        this.set(name, value, DimensionValues.createFrom(dimensionValues), registry);
    }

    public final void set(String name, Object value, DimensionValues dimensionValues, QueryProfileRegistry registry) {
        this.set(new CompoundName(name), value, DimensionBinding.createFrom(this.getDimensions(), dimensionValues), registry);
    }

    public boolean isExplicit() {
        return !this.getId().isAnonymous();
    }

    public synchronized void freeze() {
        if (this.isFrozen()) {
            return;
        }
        this.resolvedDimensions = this.getDimensions();
        if (this.variants != null) {
            this.variants.freeze();
        }
        if (this.inherited != null) {
            for (QueryProfile inheritedProfile : this.inherited) {
                inheritedProfile.freeze();
            }
        }
        this.content.freeze();
        this.inherited = this.inherited == null ? ImmutableList.of() : ImmutableList.copyOf(this.inherited);
        super.freeze();
    }

    public String toString() {
        return "query profile '" + this.getId() + "'" + (String)(this.type != null ? " of type '" + this.type.getId() + "'" : "");
    }

    public QueryProfile clone() {
        if (this.isFrozen()) {
            return this;
        }
        QueryProfile clone = (QueryProfile)super.clone();
        if (this.variants != null) {
            clone.variants = this.variants.clone();
        }
        if (this.inherited != null) {
            clone.inherited = new ArrayList<QueryProfile>(this.inherited);
        }
        if (this.content != null) {
            clone.content = this.content.clone();
        }
        return clone;
    }

    static Object cloneIfNecessary(Object object) {
        if (object instanceof QueryProfile) {
            return ((QueryProfile)object).clone();
        }
        return object;
    }

    public static void validateName(String name) {
        Matcher nameMatcher = namePattern.matcher(name);
        if (!nameMatcher.matches()) {
            throw new IllegalArgumentException("Illegal name '" + name + "'");
        }
    }

    protected void set(CompoundName name, Object value, DimensionBinding binding, QueryProfileRegistry registry) {
        try {
            this.setNode(name, value, null, binding, registry);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException("Could not set '" + name + "' to '" + value + "'", (Throwable)e);
        }
    }

    protected Object convertToSubstitutionString(Object value) {
        if (value == null) {
            return value;
        }
        if (value.getClass() != String.class) {
            return value;
        }
        SubstituteString substituteString = SubstituteString.create((String)value);
        if (substituteString == null) {
            return value;
        }
        return substituteString;
    }

    protected FieldDescription getFieldDescription(CompoundName name, DimensionBinding binding) {
        FieldDescriptionQueryProfileVisitor visitor = new FieldDescriptionQueryProfileVisitor(name.asList());
        this.accept(visitor, binding, null);
        return visitor.result();
    }

    Boolean isLocalOverridable(String localName, DimensionBinding binding) {
        if (this.localLookup(localName, binding) == null) {
            return null;
        }
        Boolean isLocalInstanceOverridable = this.isLocalInstanceOverridable(localName);
        if (isLocalInstanceOverridable != null) {
            return (boolean)isLocalInstanceOverridable;
        }
        if (this.type != null) {
            return this.type.isOverridable(localName);
        }
        return true;
    }

    protected Boolean isLocalInstanceOverridable(String localName) {
        if (this.overridable == null) {
            return null;
        }
        return this.overridable.get(localName);
    }

    protected Object lookup(CompoundName name, boolean allowQueryProfileResult, DimensionBinding dimensionBinding) {
        SingleValueQueryProfileVisitor visitor = new SingleValueQueryProfileVisitor(name.asList(), allowQueryProfileResult);
        this.accept(visitor, dimensionBinding, null);
        return visitor.getResult();
    }

    protected final void accept(QueryProfileVisitor visitor, DimensionBinding dimensionBinding, QueryProfile owner) {
        this.acceptAndEnter("", visitor, dimensionBinding, owner);
    }

    void acceptAndEnter(String key, QueryProfileVisitor visitor, DimensionBinding dimensionBinding, QueryProfile owner) {
        boolean allowContent = visitor.enter(key);
        this.accept(allowContent, visitor, dimensionBinding, owner);
        if (allowContent) {
            visitor.leave(key);
        }
    }

    final void accept(boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding, QueryProfile owner) {
        visitor.onQueryProfile(this, dimensionBinding, owner, null);
        if (visitor.isDone()) {
            return;
        }
        this.visitVariants(allowContent, visitor, dimensionBinding);
        if (visitor.isDone()) {
            return;
        }
        if (allowContent) {
            this.visitContent(visitor, dimensionBinding);
            if (visitor.isDone()) {
                return;
            }
        }
        if (visitor.visitInherited()) {
            this.visitInherited(allowContent, visitor, dimensionBinding, owner);
        }
    }

    protected void visitVariants(boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        if (this.getVariants() != null) {
            this.getVariants().accept(allowContent, this.getType(), visitor, dimensionBinding);
        }
    }

    protected void visitInherited(boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding, QueryProfile owner) {
        if (this.inherited == null) {
            return;
        }
        for (QueryProfile inheritedProfile : this.inherited) {
            inheritedProfile.accept(allowContent, visitor, dimensionBinding.createFor(inheritedProfile.getDimensions()), owner);
            if (!visitor.isDone()) continue;
            return;
        }
    }

    private void visitContent(QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        String contentKey = visitor.getLocalKey();
        if (contentKey != null) {
            if (this.type != null) {
                contentKey = this.type.unalias(contentKey);
            }
            visitor.acceptValue(contentKey, this.getContent(contentKey), dimensionBinding, this, null);
        } else {
            for (Map.Entry<String, Object> entry : this.getContent().entrySet()) {
                visitor.acceptValue(entry.getKey(), entry.getValue(), dimensionBinding, this, null);
                if (!visitor.isDone()) continue;
                return;
            }
        }
    }

    protected Object getContent(String key) {
        return this.content.get(key);
    }

    protected Map<String, Object> getContent() {
        return this.content.unmodifiableMap();
    }

    protected QueryProfile setLocalNode(String localName, Object value, QueryProfileType parentType, DimensionBinding dimensionBinding, QueryProfileRegistry registry) {
        if (parentType != null && this.type == null && !this.isFrozen()) {
            this.type = parentType;
        }
        value = this.checkAndConvertAssignment(localName, value, registry);
        this.localPut(localName, value, dimensionBinding);
        return this;
    }

    static Object combineValues(Object newValue, Object existingValue) {
        if (newValue instanceof QueryProfile) {
            QueryProfile newProfile = (QueryProfile)newValue;
            if (existingValue == null || !(existingValue instanceof QueryProfile)) {
                if (!QueryProfile.isModifiable(newProfile)) {
                    newProfile = new BackedOverridableQueryProfile(newProfile);
                }
                newProfile.value = existingValue;
                return newProfile;
            }
            return QueryProfile.combineProfiles(newProfile, (QueryProfile)existingValue);
        }
        if (existingValue instanceof QueryProfile) {
            QueryProfile existingProfile = (QueryProfile)existingValue;
            if (QueryProfile.isModifiable(existingProfile)) {
                existingProfile.setValue(newValue);
                return null;
            }
            BackedOverridableQueryProfile existingOverridable = new BackedOverridableQueryProfile((QueryProfile)existingValue);
            existingOverridable.setValue(newValue);
            return existingOverridable;
        }
        return newValue;
    }

    private static QueryProfile combineProfiles(QueryProfile newProfile, QueryProfile existingProfile) {
        QueryProfile existingModifiable;
        QueryProfile returnValue = null;
        if (existingProfile.getClass() == QueryProfile.class) {
            returnValue = existingModifiable = new BackedOverridableQueryProfile(existingProfile);
        } else {
            existingModifiable = existingProfile;
        }
        if (existingModifiable instanceof BackedOverridableQueryProfile) {
            ((BackedOverridableQueryProfile)existingModifiable).addInheritedHere(newProfile);
        } else {
            existingModifiable.addInherited(newProfile);
        }
        if (existingModifiable.content != null) {
            for (String key : existingModifiable.content.unmodifiableMap().keySet()) {
                if (newProfile.isLocalOverridable(key, null).booleanValue()) continue;
                existingModifiable.content.remove(key);
            }
        }
        return returnValue;
    }

    private static boolean isModifiable(QueryProfile profile) {
        if (profile.isFrozen()) {
            return false;
        }
        if (!profile.isExplicit()) {
            return true;
        }
        return profile instanceof BackedOverridableQueryProfile;
    }

    protected Object checkAndConvertAssignment(String localName, Object value, QueryProfileRegistry registry) {
        if (this.type == null) {
            return value;
        }
        FieldDescription fieldDescription = this.type.getField(localName);
        if (fieldDescription == null) {
            if (this.type.isStrict()) {
                throw new IllegalInputException("'" + localName + "' is not declared in " + this.type + ", and the type is strict");
            }
            return value;
        }
        if (registry == null && fieldDescription.getType() instanceof QueryProfileFieldType) {
            throw new IllegalInputException("A registry was not passed: Query profile references is not supported");
        }
        Object convertedValue = fieldDescription.getType().convertFrom(value, registry);
        if (convertedValue == null) {
            throw new IllegalInputException("'" + value + "' is not a " + fieldDescription.getType().toInstanceDescription());
        }
        return convertedValue;
    }

    protected QueryProfile createSubProfile(String name, DimensionBinding dimensionBinding) {
        return new QueryProfile(ComponentId.createAnonymousComponentId((String)name), this.source);
    }

    protected Object localLookup(String name, DimensionBinding dimensionBinding) {
        Object node = null;
        if (this.variants != null && !dimensionBinding.isNull()) {
            node = this.variants.get(name, this.type, true, dimensionBinding);
        }
        if (node == null) {
            node = this.content == null ? null : this.content.get(name);
        }
        return node;
    }

    private Boolean isDeclaredOverridable(CompoundName name, DimensionBinding dimensionBinding) {
        QueryProfile parent = this.lookupParentExact(name, true, dimensionBinding);
        if (parent.overridable == null) {
            return null;
        }
        return parent.overridable.get(name.last());
    }

    private void setOverridable(CompoundName fieldName, boolean overridable, DimensionBinding dimensionBinding) {
        QueryProfile parent = this.lookupParentExact(fieldName, true, dimensionBinding);
        if (parent.overridable == null) {
            parent.overridable = new HashMap<String, Boolean>();
        }
        parent.overridable.put(fieldName.last(), overridable);
    }

    private void setNode(CompoundName name, Object value, QueryProfileType parentType, DimensionBinding dimensionBinding, QueryProfileRegistry registry) {
        this.ensureNotFrozen();
        if (name.isCompound()) {
            QueryProfile parent = this.getQueryProfileExact(name.first(), true, dimensionBinding);
            parent.setNode(name.rest(), value, parentType, dimensionBinding.createFor(parent.getDimensions()), registry);
        } else {
            this.setLocalNode(name.toString(), value, parentType, dimensionBinding, registry);
        }
    }

    private QueryProfile lookupParentExact(CompoundName name, boolean create, DimensionBinding dimensionBinding) {
        CompoundName rest = name.rest();
        if (rest.isEmpty()) {
            return this;
        }
        QueryProfile topmostParent = this.getQueryProfileExact(name.first(), create, dimensionBinding);
        if (topmostParent == null) {
            return null;
        }
        return topmostParent.lookupParentExact(rest, create, dimensionBinding.createFor(topmostParent.getDimensions()));
    }

    private QueryProfile getQueryProfileExact(String localName, boolean create, DimensionBinding dimensionBinding) {
        Object node = this.localExactLookup(localName, dimensionBinding);
        if (node instanceof QueryProfile) {
            return (QueryProfile)node;
        }
        if (!create) {
            return null;
        }
        QueryProfile queryProfile = this.createSubProfile(localName, dimensionBinding);
        if (this.type != null) {
            Class<?> legalClass = this.type.getValueClass(localName);
            if (legalClass == null || !legalClass.isInstance(queryProfile)) {
                throw new RuntimeException("'" + localName + "' is not a legal query profile reference name in " + this);
            }
            queryProfile.setType(this.type.getType(localName));
        }
        this.localPut(localName, queryProfile, dimensionBinding);
        return queryProfile;
    }

    private Object localExactLookup(String name, DimensionBinding dimensionBinding) {
        if (dimensionBinding.isNull()) {
            return this.content == null ? null : this.content.get(name);
        }
        if (this.variants == null) {
            return null;
        }
        QueryProfileVariant variant = this.variants.getVariant(dimensionBinding.getValues(), false);
        if (variant == null) {
            return null;
        }
        return variant.values().get(name);
    }

    private void localPut(String localName, Object value, DimensionBinding dimensionBinding) {
        this.ensureNotFrozen();
        if (this.type != null) {
            localName = this.type.unalias(localName);
        }
        QueryProfile.validateName(localName);
        value = this.convertToSubstitutionString(value);
        if (dimensionBinding.isNull()) {
            Object combinedValue = value instanceof QueryProfile ? QueryProfile.combineValues(value, this.content == null ? null : this.content.get(localName)) : QueryProfile.combineValues(value, this.localLookup(localName, dimensionBinding));
            if (combinedValue != null) {
                this.content.put(localName, combinedValue);
            }
        } else {
            if (this.variants == null) {
                this.variants = new QueryProfileVariants(dimensionBinding.getDimensions(), this);
            }
            this.variants.set(localName, dimensionBinding.getValues(), value);
        }
    }

    public CompiledQueryProfile compile(CompiledQueryProfileRegistry registry) {
        return QueryProfileCompiler.compile(this, registry);
    }
}

