/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.context;

import com.yahoo.processing.execution.Execution;
import com.yahoo.search.Query;
import com.yahoo.search.rendering.XmlRenderer;
import com.yahoo.text.XMLWriter;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class QueryContext
implements Cloneable {
    public static final String ID = "context";
    private Query owner;

    public QueryContext(int ignored, Query owner) {
        this.owner = owner;
    }

    public void trace(String message, int traceLevel) {
        this.trace((Object)message, traceLevel);
    }

    public void trace(Object message, int traceLevel) {
        this.owner.getModel().getExecution().trace().trace(message, traceLevel);
    }

    public void logValue(String key, Object value) {
        this.owner.getModel().getExecution().trace().logValue(key, value.toString());
    }

    public Iterator<Execution.Trace.LogValue> logValueIterator() {
        return this.owner.getModel().getExecution().trace().logValueIterator();
    }

    public void setProperty(String name, Object value) {
        this.owner.getModel().getExecution().trace().setProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.owner.getModel().getExecution().trace().getProperty(name);
    }

    public String toString() {
        return this.owner.getModel().getExecution().trace().toString();
    }

    public boolean render(Writer writer) throws IOException {
        if (this.owner.getTraceLevel() != 0) {
            XMLWriter xmlWriter = XMLWriter.from((Writer)writer);
            xmlWriter.openTag("meta").attribute("type", (Object)ID);
            TraceNode traceRoot = this.owner.getModel().getExecution().trace().traceNode().root();
            traceRoot.accept((TraceVisitor)new XmlRenderer.RenderingVisitor(xmlWriter, this.owner.getStartTime()));
            xmlWriter.closeTag();
        }
        return true;
    }

    public QueryContext cloneFor(Query cloneOwner) {
        try {
            QueryContext clone = (QueryContext)super.clone();
            clone.owner = cloneOwner;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Execution.Trace getTrace() {
        return this.owner.getModel().getExecution().trace();
    }

    public QueryContext clone() {
        try {
            return (QueryContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

