/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.prelude.query.Substring;

public class Token {
    public final Substring substring;
    public final Kind kind;
    public final String image;
    private final boolean special;

    public Token(Kind kind, String image) {
        this(kind, image, false, null);
    }

    public Token(Kind kind, String image, Substring substring) {
        this(kind, image, false, substring);
    }

    public Token(Kind kind, String image, boolean special, Substring substring) {
        this.kind = kind;
        this.image = image;
        this.special = special;
        this.substring = substring;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public String toString() {
        return this.image;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Token other = (Token)object;
        if (this.kind != other.kind) {
            return false;
        }
        return this.image.equals(other.image);
    }

    public Substring getSubstring() {
        return this.substring;
    }

    public int hashCode() {
        return this.image.hashCode() ^ this.kind.hashCode();
    }

    public static enum Kind {
        EOF("<EOF>"),
        NUMBER("<NUMBER>"),
        WORD("<WORD>"),
        LETTER("<LETTER>"),
        DIGIT("<DIGIT>"),
        SPACE("\" \""),
        NOISE("<NOISE>"),
        LATINSIGN("<LATINSIGN>"),
        QUOTE("\"\\\"\""),
        MINUS("\"-\""),
        PLUS("\"+\""),
        DOT("\".\""),
        COMMA("\",\""),
        COLON("\":\""),
        LBRACE("\"(\""),
        RBRACE("\")\""),
        LSQUAREBRACKET("\"[\""),
        RSQUAREBRACKET("\"]\""),
        SEMICOLON("\";\""),
        GREATER("\">\""),
        SMALLER("\"<\""),
        EXCLAMATION("\"!\""),
        UNDERSCORE("\"_\""),
        HAT("\"^\""),
        STAR("\"*\""),
        DOLLAR("\"$\""),
        DEFAULT("");

        public final String image;

        private Kind(String image) {
            this.image = image;
        }
    }
}

