/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentSummaryMessage;
import com.yahoo.documentapi.messagebus.protocol.QueryResultMessage;
import com.yahoo.documentapi.messagebus.protocol.SearchResultMessage;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.Ranking;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vdslib.VisitorStatistics;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import com.yahoo.vespa.streamingvisitors.ListMerger;
import com.yahoo.vespa.streamingvisitors.VdsStreamingSearcher;
import com.yahoo.vespa.streamingvisitors.Visitor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class VdsVisitor
extends VisitorDataHandler
implements Visitor {
    private static final CompoundName streamingUserid = new CompoundName("streaming.userid");
    private static final CompoundName streamingGroupname = new CompoundName("streaming.groupname");
    private static final CompoundName streamingSelection = new CompoundName("streaming.selection");
    private static final CompoundName streamingFromtimestamp = new CompoundName("streaming.fromtimestamp");
    private static final CompoundName streamingTotimestamp = new CompoundName("streaming.totimestamp");
    private static final CompoundName streamingLoadtype = new CompoundName("streaming.loadtype");
    private static final CompoundName streamingPriority = new CompoundName("streaming.priority");
    private static final CompoundName streamingMaxbucketspervisitor = new CompoundName("streaming.maxbucketspervisitor");
    private static final Logger log = Logger.getLogger(VdsVisitor.class.getName());
    private final VisitorParameters params = new VisitorParameters("");
    private List<SearchResult.Hit> hits = new ArrayList<SearchResult.Hit>();
    private int totalHitCount = 0;
    private final Map<String, DocumentSummary.Summary> summaryMap = new HashMap<String, DocumentSummary.Summary>();
    private final Map<Integer, Grouping> groupingMap = new ConcurrentHashMap<Integer, Grouping>();
    private Query query = null;
    private VisitorSessionFactory visitorSessionFactory;
    private final int traceLevelOverride;
    private Trace sessionTrace;

    public VdsVisitor(Query query, String searchCluster, Route route, String documentType, int traceLevelOverride) {
        this(query, searchCluster, route, documentType, MessageBusVisitorSessionFactory.sharedInstance(), traceLevelOverride);
    }

    public VdsVisitor(Query query, String searchCluster, Route route, String documentType, VisitorSessionFactory visitorSessionFactory, int traceLevelOverride) {
        this.query = query;
        this.visitorSessionFactory = visitorSessionFactory;
        this.traceLevelOverride = traceLevelOverride;
        this.setVisitorParameters(searchCluster, route, documentType);
    }

    private int inferSessionTraceLevel(Query query) {
        int implicitLevel = this.traceLevelOverride;
        if (log.isLoggable(Level.FINEST)) {
            implicitLevel = 9;
        } else if (log.isLoggable(Level.FINE)) {
            implicitLevel = 7;
        }
        return Math.max(query.getTraceLevel(), implicitLevel);
    }

    private static String createSelectionString(String documentType, String selection) {
        if (selection == null || selection.isEmpty()) {
            return documentType;
        }
        StringBuilder sb = new StringBuilder(documentType);
        sb.append(" and ( ").append(selection).append(" )");
        return sb.toString();
    }

    private String createQuerySelectionString() {
        String s = this.query.properties().getString(streamingUserid);
        if (s != null) {
            return "id.user==" + s;
        }
        s = this.query.properties().getString(streamingGroupname);
        if (s != null) {
            return "id.group==\"" + s + "\"";
        }
        return this.query.properties().getString(streamingSelection);
    }

    private void setVisitorParameters(String searchCluster, Route route, String documentType) {
        List<Grouping> groupingList;
        LoadType loadType;
        this.params.setDocumentSelection(VdsVisitor.createSelectionString(documentType, this.createQuerySelectionString()));
        this.params.setTimeoutMs(this.query.getTimeout());
        this.params.setSessionTimeoutMs(this.query.getTimeout());
        this.params.setVisitorLibrary("searchvisitor");
        this.params.setLocalDataHandler((VisitorDataHandler)this);
        if (this.query.properties().getDouble(streamingFromtimestamp) != null) {
            this.params.setFromTimestamp(this.query.properties().getDouble(streamingFromtimestamp).longValue());
        }
        if (this.query.properties().getDouble(streamingTotimestamp) != null) {
            this.params.setToTimestamp(this.query.properties().getDouble(streamingTotimestamp).longValue());
        }
        this.params.visitInconsistentBuckets(true);
        this.params.setPriority(DocumentProtocol.Priority.VERY_HIGH);
        if (this.query.properties().getString(streamingLoadtype) != null && (loadType = (LoadType)this.visitorSessionFactory.getLoadTypeSet().getNameMap().get(this.query.properties().getString(streamingLoadtype))) != null) {
            this.params.setLoadType(loadType);
            this.params.setPriority(loadType.getPriority());
        }
        if (this.query.properties().getString(streamingPriority) != null) {
            this.params.setPriority(DocumentProtocol.getPriorityByName((String)this.query.properties().getString(streamingPriority)));
        }
        this.params.setMaxPending(Integer.MAX_VALUE);
        this.params.setMaxBucketsPerVisitor(Integer.MAX_VALUE);
        this.params.setTraceLevel(this.inferSessionTraceLevel(this.query));
        String maxbuckets = this.query.properties().getString(streamingMaxbucketspervisitor);
        if (maxbuckets != null) {
            this.params.setMaxBucketsPerVisitor(Integer.parseInt(maxbuckets));
        }
        EncodedData ed = new EncodedData();
        VdsVisitor.encodeQueryData(this.query, 0, ed);
        this.params.setLibraryParameter("query", ed.getEncodedData());
        this.params.setLibraryParameter("querystackcount", String.valueOf(ed.getReturned()));
        this.params.setLibraryParameter("searchcluster", searchCluster.getBytes());
        if (this.query.getPresentation().getSummary() != null) {
            this.params.setLibraryParameter("summaryclass", this.query.getPresentation().getSummary());
        } else {
            this.params.setLibraryParameter("summaryclass", "default");
        }
        this.params.setLibraryParameter("summarycount", String.valueOf(this.query.getOffset() + this.query.getHits()));
        this.params.setLibraryParameter("rankprofile", this.query.getRanking().getProfile());
        this.params.setLibraryParameter("allowslimedocsums", "true");
        this.params.setLibraryParameter("queryflags", String.valueOf(VdsVisitor.getQueryFlags(this.query)));
        ByteBuffer buf = ByteBuffer.allocate(1024);
        if (this.query.getRanking().getLocation() != null) {
            buf.clear();
            this.query.getRanking().getLocation().encode(buf);
            buf.flip();
            byte[] af = new byte[buf.remaining()];
            buf.get(af);
            this.params.setLibraryParameter("location", af);
        }
        if (this.query.hasEncodableProperties()) {
            VdsVisitor.encodeQueryData(this.query, 1, ed);
            this.params.setLibraryParameter("rankproperties", ed.getEncodedData());
        }
        if ((groupingList = GroupingExecutor.getGroupingList(this.query)).size() > 0) {
            BufferSerializer gbuf = new BufferSerializer(new GrowableByteBuffer());
            gbuf.putInt(null, groupingList.size());
            for (Grouping g : groupingList) {
                g.serialize((Serializer)gbuf);
            }
            gbuf.flip();
            byte[] blob = gbuf.getBytes(null, gbuf.getBuf().limit());
            this.params.setLibraryParameter("aggregation", blob);
        }
        if (this.query.getRanking().getSorting() != null) {
            VdsVisitor.encodeQueryData(this.query, 3, ed);
            this.params.setLibraryParameter("sort", ed.getEncodedData());
        }
        this.params.setRoute(route);
    }

    static int getQueryFlags(Query query) {
        int flags = 0;
        boolean requestCoverage = true;
        flags |= 0;
        flags |= query.properties().getBoolean(Model.ESTIMATE) ? 128 : 0;
        flags |= query.getRanking().getFreshness() != null ? 8192 : 0;
        flags |= requestCoverage ? 32768 : 0;
        flags |= query.getNoCache() ? 65536 : 0;
        flags |= 0x20000;
        return flags |= query.properties().getBoolean(Ranking.RANKFEATURES, false) ? 262144 : 0;
    }

    private static void encodeQueryData(Query query, int code, EncodedData ed) {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        while (true) {
            try {
                switch (code) {
                    case 0: {
                        ed.setReturned(query.getModel().getQueryTree().getRoot().encode(buf));
                        break;
                    }
                    case 1: {
                        ed.setReturned(query.encodeAsProperties(buf, true));
                        break;
                    }
                    case 2: {
                        throw new IllegalArgumentException("old aggregation no longer exists!");
                    }
                    case 3: {
                        if (query.getRanking().getSorting() != null) {
                            ed.setReturned(query.getRanking().getSorting().encode(buf));
                            break;
                        }
                        ed.setReturned(0);
                    }
                }
                buf.flip();
            }
            catch (BufferOverflowException e) {
                int size = buf.limit();
                buf = ByteBuffer.allocate(size * 2);
                continue;
            }
            break;
        }
        byte[] bb = new byte[buf.remaining()];
        buf.get(bb);
        ed.setEncodedData(bb);
    }

    @Override
    public void doSearch() throws InterruptedException, ParseException, TimeoutException {
        VisitorSession session = this.visitorSessionFactory.createVisitorSession(this.params);
        try {
            if (!session.waitUntilDone(this.query.getTimeout())) {
                log.log(Level.FINE, "Visitor returned from waitUntilDone without being completed for " + this.query + " with selection " + this.params.getDocumentSelection());
                session.abort();
                throw new TimeoutException("Query timed out in " + VdsStreamingSearcher.class.getName());
            }
        }
        finally {
            session.destroy();
            this.sessionTrace = session.getTrace();
            log.log(Level.FINE, () -> this.sessionTrace.toString());
            this.query.trace(this.sessionTrace.toString(), false, 9);
        }
        if (this.params.getControlHandler().getResult().code == VisitorControlHandler.CompletionCode.SUCCESS) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "VdsVisitor completed successfully for " + this.query + " with selection " + this.params.getDocumentSelection());
            }
        } else {
            throw new IllegalArgumentException("Query failed: " + this.params.getControlHandler().getResult().code + ": " + this.params.getControlHandler().getResult().message);
        }
    }

    @Override
    public VisitorStatistics getStatistics() {
        return this.params.getControlHandler().getVisitorStatistics();
    }

    public void onMessage(Message m, AckToken token) {
        if (m instanceof QueryResultMessage) {
            QueryResultMessage qm = (QueryResultMessage)m;
            this.onQueryResult(qm.getResult(), qm.getSummary());
        } else if (m instanceof SearchResultMessage) {
            this.onSearchResult(((SearchResultMessage)m).getResult());
        } else if (m instanceof DocumentSummaryMessage) {
            DocumentSummaryMessage dsm = (DocumentSummaryMessage)m;
            this.onDocumentSummary(dsm.getResult());
        } else {
            throw new UnsupportedOperationException("Received unsupported message " + m + ". VdsVisitor can only accept query result, search result, and documentsummary messages.");
        }
        this.ack(token);
    }

    @Override
    public Trace getTrace() {
        return this.sessionTrace;
    }

    public void onQueryResult(SearchResult sr, DocumentSummary summary) {
        this.handleSearchResult(sr);
        this.handleSummary(summary);
    }

    public void onSearchResult(SearchResult sr) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Got SearchResult for query with selection " + this.params.getDocumentSelection());
        }
        this.handleSearchResult(sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSearchResult(SearchResult sr) {
        int hitCountTotal = sr.getTotalHitCount();
        int hitCount = sr.getHitCount();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Got SearchResult with " + hitCountTotal + " in total and " + hitCount + " hits in real for query with selection " + this.params.getDocumentSelection());
        }
        ArrayList<SearchResult.Hit> newHits = new ArrayList<SearchResult.Hit>(hitCount);
        for (int i = 0; i < hitCount; ++i) {
            SearchResult.Hit hit = sr.getHit(i);
            newHits.add(hit);
        }
        VdsVisitor i = this;
        synchronized (i) {
            this.totalHitCount += hitCountTotal;
            this.hits = ListMerger.mergeIntoArrayList(this.hits, newHits, this.query.getOffset() + this.query.getHits());
        }
        Map newGroupingMap = sr.getGroupingList();
        this.mergeGroupingMaps(newGroupingMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeGroupingMaps(Map<Integer, byte[]> newGroupingMap) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "mergeGroupingMaps: newGroupingMap = " + newGroupingMap);
        }
        for (Integer key : newGroupingMap.keySet()) {
            byte[] value = newGroupingMap.get(key);
            Grouping newGrouping = new Grouping();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received group with key " + key + " and size " + value.length);
            }
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(ByteBuffer.wrap(value)));
            newGrouping.deserialize((Deserializer)buf);
            if (buf.getBuf().hasRemaining()) {
                throw new IllegalArgumentException("Failed deserializing grouping. There are still data left. Position = " + buf.position() + ", limit = " + buf.getBuf().limit());
            }
            Map<Integer, Grouping> map = this.groupingMap;
            synchronized (map) {
                if (this.groupingMap.containsKey(key)) {
                    Grouping grouping = this.groupingMap.get(key);
                    grouping.merge(newGrouping);
                } else {
                    this.groupingMap.put(key, newGrouping);
                }
            }
        }
    }

    public void onDocumentSummary(DocumentSummary ds) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Got DocumentSummary for query with selection " + this.params.getDocumentSelection());
        }
        this.handleSummary(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSummary(DocumentSummary ds) {
        int summaryCount = ds.getSummaryCount();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Got DocumentSummary with " + summaryCount + " summaries for query with selection " + this.params.getDocumentSelection());
        }
        Map<String, DocumentSummary.Summary> map = this.summaryMap;
        synchronized (map) {
            for (int i = 0; i < summaryCount; ++i) {
                DocumentSummary.Summary summary = ds.getSummary(i);
                this.summaryMap.put(summary.getDocId(), summary);
            }
        }
    }

    @Override
    public final List<SearchResult.Hit> getHits() {
        int fromIndex = Math.min(this.hits.size(), this.query.getOffset());
        int toIndex = Math.min(this.hits.size(), this.query.getOffset() + this.query.getHits());
        return this.hits.subList(fromIndex, toIndex);
    }

    @Override
    public final Map<String, DocumentSummary.Summary> getSummaryMap() {
        return this.summaryMap;
    }

    @Override
    public final int getTotalHitCount() {
        return this.totalHitCount;
    }

    @Override
    public final List<Grouping> getGroupings() {
        Collection<Grouping> groupings = this.groupingMap.values();
        for (Grouping g : groupings) {
            g.postMerge();
        }
        Grouping[] array = groupings.toArray(new Grouping[groupings.size()]);
        return Arrays.asList(array);
    }

    private static class EncodedData {
        private Object returned;
        private byte[] encoded;

        private EncodedData() {
        }

        public void setReturned(Object o) {
            this.returned = o;
        }

        public Object getReturned() {
            return this.returned;
        }

        public void setEncodedData(byte[] data) {
            this.encoded = data;
        }

        public byte[] getEncodedData() {
            return this.encoded;
        }
    }

    private static class MessageBusVisitorSessionFactory
    implements VisitorSessionFactory {
        private static final Object initMonitor = new Object();
        private static final AtomicReference<MessageBusVisitorSessionFactory> instance = new AtomicReference();
        private final LoadTypeSet loadTypes = new LoadTypeSet("client");
        private final DocumentAccess access = new MessageBusDocumentAccess(new MessageBusParams(this.loadTypes));

        private MessageBusVisitorSessionFactory() {
        }

        @Override
        public VisitorSession createVisitorSession(VisitorParameters params) throws ParseException {
            return this.access.createVisitorSession(params);
        }

        @Override
        public LoadTypeSet getLoadTypeSet() {
            return this.loadTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static MessageBusVisitorSessionFactory sharedInstance() {
            MessageBusVisitorSessionFactory ref = instance.getAcquire();
            if (ref != null) {
                return ref;
            }
            Object object = initMonitor;
            synchronized (object) {
                ref = instance.getAcquire();
                if (ref != null) {
                    return ref;
                }
                ref = new MessageBusVisitorSessionFactory();
                instance.setRelease(ref);
            }
            return ref;
        }
    }

    public static interface VisitorSessionFactory {
        public VisitorSession createVisitorSession(VisitorParameters var1) throws ParseException;

        public LoadTypeSet getLoadTypeSet();
    }
}

