/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text.interpretation;

import com.yahoo.text.interpretation.AnnotationClass;
import com.yahoo.text.interpretation.Annotations;
import com.yahoo.text.interpretation.Modification;
import com.yahoo.text.interpretation.Span;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Interpretation {
    private Modification modification;
    private double probability;
    private Span rootSpan;
    public static final AnnotationClass INTERPRETATION_CLASS = new AnnotationClass("interpretation");

    public Interpretation(String text) {
        this(text, 0.0);
    }

    public Interpretation(String text, double probabilty) {
        this(new Modification(text), probabilty);
    }

    public Interpretation(Modification modification) {
        this(modification, 0.0);
    }

    public Interpretation(Modification modification, double probability) {
        this.modification = modification;
        this.rootSpan = new Span(modification);
        this.setProbability(probability);
    }

    public Modification getModification() {
        return this.modification;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        if (probability < 0.0) {
            probability = 0.0;
        } else if (probability > 1.0) {
            probability = 1.0;
        }
        this.probability = probability;
    }

    public Span root() {
        return this.rootSpan;
    }

    public Annotations annotate(String annotationClass) {
        return this.annotate(new AnnotationClass(annotationClass));
    }

    public Annotations annotate(AnnotationClass annotationClass) {
        return this.rootSpan.annotate(annotationClass);
    }

    public void annotate(String annotationClass, String key, Object value) {
        this.annotate(new AnnotationClass(annotationClass)).put(key, value);
    }

    public void annotate(AnnotationClass annotationClass, String key, Object value) {
        this.annotate(annotationClass).put(key, value);
    }

    public Annotations annotate(int from, int to, String annotationClass) {
        return this.annotate(from, to, new AnnotationClass(annotationClass));
    }

    public Annotations annotate(int from, int to, AnnotationClass annotationClass) {
        return this.rootSpan.annotate(from, to, annotationClass);
    }

    public void annotate(int from, int to, String annotationClass, String key, Object value) {
        this.annotate(from, to, new AnnotationClass(annotationClass)).put(key, value);
    }

    public void annotate(int from, int to, AnnotationClass annotationClass, String key, Object value) {
        this.annotate(from, to, annotationClass).put(key, value);
    }

    public Map<AnnotationClass, List<Annotations>> getAll() {
        return this.rootSpan.getAllAnnotations();
    }

    public List<Annotations> getAll(String annotationClass) {
        return this.getAll(new AnnotationClass(annotationClass));
    }

    public List<Annotations> getAll(AnnotationClass annotationClass) {
        Map<AnnotationClass, List<Annotations>> all = this.getAll();
        if (all.containsKey(annotationClass)) {
            return all.get(annotationClass);
        }
        return Collections.emptyList();
    }

    public Annotations get(String annotationClass) {
        return this.get(new AnnotationClass(annotationClass));
    }

    public Annotations get(AnnotationClass annotationClass) {
        return this.rootSpan.getAnnotation(annotationClass);
    }

    public Object get(String annotationClass, String key) {
        return this.get(new AnnotationClass(annotationClass), key);
    }

    public Object get(AnnotationClass annotationClass, String key) {
        Annotations annotations = this.get(annotationClass);
        if (annotations != null) {
            return annotations.get(key);
        }
        return null;
    }

    public Annotations get(int from, int to, String annotationClass) {
        return this.get(from, to, new AnnotationClass(annotationClass));
    }

    public Annotations get(int from, int to, AnnotationClass annotationClass) {
        return this.rootSpan.getAnnotation(from, to, annotationClass);
    }

    public Object get(int from, int to, String annotationClass, String key) {
        Annotations annotations = this.get(from, to, annotationClass);
        if (annotations != null) {
            return annotations.get(key);
        }
        return null;
    }

    public Set<AnnotationClass> getClasses() {
        return this.rootSpan.getClasses();
    }

    public Set<AnnotationClass> getClasses(int from, int to) {
        return this.rootSpan.getClasses(from, to);
    }

    public List<Span> getTokens() {
        return this.rootSpan.getTokens();
    }

    public List<Span> getTermSpans(String term) {
        return this.rootSpan.getTermSpans(term);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<AnnotationClass, List<Annotations>> annotations = this.getAll();
        Iterator<Map.Entry<AnnotationClass, List<Annotations>>> mapIterator = annotations.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry<AnnotationClass, List<Annotations>> entry = mapIterator.next();
            Iterator<Annotations> annoIterator = entry.getValue().iterator();
            sb.append(entry.getKey()).append(" : [");
            while (annoIterator.hasNext()) {
                Annotations annotation = annoIterator.next();
                sb.append("\"").append(annotation.getSubString()).append("\"");
                this.dumpAnnotation(sb, annotation);
                if (!annoIterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]");
            if (!mapIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void dumpAnnotation(StringBuilder sb, Annotations annotations) {
        if (annotations.getMap().size() > 0) {
            sb.append(" : {");
            Iterator<Map.Entry<String, Object>> valueIterator = annotations.getMap().entrySet().iterator();
            while (valueIterator.hasNext()) {
                Map.Entry<String, Object> value = valueIterator.next();
                sb.append(value.getKey()).append(" : ").append(value.getValue());
                if (!valueIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
    }
}

