/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.search.Result;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class HitIterator
implements Iterator<Hit> {
    private int index = -1;
    private List<Hit> hits;
    private HitGroup hitGroup;
    private boolean canRemove = false;

    public HitIterator(HitGroup hitGroup, List<Hit> hits) {
        this.hitGroup = hitGroup;
        this.hits = hits;
    }

    public HitIterator(Result result, List<Hit> hits) {
        this.hitGroup = result.hits();
        this.hits = hits;
    }

    @Override
    public boolean hasNext() {
        return this.hits.size() > this.index + 1;
    }

    @Override
    public Hit next() throws NoSuchElementException {
        if (this.hits.size() <= this.index + 1) {
            throw new NoSuchElementException();
        }
        this.canRemove = true;
        return this.hits.get(++this.index);
    }

    @Override
    public void remove() throws IllegalStateException {
        if (!this.canRemove) {
            throw new IllegalStateException();
        }
        this.hitGroup.remove(this.index);
        --this.index;
        this.canRemove = false;
    }
}

