/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.text.PositionedString;
import com.yahoo.text.SimpleMapParser;
import java.math.BigInteger;

abstract class BooleanAttributeParser
extends SimpleMapParser {
    private boolean isMap = true;

    BooleanAttributeParser() {
    }

    public void parse(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        super.parse(s);
        if (this.string().position() != this.string().string().length()) {
            throw new IllegalArgumentException("Expected end of string " + this.string().at());
        }
    }

    protected int findEndOfValue() {
        if (this.isMap) {
            return BooleanAttributeParser.findNextButSkipLists(new char[]{',', '}'}, this.string().string(), this.string().position());
        }
        return BooleanAttributeParser.findNextButSkipLists(new char[]{',', ']'}, this.string().string(), this.string().position());
    }

    protected void handleKeyValue(String attribute, String value) {
        if (this.string().peek('[') && this.isMap) {
            this.isMap = false;
            this.parseMultiValue(attribute);
            this.isMap = true;
        } else {
            this.handleAttribute(attribute, value);
        }
    }

    private void parseMultiValue(String attribute) {
        this.string().consume('[');
        while (!this.string().peek(']')) {
            this.string().consumeSpaces();
            this.consumeValue(attribute);
            this.string().consumeOptional(',');
            this.string().consumeSpaces();
        }
    }

    private void handleAttribute(String attribute, String value) {
        int pos = value.indexOf(58);
        if (pos != -1) {
            this.parseBitmap(attribute, value.substring(0, pos), value.substring(pos + 1));
        } else {
            this.addAttribute(attribute, value);
        }
    }

    private void parseBitmap(String attribute, String value, String bitmap) {
        if (bitmap.charAt(0) == '[') {
            this.parseBitmapList(attribute, value, bitmap);
        } else {
            this.parseBitmapHex(attribute, value, bitmap);
        }
    }

    private void parseBitmapHex(String attribute, String value, String bitmap) {
        PositionedString s = new PositionedString(bitmap);
        s.consume('0');
        s.consume('x');
        this.addAttribute(attribute, value, new BigInteger(s.substring().trim(), 16));
    }

    private void parseBitmapList(String attribute, String value, String bitmap) {
        PositionedString s = new PositionedString(bitmap);
        s.consume('[');
        BigInteger mask = BigInteger.ZERO;
        while (!s.peek(']')) {
            s.consumeSpaces();
            int pos = BooleanAttributeParser.findNextButSkipLists(new char[]{',', ']'}, s.string(), s.position());
            if (pos == -1) break;
            int subqueryIndex = Integer.parseUnsignedInt(s.substring(pos).trim());
            if (subqueryIndex > 63 || subqueryIndex < 0) {
                throw new IllegalArgumentException("Subquery index must be in the range 0-63");
            }
            mask = mask.or(BigInteger.ONE.shiftLeft(subqueryIndex));
            s.setPosition(pos);
            s.consumeOptional(',');
            s.consumeSpaces();
        }
        this.addAttribute(attribute, value, mask);
    }

    protected abstract void addAttribute(String var1, String var2);

    protected abstract void addAttribute(String var1, String var2, BigInteger var3);

    private static int findNextButSkipLists(char[] chars, String s, int position) {
        while (position < s.length()) {
            if (s.charAt(position) == '[') {
                if ((position = BooleanAttributeParser.findNextButSkipLists(new char[]{']'}, s, position + 1)) < 0) {
                    return -1;
                }
            } else {
                for (char c : chars) {
                    if (s.charAt(position) != c) continue;
                    return position;
                }
            }
            ++position;
        }
        return -1;
    }
}

