/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.fs4.MapEncoder;
import com.yahoo.text.JSON;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RankProperties
implements Cloneable {
    private Map<String, List<Object>> properties;

    public RankProperties() {
        this(new LinkedHashMap<String, List<Object>>());
    }

    private RankProperties(Map<String, List<Object>> properties) {
        this.properties = properties;
    }

    public void put(String name, String value) {
        this.put(name, (Object)value);
    }

    public void put(String name, Object value) {
        List<Object> list = this.properties.get(name);
        if (list == null) {
            list = new ArrayList<Object>();
            this.properties.put(name, list);
        }
        list.add(value);
    }

    public List<String> get(String name) {
        List<Object> values = this.properties.get(name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            stringValues.add(value.toString());
        }
        return Collections.unmodifiableList(stringValues);
    }

    public void remove(String name) {
        this.properties.remove(name);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Map<String, List<Object>> asMap() {
        return this.properties;
    }

    public int encode(ByteBuffer buffer, boolean encodeQueryData) {
        if (encodeQueryData) {
            return MapEncoder.encodeMultiMap("rank", this.properties, buffer);
        }
        List<Object> sessionId = this.properties.get("sessionId");
        if (sessionId == null) {
            return 0;
        }
        return MapEncoder.encodeSingleValue("rank", "sessionId", sessionId.get(0), buffer);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RankProperties)) {
            return false;
        }
        return this.properties.equals(((RankProperties)other).properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public RankProperties clone() {
        LinkedHashMap<String, List<Object>> clone = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, List<Object>> entry : this.properties.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new RankProperties(clone);
    }

    public String toString() {
        return JSON.encode(this.properties);
    }
}

