/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.properties;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.search.query.ranking.MatchPhase;
import com.yahoo.search.query.ranking.Matching;
import com.yahoo.search.query.ranking.SoftTimeout;
import com.yahoo.tensor.Tensor;
import java.util.Map;

public class QueryProperties
extends Properties {
    private Query query;
    private final CompiledQueryProfileRegistry profileRegistry;

    public QueryProperties(Query query, CompiledQueryProfileRegistry profileRegistry) {
        this.query = query;
        this.profileRegistry = profileRegistry;
    }

    @Override
    public void setParentQuery(Query query) {
        this.query = query;
        super.setParentQuery(query);
    }

    public Object get(CompoundName key, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        if (key.size() == 2 && key.first().equals("model")) {
            Model model = this.query.getModel();
            if (key.last().equals("queryString")) {
                return model.getQueryString();
            }
            if (key.last().equals("type")) {
                return model.getType();
            }
            if (key.last().equals("filter")) {
                return model.getFilter();
            }
            if (key.last().equals("defaultIndex")) {
                return model.getDefaultIndex();
            }
            if (key.last().equals("language")) {
                return model.getLanguage();
            }
            if (key.last().equals("locale")) {
                return model.getLocale();
            }
            if (key.last().equals("encoding")) {
                return model.getEncoding();
            }
            if (key.last().equals("sources")) {
                return model.getSources();
            }
            if (key.last().equals("searchPath")) {
                return model.getSearchPath();
            }
            if (key.last().equals("restrict")) {
                return model.getRestrict();
            }
        } else if (key.first().equals("ranking")) {
            Ranking ranking = this.query.getRanking();
            if (key.size() == 2) {
                if (key.last().equals("location")) {
                    return ranking.getLocation();
                }
                if (key.last().equals("profile")) {
                    return ranking.getProfile();
                }
                if (key.last().equals("sorting")) {
                    return ranking.getSorting();
                }
                if (key.last().equals("freshness")) {
                    return ranking.getFreshness();
                }
                if (key.last().equals("queryCache")) {
                    return ranking.getQueryCache();
                }
                if (key.last().equals("listFeatures")) {
                    return ranking.getListFeatures();
                }
            } else if (key.size() >= 3 && key.get(1).equals("matchPhase")) {
                if (key.size() == 3) {
                    MatchPhase matchPhase = ranking.getMatchPhase();
                    if (key.last().equals("attribute")) {
                        return matchPhase.getAttribute();
                    }
                    if (key.last().equals("ascending")) {
                        return matchPhase.getAscending();
                    }
                    if (key.last().equals("maxHits")) {
                        return matchPhase.getMaxHits();
                    }
                    if (key.last().equals("maxFilterCoverage")) {
                        return matchPhase.getMaxFilterCoverage();
                    }
                } else if (key.size() >= 4 && key.get(2).equals("diversity")) {
                    Diversity diversity = ranking.getMatchPhase().getDiversity();
                    if (key.size() == 4) {
                        if (key.last().equals("attribute")) {
                            return diversity.getAttribute();
                        }
                        if (key.last().equals("minGroups")) {
                            return diversity.getMinGroups();
                        }
                    } else if (key.size() == 5 && key.get(3).equals("cutoff")) {
                        if (key.last().equals("factor")) {
                            return diversity.getCutoffFactor();
                        }
                        if (key.last().equals("strategy")) {
                            return diversity.getCutoffStrategy();
                        }
                    }
                }
            } else if (key.size() == 3 && key.get(1).equals("softtimeout")) {
                SoftTimeout soft = ranking.getSoftTimeout();
                if (key.last().equals("enable")) {
                    return soft.getEnable();
                }
                if (key.last().equals("factor")) {
                    return soft.getFactor();
                }
                if (key.last().equals("tailcost")) {
                    return soft.getTailcost();
                }
            } else if (key.size() == 3 && key.get(1).equals("matching")) {
                Matching matching = ranking.getMatching();
                if (key.last().equals("termwiselimit")) {
                    return matching.getTermwiseLimit();
                }
                if (key.last().equals("numthreadspersearch")) {
                    return matching.getNumThreadsPerSearch();
                }
                if (key.last().equals("numsearchpartitions")) {
                    return matching.getNumSearchPartitions();
                }
                if (key.last().equals("minhitsperthread")) {
                    return matching.getMinHitsPerThread();
                }
            } else if (key.size() > 2) {
                if (key.get(1).equals("features")) {
                    return ranking.getFeatures().getObject(key.rest().rest().toString());
                }
                if (key.get(1).equals("properties")) {
                    return ranking.getProperties().get(key.rest().rest().toString());
                }
            }
        } else if (key.first().equals("select")) {
            if (key.size() == 1) {
                return this.query.getSelect().getGroupingExpressionString();
            }
            if (key.size() == 2) {
                if (key.last().equals("where")) {
                    return this.query.getSelect().getWhereString();
                }
                if (key.last().equals("grouping")) {
                    return this.query.getSelect().getGroupingString();
                }
            }
        } else if (key.size() == 2 && key.first().equals("presentation")) {
            if (key.last().equals("bolding")) {
                return this.query.getPresentation().getBolding();
            }
            if (key.last().equals("summary")) {
                return this.query.getPresentation().getSummary();
            }
            if (key.last().equals("format")) {
                return this.query.getPresentation().getFormat();
            }
            if (key.last().equals("timing")) {
                return this.query.getPresentation().getTiming();
            }
            if (key.last().equals("summaryFields")) {
                return this.query.getPresentation().getSummaryFields();
            }
        } else {
            if (key.first().equals("rankfeature") || key.first().equals("featureoverride")) {
                return this.query.getRanking().getFeatures().getObject(key.rest().toString());
            }
            if (key.first().equals("rankproperty")) {
                return this.query.getRanking().getProperties().get(key.rest().toString());
            }
            if (key.size() == 1) {
                if (key.equals((Object)Query.HITS)) {
                    return this.query.getHits();
                }
                if (key.equals((Object)Query.OFFSET)) {
                    return this.query.getOffset();
                }
                if (key.equals((Object)Query.TRACE_LEVEL)) {
                    return this.query.getTraceLevel();
                }
                if (key.equals((Object)Query.EXPLAIN_LEVEL)) {
                    return this.query.getExplainLevel();
                }
                if (key.equals((Object)Query.TIMEOUT)) {
                    return this.query.getTimeout();
                }
                if (key.equals((Object)Query.NO_CACHE)) {
                    return this.query.getNoCache();
                }
                if (key.equals((Object)Query.GROUPING_SESSION_CACHE)) {
                    return this.query.getGroupingSessionCache();
                }
                if (key.toString().equals("model")) {
                    return this.query.getModel();
                }
                if (key.toString().equals("ranking")) {
                    return this.query.getRanking();
                }
                if (key.toString().equals("presentation")) {
                    return this.query.getPresentation();
                }
            }
        }
        return super.get(key, context, substitution);
    }

    public void set(CompoundName key, Object value, Map<String, String> context) {
        try {
            if (key.size() == 2 && key.first().equals("model")) {
                Model model = this.query.getModel();
                if (key.last().equals("queryString")) {
                    model.setQueryString(this.asString(value, ""));
                } else if (key.last().equals("type")) {
                    model.setType(this.asString(value, "ANY"));
                } else if (key.last().equals("filter")) {
                    model.setFilter(this.asString(value, ""));
                } else if (key.last().equals("defaultIndex")) {
                    model.setDefaultIndex(this.asString(value, ""));
                } else if (key.last().equals("language")) {
                    model.setLanguage(this.asString(value, ""));
                } else if (key.last().equals("locale")) {
                    model.setLocale(this.asString(value, ""));
                } else if (key.last().equals("encoding")) {
                    model.setEncoding(this.asString(value, ""));
                } else if (key.last().equals("searchPath")) {
                    model.setSearchPath(this.asString(value, ""));
                } else if (key.last().equals("sources")) {
                    model.setSources(this.asString(value, ""));
                } else if (key.last().equals("restrict")) {
                    model.setRestrict(this.asString(value, ""));
                } else {
                    this.throwIllegalParameter(key.last(), "model");
                }
            } else if (key.first().equals("ranking")) {
                Ranking ranking = this.query.getRanking();
                if (key.size() == 2) {
                    if (key.last().equals("location")) {
                        ranking.setLocation(this.asString(value, ""));
                    } else if (key.last().equals("profile")) {
                        ranking.setProfile(this.asString(value, ""));
                    } else if (key.last().equals("sorting")) {
                        ranking.setSorting(this.asString(value, ""));
                    } else if (key.last().equals("freshness")) {
                        ranking.setFreshness(this.asString(value, ""));
                    } else if (key.last().equals("queryCache")) {
                        ranking.setQueryCache(this.asBoolean(value, false));
                    } else if (key.last().equals("listFeatures")) {
                        ranking.setListFeatures(this.asBoolean(value, false));
                    } else {
                        this.throwIllegalParameter(key.last(), "ranking");
                    }
                } else if (key.size() >= 3 && key.get(1).equals("matchPhase")) {
                    if (key.size() == 3) {
                        MatchPhase matchPhase = ranking.getMatchPhase();
                        if (key.last().equals("attribute")) {
                            matchPhase.setAttribute(this.asString(value, null));
                        } else if (key.last().equals("ascending")) {
                            matchPhase.setAscending(this.asBoolean(value, false));
                        } else if (key.last().equals("maxHits")) {
                            matchPhase.setMaxHits(this.asLong(value, null));
                        } else if (key.last().equals("maxFilterCoverage")) {
                            matchPhase.setMaxFilterCoverage(this.asDouble(value, 0.2));
                        } else {
                            this.throwIllegalParameter(key.rest().toString(), "matchPhase");
                        }
                    } else if (key.size() > 3 && key.get(2).equals("diversity")) {
                        Diversity diversity = ranking.getMatchPhase().getDiversity();
                        if (key.last().equals("attribute")) {
                            diversity.setAttribute(this.asString(value, null));
                        } else if (key.last().equals("minGroups")) {
                            diversity.setMinGroups(this.asLong(value, null));
                        } else if (key.size() > 4 && key.get(3).equals("cutoff")) {
                            if (key.last().equals("factor")) {
                                diversity.setCutoffFactor(this.asDouble(value, 10.0));
                            } else if (key.last().equals("strategy")) {
                                diversity.setCutoffStrategy(this.asString(value, "loose"));
                            } else {
                                this.throwIllegalParameter(key.rest().toString(), "cutoff");
                            }
                        } else {
                            this.throwIllegalParameter(key.rest().toString(), "diversity");
                        }
                    }
                } else if (key.size() == 3 && key.get(1).equals("softtimeout")) {
                    SoftTimeout soft = ranking.getSoftTimeout();
                    if (key.last().equals("enable")) {
                        soft.setEnable(this.asBoolean(value, true));
                    } else if (key.last().equals("factor")) {
                        soft.setFactor(this.asDouble(value, null));
                    } else if (key.last().equals("tailcost")) {
                        soft.setTailcost(this.asDouble(value, null));
                    } else {
                        this.throwIllegalParameter(key.rest().toString(), "softtimeout");
                    }
                } else if (key.size() == 3 && key.get(1).equals("matching")) {
                    Matching matching = ranking.getMatching();
                    if (key.last().equals("termwiselimit")) {
                        matching.setTermwiselimit(this.asDouble(value, 1.0));
                    } else if (key.last().equals("numthreadspersearch")) {
                        matching.setNumThreadsPerSearch(this.asInteger(value, 1));
                    } else if (key.last().equals("numsearchpartitions")) {
                        matching.setNumSearchPartitions(this.asInteger(value, 1));
                    } else if (key.last().equals("minhitsperthread")) {
                        matching.setMinHitsPerThread(this.asInteger(value, 0));
                    } else {
                        this.throwIllegalParameter(key.rest().toString(), "matching");
                    }
                } else if (key.size() > 2) {
                    String restKey = key.rest().rest().toString();
                    if (key.get(1).equals("features")) {
                        this.setRankingFeature(this.query, restKey, this.toSpecifiedType(restKey, value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("features"))));
                    } else if (key.get(1).equals("properties")) {
                        ranking.getProperties().put(restKey, this.toSpecifiedType(restKey, value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("properties"))));
                    } else {
                        this.throwIllegalParameter(key.rest().toString(), "ranking");
                    }
                }
            } else if (key.size() == 2 && key.first().equals("presentation")) {
                if (key.last().equals("bolding")) {
                    this.query.getPresentation().setBolding(this.asBoolean(value, true));
                } else if (key.last().equals("summary")) {
                    this.query.getPresentation().setSummary(this.asString(value, ""));
                } else if (key.last().equals("format")) {
                    this.query.getPresentation().setFormat(this.asString(value, ""));
                } else if (key.last().equals("timing")) {
                    this.query.getPresentation().setTiming(this.asBoolean(value, true));
                } else if (key.last().equals("summaryFields")) {
                    this.query.getPresentation().setSummaryFields(this.asString(value, ""));
                } else {
                    this.throwIllegalParameter(key.last(), "presentation");
                }
            } else if (key.first().equals("select")) {
                if (key.size() == 1) {
                    this.query.getSelect().setGroupingExpressionString(this.asString(value, ""));
                } else if (key.size() == 2) {
                    if (key.last().equals("where")) {
                        this.query.getSelect().setWhereString(this.asString(value, ""));
                    } else if (key.last().equals("grouping")) {
                        this.query.getSelect().setGroupingString(this.asString(value, ""));
                    } else {
                        this.throwIllegalParameter(key.rest().toString(), "select");
                    }
                } else {
                    this.throwIllegalParameter(key.last(), "select");
                }
            } else if (key.first().equals("rankfeature") || key.first().equals("featureoverride")) {
                this.setRankingFeature(this.query, key.rest().toString(), this.toSpecifiedType(key.rest().toString(), value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("features"))));
            } else if (key.first().equals("rankproperty")) {
                this.query.getRanking().getProperties().put(key.rest().toString(), this.toSpecifiedType(key.rest().toString(), value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("properties"))));
            } else if (key.size() == 1) {
                if (key.equals((Object)Query.HITS)) {
                    this.query.setHits(this.asInteger(value, 10));
                } else if (key.equals((Object)Query.OFFSET)) {
                    this.query.setOffset(this.asInteger(value, 0));
                } else if (key.equals((Object)Query.TRACE_LEVEL)) {
                    this.query.setTraceLevel(this.asInteger(value, 0));
                } else if (key.equals((Object)Query.EXPLAIN_LEVEL)) {
                    this.query.setExplainLevel(this.asInteger(value, 0));
                } else if (key.equals((Object)Query.TIMEOUT)) {
                    this.query.setTimeout(value.toString());
                } else if (key.equals((Object)Query.NO_CACHE)) {
                    this.query.setNoCache(this.asBoolean(value, false));
                } else if (key.equals((Object)Query.GROUPING_SESSION_CACHE)) {
                    this.query.setGroupingSessionCache(this.asBoolean(value, true));
                } else {
                    super.set(key, value, context);
                }
            } else {
                super.set(key, value, context);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Could not set")) {
                throw e;
            }
            throw new IllegalArgumentException("Could not set '" + key + "' to '" + value + "'", e);
        }
    }

    public Map<String, Object> listProperties(CompoundName prefix, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        Map properties = super.listProperties(prefix, context, substitution);
        for (CompoundName queryProperty : Query.nativeProperties) {
            Object value;
            if (!queryProperty.hasPrefix(prefix) || (value = this.get(queryProperty, context, substitution)) == null) continue;
            properties.put(queryProperty.toString(), value);
        }
        return properties;
    }

    private void setRankingFeature(Query query, String key, Object value) {
        if (value instanceof Tensor) {
            query.getRanking().getFeatures().put(key, (Tensor)value);
        } else if (value instanceof Double) {
            query.getRanking().getFeatures().put(key, (Double)value);
        } else {
            String valueString = this.asString(value, "");
            try {
                query.getRanking().getFeatures().put(key, Double.parseDouble(valueString));
            }
            catch (IllegalArgumentException e) {
                query.getRanking().getFeatures().put(key, valueString);
            }
        }
    }

    private Object toSpecifiedType(String key, Object value, QueryProfileType type) {
        if (!(value instanceof String)) {
            return value;
        }
        if (type == null) {
            return value;
        }
        FieldDescription field = type.getField(key);
        if (field == null) {
            return value;
        }
        return field.getType().convertFrom(value, this.profileRegistry);
    }

    private void throwIllegalParameter(String key, String namespace) {
        throw new IllegalArgumentException("'" + key + "' is not a valid property in '" + namespace + "'. See the query api for valid keys starting by '" + namespace + "'.");
    }

    @Override
    public final Query getParentQuery() {
        return this.query;
    }
}

