/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.config;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.text.XML;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class QueryProfileXMLReader {
    public QueryProfileRegistry read(String directory) {
        ArrayList<NamedReader> queryProfileReaders = new ArrayList<NamedReader>();
        ArrayList<NamedReader> queryProfileTypeReaders = new ArrayList<NamedReader>();
        try {
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Could not read query profiles: '" + directory + "' is not a valid directory.");
            }
            for (File file : this.sortFiles(dir)) {
                if (!file.getName().endsWith(".xml")) continue;
                queryProfileReaders.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
            }
            File typeDir = new File(dir, "types");
            if (typeDir.isDirectory()) {
                for (File file : this.sortFiles(typeDir)) {
                    if (!file.getName().endsWith(".xml")) continue;
                    queryProfileTypeReaders.add(new NamedReader(file.getName(), (Reader)new FileReader(file)));
                }
            }
            QueryProfileRegistry queryProfileRegistry = this.read(queryProfileTypeReaders, queryProfileReaders);
            return queryProfileRegistry;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read query profiles from '" + directory + "'", e);
        }
        finally {
            this.closeAll(queryProfileReaders);
            this.closeAll(queryProfileTypeReaders);
        }
    }

    private List<File> sortFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(dir.listFiles()));
        Collections.sort(files);
        return files;
    }

    private void closeAll(List<NamedReader> readers) {
        for (NamedReader reader : readers) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public QueryProfileRegistry read(List<NamedReader> queryProfileTypeReaders, List<NamedReader> queryProfileReaders) {
        QueryProfileRegistry registry = new QueryProfileRegistry();
        List<Element> queryProfileTypeElements = this.createQueryProfileTypes(queryProfileTypeReaders, registry.getTypeRegistry());
        List<Element> queryProfileElements = this.createQueryProfiles(queryProfileReaders, registry);
        this.fillQueryProfileTypes(queryProfileTypeElements, registry.getTypeRegistry());
        this.fillQueryProfiles(queryProfileElements, registry);
        return registry;
    }

    public List<Element> createQueryProfileTypes(List<NamedReader> queryProfileTypeReaders, QueryProfileTypeRegistry registry) {
        ArrayList<Element> queryProfileTypeElements = new ArrayList<Element>(queryProfileTypeReaders.size());
        for (NamedReader reader : queryProfileTypeReaders) {
            Element root = XML.getDocument((Reader)reader).getDocumentElement();
            if (!root.getNodeName().equals("query-profile-type")) {
                throw new IllegalArgumentException("Root tag in '" + reader.getName() + "' must be 'query-profile-type', not '" + root.getNodeName() + "'");
            }
            String idString = root.getAttribute("id");
            if (idString == null || idString.equals("")) {
                throw new IllegalArgumentException("'" + reader.getName() + "' has no 'id' attribute in the root element");
            }
            ComponentId id = new ComponentId(idString);
            this.validateFileNameToId(reader.getName(), id, "query profile type");
            QueryProfileType type = new QueryProfileType(id);
            type.setMatchAsPath(XML.getChild((Element)root, (String)"match") != null);
            type.setStrict(XML.getChild((Element)root, (String)"strict") != null);
            registry.register(type);
            queryProfileTypeElements.add(root);
        }
        return queryProfileTypeElements;
    }

    public List<Element> createQueryProfiles(List<NamedReader> queryProfileReaders, QueryProfileRegistry registry) {
        ArrayList<Element> queryProfileElements = new ArrayList<Element>(queryProfileReaders.size());
        for (NamedReader reader : queryProfileReaders) {
            Element dimensions;
            Element root = XML.getDocument((Reader)reader).getDocumentElement();
            if (!root.getNodeName().equals("query-profile")) {
                throw new IllegalArgumentException("Root tag in '" + reader.getName() + "' must be 'query-profile', not '" + root.getNodeName() + "'");
            }
            String idString = root.getAttribute("id");
            if (idString == null || idString.equals("")) {
                throw new IllegalArgumentException("Query profile '" + reader.getName() + "' has no 'id' attribute in the root element");
            }
            ComponentId id = new ComponentId(idString);
            this.validateFileNameToId(reader.getName(), id, "query profile");
            QueryProfile queryProfile = new QueryProfile(id, reader.getName());
            String typeId = root.getAttribute("type");
            if (typeId != null && !typeId.equals("")) {
                QueryProfileType type = registry.getType(typeId);
                if (type == null) {
                    throw new IllegalArgumentException("Query profile '" + reader.getName() + "': Type id '" + typeId + "' can not be resolved");
                }
                queryProfile.setType(type);
            }
            if ((dimensions = XML.getChild((Element)root, (String)"dimensions")) != null) {
                queryProfile.setDimensions(this.toArray(XML.getValue((Element)dimensions)));
            }
            registry.register(queryProfile);
            queryProfileElements.add(root);
        }
        return queryProfileElements;
    }

    private void validateFileNameToId(String actualName, ComponentId id, String artifactName) {
        String expectedCanonicalFileName = id.toFileName();
        String expectedAlternativeFileName = id.stringValue().replace(":", "-").replace("/", "_");
        String fileName = new File(actualName).getName();
        String canonicalFileName = ComponentId.fromFileName((String)(fileName = this.stripXmlEnding(fileName))).toFileName();
        if (!canonicalFileName.equals(expectedCanonicalFileName) && !canonicalFileName.equals(expectedAlternativeFileName)) {
            throw new IllegalArgumentException("The file name of " + artifactName + " '" + id + "' must be '" + expectedCanonicalFileName + ".xml' but was '" + actualName + "'");
        }
    }

    private String stripXmlEnding(String fileName) {
        if (!fileName.endsWith(".xml")) {
            throw new IllegalArgumentException("'" + fileName + "' should have a .xml ending");
        }
        return fileName.substring(0, fileName.length() - 4);
    }

    private String[] toArray(String csv) {
        String[] array = csv.split(",");
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    public void fillQueryProfileTypes(List<Element> queryProfileTypeElements, QueryProfileTypeRegistry registry) {
        for (Element element : queryProfileTypeElements) {
            QueryProfileType type = (QueryProfileType)((Object)registry.getComponent(new ComponentSpecification(element.getAttribute("id")).toId()));
            try {
                this.readInheritedTypes(element, type, registry);
                this.readFieldDefinitions(element, type, registry);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error reading " + type, e);
            }
        }
    }

    private void readInheritedTypes(Element element, QueryProfileType type, QueryProfileTypeRegistry registry) {
        String inheritedString = element.getAttribute("inherits");
        if (inheritedString == null || inheritedString.equals("")) {
            return;
        }
        for (String inheritedId : inheritedString.split(" ")) {
            if ((inheritedId = inheritedId.trim()).equals("")) continue;
            QueryProfileType inheritedType = (QueryProfileType)((Object)registry.getComponent(inheritedId));
            if (inheritedType == null) {
                throw new IllegalArgumentException("Could not resolve inherited query profile type '" + inheritedId);
            }
            type.inherited().add(inheritedType);
        }
    }

    private void readFieldDefinitions(Element element, QueryProfileType type, QueryProfileTypeRegistry registry) {
        for (Element field : XML.getChildren((Element)element, (String)"field")) {
            String name = field.getAttribute("name");
            if (name == null || name.equals("")) {
                throw new IllegalArgumentException("A field has no 'name' attribute");
            }
            try {
                String fieldTypeName = field.getAttribute("type");
                if (fieldTypeName == null) {
                    throw new IllegalArgumentException("Field '" + field + "' has no 'type' attribute");
                }
                FieldType fieldType = FieldType.fromString(fieldTypeName, registry);
                type.addField(new FieldDescription(name, fieldType, field.getAttribute("alias"), (boolean)this.getBooleanAttribute("mandatory", false, field), (boolean)this.getBooleanAttribute("overridable", true, field)), registry);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid field '" + name + "'", e);
            }
        }
    }

    public void fillQueryProfiles(List<Element> queryProfileElements, QueryProfileRegistry registry) {
        for (Element element : queryProfileElements) {
            QueryProfile profile = (QueryProfile)registry.getComponent(new ComponentSpecification(element.getAttribute("id")).toId());
            try {
                this.readInherited(element, profile, registry, null, profile.toString());
                this.readFields(element, profile, registry, null, profile.toString());
                this.readVariants(element, profile, registry);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error reading " + profile, e);
            }
        }
    }

    private void readInherited(Element element, QueryProfile profile, QueryProfileRegistry registry, DimensionValues dimensionValues, String sourceDescription) {
        String inheritedString = element.getAttribute("inherits");
        if (inheritedString == null || inheritedString.equals("")) {
            return;
        }
        for (String inheritedId : inheritedString.split(" ")) {
            if ((inheritedId = inheritedId.trim()).equals("")) continue;
            QueryProfile inheritedProfile = (QueryProfile)registry.getComponent(inheritedId);
            if (inheritedProfile == null) {
                throw new IllegalArgumentException("Could not resolve inherited query profile '" + inheritedId + "' in " + sourceDescription);
            }
            profile.addInherited(inheritedProfile, dimensionValues);
        }
    }

    private void readFields(Element element, QueryProfile profile, QueryProfileRegistry registry, DimensionValues dimensionValues, String sourceDescription) {
        ArrayList<KeyValue> references = new ArrayList<KeyValue>();
        ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
        for (Element field : XML.getChildren((Element)element, (String)"field")) {
            String name = field.getAttribute("name");
            if (name == null || name.equals("")) {
                throw new IllegalArgumentException("A field in " + sourceDescription + " has no 'name' attribute");
            }
            try {
                Object fieldValue;
                Boolean overridable = this.getBooleanAttribute("overridable", null, field);
                if (overridable != null) {
                    profile.setOverridable(name, (boolean)overridable, null);
                }
                if ((fieldValue = this.readFieldValue(field, name, sourceDescription, registry)) instanceof QueryProfile) {
                    references.add(new KeyValue(name, fieldValue));
                    continue;
                }
                properties.add(new KeyValue(name, fieldValue));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid field '" + name + "' in " + sourceDescription, e);
            }
        }
        for (KeyValue keyValue : references) {
            profile.set(keyValue.getKey(), keyValue.getValue(), dimensionValues, registry);
        }
        for (KeyValue keyValue : properties) {
            profile.set(keyValue.getKey(), keyValue.getValue(), dimensionValues, registry);
        }
    }

    private Object readFieldValue(Element field, String name, String targetDescription, QueryProfileRegistry registry) {
        Element ref = XML.getChild((Element)field, (String)"ref");
        if (ref != null) {
            String referencedName = XML.getValue((Element)ref);
            QueryProfile referenced = (QueryProfile)registry.getComponent(referencedName);
            if (referenced == null) {
                throw new IllegalArgumentException("Could not find query profile '" + referencedName + "' referenced as '" + name + "' in " + targetDescription);
            }
            return referenced;
        }
        return XML.getValue((Element)field);
    }

    private void readVariants(Element element, QueryProfile profile, QueryProfileRegistry registry) {
        for (Element queryProfileVariantElement : XML.getChildren((Element)element, (String)"query-profile")) {
            List<String> dimensions = profile.getDimensions();
            if (dimensions == null) {
                throw new IllegalArgumentException("Cannot create a query profile variant in " + profile + ", as it has not declared any variable dimensions");
            }
            String dimensionString = queryProfileVariantElement.getAttribute("for");
            String[] dimensionValueArray = this.makeStarsNull(this.toArray(dimensionString));
            if (dimensions.size() < dimensionValueArray.length) {
                throw new IllegalArgumentException("Cannot create a query profile variant for '" + dimensionString + "' as only " + dimensions.size() + " dimensions has been defined");
            }
            DimensionValues dimensionValues = DimensionValues.createFrom(dimensionValueArray);
            String description = "variant '" + dimensionString + "' in " + profile.toString();
            this.readInherited(queryProfileVariantElement, profile, registry, dimensionValues, description);
            this.readFields(queryProfileVariantElement, profile, registry, dimensionValues, description);
        }
    }

    private String[] makeStarsNull(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals("*")) continue;
            strings[i] = null;
        }
        return strings;
    }

    private Boolean asBoolean(String s, Boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if (s.isEmpty()) {
            return defaultValue;
        }
        if ("true".equals(s)) {
            return true;
        }
        if ("false".equals(s)) {
            return false;
        }
        throw new IllegalArgumentException("Expected 'true' or 'false' but was'" + s + "'");
    }

    private Boolean getBooleanAttribute(String attributeName, Boolean defaultValue, Element from) {
        try {
            return this.asBoolean(from.getAttribute(attributeName), defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Attribute '" + attributeName, e);
        }
    }

    private static class KeyValue {
        private String key;
        private Object value;

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

