/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.query.profile.DimensionValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DimensionBinding {
    private List<String> dimensions;
    private DimensionValues values;
    private Map<String, String> context;
    public static final DimensionBinding nullBinding = new DimensionBinding(Collections.unmodifiableList(Collections.emptyList()), DimensionValues.empty, null);
    public static final DimensionBinding invalidBinding = new DimensionBinding(Collections.unmodifiableList(Collections.emptyList()), DimensionValues.empty, null);
    private boolean containsAllNulls;

    public static DimensionBinding createFrom(Map<String, String> values) {
        return DimensionBinding.createFrom(new ArrayList<String>(values.keySet()), values);
    }

    public static DimensionBinding createFrom(List<String> dimensions, Map<String, String> context) {
        if (dimensions == null || dimensions.size() == 0) {
            if (context == null) {
                return nullBinding;
            }
            if (dimensions == null) {
                return new DimensionBinding(null, DimensionValues.empty, context);
            }
        }
        return new DimensionBinding(dimensions, DimensionBinding.extractDimensionValues(dimensions, context), context);
    }

    public static DimensionBinding createFrom(List<String> dimensions, DimensionValues dimensionValues) {
        if (dimensionValues == null || dimensionValues == DimensionValues.empty) {
            return nullBinding;
        }
        if (dimensions == null) {
            return new DimensionBinding(null, dimensionValues, null);
        }
        return new DimensionBinding(dimensions, dimensionValues, null);
    }

    public DimensionBinding createFor(List<String> newDimensions) {
        if (newDimensions == null) {
            return this;
        }
        if (this.dimensions == newDimensions) {
            return this;
        }
        Map<String, String> context = this.context;
        if (context == null) {
            context = this.values.asContext(this.dimensions != null ? this.dimensions : newDimensions);
        }
        return new DimensionBinding(newDimensions, DimensionBinding.extractDimensionValues(newDimensions, context), context);
    }

    private DimensionBinding(List<String> dimensions, DimensionValues values, Map<String, String> context) {
        this.dimensions = dimensions;
        this.values = values;
        this.context = context;
        this.containsAllNulls = values.isEmpty();
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public Map<String, String> getContext() {
        if (this.context != null) {
            return this.context;
        }
        this.context = this.values.asContext(this.dimensions);
        return this.context;
    }

    public DimensionValues getValues() {
        return this.values;
    }

    public boolean isNull() {
        return this.dimensions == null || this.containsAllNulls;
    }

    private static DimensionValues extractDimensionValues(List<String> dimensions, Map<String, String> context) {
        String[] dimensionValues = new String[dimensions.size()];
        if (context == null || context.size() == 0) {
            return DimensionValues.createFrom(dimensionValues);
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensionValues[i] = context.get(dimensions.get(i));
        }
        return DimensionValues.createFrom(dimensionValues);
    }

    public DimensionBinding combineWith(DimensionBinding binding) {
        List<String> combinedDimensions = this.combineDimensions(this.getDimensions(), binding.getDimensions());
        if (combinedDimensions == null) {
            return invalidBinding;
        }
        Map<String, String> combinedValues = this.combineValues(this.getContext(), binding.getContext());
        if (combinedValues == null) {
            return invalidBinding;
        }
        return DimensionBinding.createFrom(combinedDimensions, combinedValues);
    }

    private List<String> combineDimensions(List<String> d1, List<String> d2) {
        if (d1.equals(d2)) {
            return d1;
        }
        if (d1.isEmpty()) {
            return d2;
        }
        if (d2.isEmpty()) {
            return d1;
        }
        ArrayList<String> combined = new ArrayList<String>();
        int d1Index = 0;
        int d2Index = 0;
        while (d1Index < d1.size() && d2Index < d2.size()) {
            if (d1.get(d1Index).equals(d2.get(d2Index))) {
                combined.add(d1.get(d1Index));
                ++d1Index;
                ++d2Index;
                continue;
            }
            if (!d2.contains(d1.get(d1Index))) {
                combined.add(d1.get(d1Index++));
                continue;
            }
            if (!d1.contains(d2.get(d2Index))) {
                combined.add(d2.get(d2Index++));
                continue;
            }
            return null;
        }
        if (d1Index < d1.size()) {
            combined.addAll(d1.subList(d1Index, d1.size()));
        } else if (d2Index < d2.size()) {
            combined.addAll(d2.subList(d2Index, d2.size()));
        }
        return combined;
    }

    private Map<String, String> combineValues(Map<String, String> m1, Map<String, String> m2) {
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        LinkedHashMap<String, String> combinedValues = null;
        for (Map.Entry<String, String> m2Entry : m2.entrySet()) {
            if (m2Entry.getValue() == null) continue;
            String m1Value = m1.get(m2Entry.getKey());
            if (m1Value != null && !m1Value.equals(m2Entry.getValue())) {
                return null;
            }
            if (combinedValues == null) {
                combinedValues = new LinkedHashMap<String, String>(m1);
            }
            combinedValues.put(m2Entry.getKey(), m2Entry.getValue());
        }
        return combinedValues == null ? m1 : combinedValues;
    }

    public boolean isInvalid() {
        return this == invalidBinding;
    }

    public String toString() {
        if (this.isInvalid()) {
            return "Invalid DimensionBinding";
        }
        if (this.dimensions == null) {
            return "DimensionBinding []";
        }
        StringBuilder b = new StringBuilder("DimensionBinding [");
        for (int i = 0; i < this.dimensions.size(); ++i) {
            b.append(this.dimensions.get(i)).append("=").append(this.values.get(i));
            if (i >= this.dimensions.size() - 1) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionBinding)) {
            return false;
        }
        DimensionBinding other = (DimensionBinding)o;
        if (!this.dimensions.equals(other.dimensions)) {
            return false;
        }
        return this.values.equals(other.values);
    }

    public int hashCode() {
        return this.dimensions.hashCode() + 17 * this.values.hashCode();
    }
}

