/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.parser;

import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.parser.SpecialTokens;
import com.yahoo.search.searchchain.Execution;

public final class ParserEnvironment {
    private IndexFacts indexFacts = new IndexFacts();
    private Linguistics linguistics = new SimpleLinguistics();
    private SpecialTokens specialTokens = new SpecialTokens();

    public IndexFacts getIndexFacts() {
        return this.indexFacts;
    }

    public ParserEnvironment setIndexFacts(IndexFacts indexFacts) {
        this.indexFacts = indexFacts;
        return this;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    public ParserEnvironment setLinguistics(Linguistics linguistics) {
        this.linguistics = linguistics;
        return this;
    }

    public SpecialTokens getSpecialTokens() {
        return this.specialTokens;
    }

    public ParserEnvironment setSpecialTokens(SpecialTokens specialTokens) {
        this.specialTokens = specialTokens;
        return this;
    }

    public static ParserEnvironment fromExecutionContext(Execution.Context context) {
        ParserEnvironment env = new ParserEnvironment();
        if (context == null) {
            return env;
        }
        if (context.getIndexFacts() != null) {
            env.setIndexFacts(context.getIndexFacts());
        }
        if (context.getLinguistics() != null) {
            env.setLinguistics(context.getLinguistics());
        }
        if (context.getTokenRegistry() != null) {
            env.setSpecialTokens(context.getTokenRegistry().getSpecialTokens("default"));
        }
        return env;
    }

    public static ParserEnvironment fromParserEnvironment(ParserEnvironment environment) {
        return new ParserEnvironment().setIndexFacts(environment.indexFacts).setLinguistics(environment.linguistics).setSpecialTokens(environment.specialTokens);
    }
}

