/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.net.URI;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.result.RootId;
import com.yahoo.search.query.Select;
import com.yahoo.search.result.Hit;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class GroupingRequest {
    private final Select parent;
    private final List<Continuation> continuations = new ArrayList<Continuation>();
    private GroupingOperation root;
    private TimeZone timeZone;

    private GroupingRequest(Select parent) {
        this.parent = parent;
    }

    private GroupingRequest(Select parent, List<Continuation> continuations, GroupingOperation root, TimeZone timeZone) {
        this.parent = parent;
        continuations.forEach(item -> this.continuations.add(item.copy()));
        this.root = root != null ? root.copy(null) : null;
        this.timeZone = timeZone;
    }

    public GroupingRequest copy(Select parentOfCopy) {
        return new GroupingRequest(parentOfCopy, this.continuations, this.root, this.timeZone);
    }

    public int getRequestId() {
        return this.parent.getGrouping().indexOf(this);
    }

    public GroupingOperation getRootOperation() {
        return this.root;
    }

    public GroupingRequest setRootOperation(GroupingOperation root) {
        this.root = root;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public GroupingRequest setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RootGroup getResultGroup(Result result) {
        Hit root = result.hits().get(new URI(new RootId(this.getRequestId()).toString()), -1);
        if (!(root instanceof RootGroup)) {
            return null;
        }
        return (RootGroup)root;
    }

    public List<Continuation> continuations() {
        return this.continuations;
    }

    public static GroupingRequest newInstance(Query query) {
        GroupingRequest newRequest = new GroupingRequest(query.getSelect());
        query.getSelect().getGrouping().add(newRequest);
        return newRequest;
    }

    public String toString() {
        return this.root == null ? "(empty)" : this.root.toString();
    }
}

