/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.statistics;

import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.container.protect.Error;
import com.yahoo.jdisc.Metric;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.MetricSettings;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

@Before(value={"rawQuery"})
public class StatisticsSearcher
extends Searcher {
    private static final CompoundName IGNORE_QUERY = new CompoundName("metrics.ignore");
    private static final String MAX_QUERY_LATENCY_METRIC = "max_query_latency";
    private static final String EMPTY_RESULTS_METRIC = "empty_results";
    private static final String HITS_PER_QUERY_METRIC = "hits_per_query";
    private static final String TOTALHITS_PER_QUERY_METRIC = "totalhits_per_query";
    private static final String FAILED_QUERIES_METRIC = "failed_queries";
    private static final String MEAN_QUERY_LATENCY_METRIC = "mean_query_latency";
    private static final String QUERY_LATENCY_METRIC = "query_latency";
    private static final String QUERY_OFFSET_METRIC = "query_hit_offset";
    private static final String QUERIES_METRIC = "queries";
    private static final String ACTIVE_QUERIES_METRIC = "active_queries";
    private static final String PEAK_QPS_METRIC = "peak_qps";
    private static final String DOCS_COVERED_METRIC = "documents_covered";
    private static final String DOCS_TOTAL_METRIC = "documents_total";
    private static final String DEGRADED_METRIC = "degraded_queries";
    private static final String RELEVANCE_AT_1_METRIC = "relevance.at_1";
    private static final String RELEVANCE_AT_3_METRIC = "relevance.at_3";
    private static final String RELEVANCE_AT_10_METRIC = "relevance.at_10";
    private final Counter queries;
    private final Counter failedQueries;
    private final Counter nullQueries;
    private final Counter illegalQueries;
    private final Value queryLatency;
    private final Value queryLatencyBuckets;
    private final Value maxQueryLatency;
    private final Value peakQPS;
    private final Counter emptyResults;
    private final Value hitsPerQuery;
    private final PeakQpsReporter peakQpsReporter;
    private Metric metric;
    private Map<String, Metric.Context> chainContexts = new CopyOnWriteHashMap();
    private Map<String, Metric.Context> statePageOnlyContexts = new CopyOnWriteHashMap();
    private Map<String, Map<DegradedReason, Metric.Context>> degradedReasonContexts = new CopyOnWriteHashMap();
    private Map<String, Map<String, Metric.Context>> relevanceContexts = new CopyOnWriteHashMap();
    private Timer scheduler = new Timer(true);

    public StatisticsSearcher(Statistics manager, Metric metric, MetricReceiver metricReceiver) {
        this.peakQpsReporter = new PeakQpsReporter();
        this.metric = metric;
        this.queries = new Counter(QUERIES_METRIC, manager, false);
        this.failedQueries = new Counter(FAILED_QUERIES_METRIC, manager, false);
        this.nullQueries = new Counter("null_queries", manager, false);
        this.illegalQueries = new Counter("illegal_queries", manager, false);
        this.queryLatency = new Value(MEAN_QUERY_LATENCY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.maxQueryLatency = new Value(MAX_QUERY_LATENCY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMax(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.queryLatencyBuckets = Value.buildValue((String)QUERY_LATENCY_METRIC, (Statistics)manager, null);
        this.peakQPS = new Value(PEAK_QPS_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMax(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.hitsPerQuery = new Value(HITS_PER_QUERY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.emptyResults = new Counter(EMPTY_RESULTS_METRIC, manager, false);
        metricReceiver.declareGauge(QUERY_LATENCY_METRIC, Optional.empty(), new MetricSettings.Builder().histogram(true).build());
        this.scheduler.schedule((TimerTask)this.peakQpsReporter, 1000L, 1000L);
    }

    public void deconstruct() {
        this.scheduler.cancel();
    }

    private void qps(Metric.Context metricContext) {
        this.peakQpsReporter.setContext(metricContext);
        this.peakQpsReporter.countQuery();
    }

    private Metric.Context getChainMetricContext(String chainName) {
        Metric.Context context = this.chainContexts.get(chainName);
        if (context == null) {
            HashMap<String, String> dimensions = new HashMap<String, String>();
            dimensions.put("chain", chainName);
            context = this.metric.createContext(dimensions);
            this.chainContexts.put(chainName, context);
        }
        return context;
    }

    private Metric.Context getDegradedMetricContext(String chainName, Coverage coverage) {
        Map<DegradedReason, Metric.Context> reasons = this.degradedReasonContexts.get(chainName);
        if (reasons == null) {
            reasons = new HashMap<DegradedReason, Metric.Context>(4);
            for (DegradedReason reason : DegradedReason.values()) {
                HashMap<String, String> dimensions = new HashMap<String, String>();
                dimensions.put("chain", chainName);
                dimensions.put("reason", reason.toString());
                Metric.Context context = this.metric.createContext(dimensions);
                reasons.put(reason, context);
            }
            this.degradedReasonContexts.put(chainName, reasons);
        }
        return reasons.get((Object)this.getMostImportantDegradeReason(coverage));
    }

    private DegradedReason getMostImportantDegradeReason(Coverage coverage) {
        if (coverage.isDegradedByMatchPhase()) {
            return DegradedReason.match_phase;
        }
        if (coverage.isDegradedByTimeout()) {
            return DegradedReason.timeout;
        }
        if (coverage.isDegradedByAdapativeTimeout()) {
            return DegradedReason.adaptive_timeout;
        }
        return DegradedReason.non_ideal_state;
    }

    private Metric.Context createRelevanceMetricContext(String chainName, String rankProfile) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("chain", chainName);
        dimensions.put("rankProfile", rankProfile);
        return this.metric.createContext(dimensions);
    }

    private Metric.Context getRelevanceMetricContext(Execution execution, Query query) {
        Metric.Context metricContext;
        String chain = execution.chain().getId().stringValue();
        String rankProfile = query.getRanking().getProfile();
        CopyOnWriteHashMap chainContext = this.relevanceContexts.get(chain);
        if (chainContext == null) {
            chainContext = new CopyOnWriteHashMap();
            this.relevanceContexts.put(chain, (Map<String, Metric.Context>)chainContext);
        }
        if ((metricContext = chainContext.get(rankProfile)) == null) {
            metricContext = this.createRelevanceMetricContext(chain, rankProfile);
            chainContext.put(rankProfile, metricContext);
        }
        return metricContext;
    }

    @Override
    public Result search(Query query, Execution execution) {
        Coverage queryCoverage;
        Result result;
        if (query.properties().getBoolean(IGNORE_QUERY, false)) {
            return execution.search(query);
        }
        Metric.Context metricContext = this.getChainMetricContext(execution.chain().getId().stringValue());
        this.incrQueryCount(metricContext);
        this.logQuery(query);
        long start = System.currentTimeMillis();
        this.qps(metricContext);
        try {
            result = execution.search(query);
        }
        catch (Exception e) {
            this.incrErrorCount(null, metricContext);
            throw e;
        }
        long end = System.currentTimeMillis();
        long latency = end - start;
        if (latency >= 0L) {
            this.addLatency(latency, metricContext);
        } else {
            this.getLogger().log(Level.WARNING, "Apparently negative latency measure, start: " + start + ", end: " + end + ", for query: " + query.toString());
        }
        if (result.hits().getError() != null) {
            this.incrErrorCount(result, metricContext);
            this.incrementStatePageOnlyErrors(result);
        }
        if ((queryCoverage = result.getCoverage(false)) != null) {
            if (queryCoverage.isDegraded()) {
                Metric.Context degradedContext = this.getDegradedMetricContext(execution.chain().getId().stringValue(), queryCoverage);
                this.metric.add(DEGRADED_METRIC, (Number)1, degradedContext);
            }
            this.metric.add(DOCS_COVERED_METRIC, (Number)queryCoverage.getDocs(), metricContext);
            this.metric.add(DOCS_TOTAL_METRIC, (Number)queryCoverage.getActive(), metricContext);
        }
        int hitCount = result.getConcreteHitCount();
        this.hitsPerQuery.put((double)hitCount);
        this.metric.set(HITS_PER_QUERY_METRIC, (Number)hitCount, metricContext);
        this.metric.set(TOTALHITS_PER_QUERY_METRIC, (Number)result.getTotalHitCount(), metricContext);
        this.metric.set(QUERY_OFFSET_METRIC, (Number)(query.getHits() + query.getOffset()), metricContext);
        if (hitCount == 0) {
            this.emptyResults.increment();
            this.metric.add(EMPTY_RESULTS_METRIC, (Number)1, metricContext);
        }
        this.addRelevanceMetrics(query, execution, result);
        return result;
    }

    private void logQuery(Query query) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Query: " + query.toString());
        }
    }

    private void addLatency(long latency, Metric.Context metricContext) {
        this.queryLatency.put((double)latency);
        this.metric.set(QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.metric.set(MEAN_QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.maxQueryLatency.put((double)latency);
        this.metric.set(MAX_QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.queryLatencyBuckets.put((double)latency);
    }

    private void incrQueryCount(Metric.Context metricContext) {
        this.queries.increment();
        this.metric.add(QUERIES_METRIC, (Number)1, metricContext);
    }

    private void incrErrorCount(Result result, Metric.Context metricContext) {
        this.failedQueries.increment();
        this.metric.add(FAILED_QUERIES_METRIC, (Number)1, metricContext);
        if (result == null) {
            this.metric.add("error.unhandled_exception", (Number)1, metricContext);
        } else if (result.hits().getErrorHit().hasOnlyErrorCode(Error.NULL_QUERY.code)) {
            this.nullQueries.increment();
        } else if (result.hits().getErrorHit().hasOnlyErrorCode(Error.ILLEGAL_QUERY.code)) {
            this.illegalQueries.increment();
        }
    }

    private void incrementStatePageOnlyErrors(Result result) {
        if (result == null) {
            return;
        }
        ErrorHit error = result.hits().getErrorHit();
        if (error == null) {
            return;
        }
        for (ErrorMessage m : error.errors()) {
            int code = m.getCode();
            Metric.Context c = this.getDimensions(m.getSource());
            if (code == Error.TIMEOUT.code) {
                this.metric.add("error.timeout", (Number)1, c);
                continue;
            }
            if (code == Error.NO_BACKENDS_IN_SERVICE.code) {
                this.metric.add("error.backends_oos", (Number)1, c);
                continue;
            }
            if (code == Error.ERROR_IN_PLUGIN.code) {
                this.metric.add("error.plugin_failure", (Number)1, c);
                continue;
            }
            if (code == Error.BACKEND_COMMUNICATION_ERROR.code) {
                this.metric.add("error.backend_communication_error", (Number)1, c);
                continue;
            }
            if (code == Error.EMPTY_DOCUMENTS.code) {
                this.metric.add("error.empty_document_summaries", (Number)1, c);
                continue;
            }
            if (code == Error.ILLEGAL_QUERY.code) {
                this.metric.add("error.illegal_query", (Number)1, c);
                continue;
            }
            if (code == Error.INVALID_QUERY_PARAMETER.code) {
                this.metric.add("error.invalid_query_parameter", (Number)1, c);
                continue;
            }
            if (code == Error.INTERNAL_SERVER_ERROR.code) {
                this.metric.add("error.internal_server_error", (Number)1, c);
                continue;
            }
            if (code == Error.SERVER_IS_MISCONFIGURED.code) {
                this.metric.add("error.misconfigured_server", (Number)1, c);
                continue;
            }
            if (code == Error.INVALID_QUERY_TRANSFORMATION.code) {
                this.metric.add("error.invalid_query_transformation", (Number)1, c);
                continue;
            }
            if (code == Error.RESULT_HAS_ERRORS.code) {
                this.metric.add("error.result_with_errors", (Number)1, c);
                continue;
            }
            if (code != Error.UNSPECIFIED.code) continue;
            this.metric.add("error.unspecified", (Number)1, c);
        }
    }

    private Metric.Context getDimensions(String source) {
        Metric.Context context = this.statePageOnlyContexts.get(source == null ? "" : source);
        if (context == null) {
            HashMap<String, String> dims = new HashMap<String, String>();
            if (source != null) {
                dims.put("source", source);
            }
            context = this.metric.createContext(dims);
            this.statePageOnlyContexts.put(source == null ? "" : source, context);
        }
        return context;
    }

    private void addRelevanceMetrics(Query query, Execution execution, Result result) {
        Queue<Double> topScores = StatisticsSearcher.findTopRelevanceScores(10, result.hits());
        if (topScores.isEmpty()) {
            return;
        }
        Metric.Context metricContext = this.getRelevanceMetricContext(execution, query);
        this.setRelevanceMetric(10, RELEVANCE_AT_10_METRIC, topScores, metricContext);
        this.setRelevanceMetric(3, RELEVANCE_AT_3_METRIC, topScores, metricContext);
        this.setRelevanceMetric(1, RELEVANCE_AT_1_METRIC, topScores, metricContext);
    }

    private static Queue<Double> findTopRelevanceScores(int n, HitGroup hits) {
        PriorityQueue<Double> heap = new PriorityQueue<Double>(n);
        Iterator<Hit> iterator = hits.unorderedDeepIterator();
        while (iterator.hasNext()) {
            double score;
            Hit hit = iterator.next();
            if (hit instanceof ErrorHit || hit.getRelevance() == null || Double.isNaN(score = hit.getRelevance().getScore())) continue;
            if (heap.size() < n) {
                heap.add(score);
                continue;
            }
            if (!(score > heap.peek())) continue;
            heap.remove();
            heap.add(score);
        }
        return heap;
    }

    private void setRelevanceMetric(int pos, String name, Queue<Double> minQueue, Metric.Context context) {
        while (minQueue.size() > pos) {
            minQueue.remove();
        }
        if (minQueue.size() == pos) {
            this.metric.set(name, (Number)minQueue.poll(), context);
        }
    }

    private class PeakQpsReporter
    extends TimerTask {
        private long prevMaxQPSTime = System.currentTimeMillis();
        private long queriesForQPS = 0L;
        private Metric.Context metricContext = null;

        private PeakQpsReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContext(Metric.Context metricContext) {
            if (this.metricContext == null) {
                PeakQpsReporter peakQpsReporter = this;
                synchronized (peakQpsReporter) {
                    this.metricContext = metricContext;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            PeakQpsReporter peakQpsReporter = this;
            synchronized (peakQpsReporter) {
                if (this.metricContext == null) {
                    return;
                }
                this.flushPeakQps(now);
            }
        }

        private void flushPeakQps(long now) {
            double ms = now - this.prevMaxQPSTime;
            double value = (double)this.queriesForQPS / (ms / 1000.0);
            StatisticsSearcher.this.peakQPS.put(value);
            StatisticsSearcher.this.metric.set(StatisticsSearcher.PEAK_QPS_METRIC, (Number)value, this.metricContext);
            this.prevMaxQPSTime = now;
            this.queriesForQPS = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void countQuery() {
            PeakQpsReporter peakQpsReporter = this;
            synchronized (peakQpsReporter) {
                ++this.queriesForQPS;
            }
        }
    }

    private static enum DegradedReason {
        match_phase,
        adaptive_timeout,
        timeout,
        non_ideal_state;

    }
}

