/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CompositeCondition
extends Condition {
    private List<Condition> conditions = new ArrayList<Condition>();

    @Override
    public void preMatchHook(RuleEvaluation e) {
        super.preMatchHook(e);
        if (e.getTraceLevel() >= 3) {
            e.trace(3, "Evaluating '" + this + "' at " + e.currentItem());
            e.indentTrace();
        }
    }

    @Override
    public void postMatchHook(RuleEvaluation e) {
        if (e.getTraceLevel() >= 3) {
            e.unindentTrace();
        }
    }

    @Override
    protected boolean hasOpenChoicepoint(RuleEvaluation evaluation) {
        Iterator<Condition> i = this.conditionIterator();
        while (i.hasNext()) {
            Condition subCondition = i.next();
            if (!subCondition.hasOpenChoicepoint(evaluation)) continue;
            return true;
        }
        return false;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        condition.setParent(this);
    }

    public void setCondition(int index, Condition condition) {
        this.conditions.set(index, condition);
    }

    public int conditionSize() {
        return this.conditions.size();
    }

    public Condition getCondition(int i) {
        return this.conditions.get(i);
    }

    public Condition removeCondition(int i) {
        Condition condition = this.conditions.remove(i);
        condition.setParent(null);
        return condition;
    }

    public Iterator<Condition> conditionIterator() {
        return this.conditions.iterator();
    }

    @Override
    public void makeReferences(RuleBase rules) {
        Iterator<Condition> i = this.conditionIterator();
        while (i.hasNext()) {
            Condition condition = i.next();
            condition.makeReferences(rules);
        }
    }

    protected boolean useParentheses() {
        return this.getParent() != null;
    }

    protected String toInnerString(String conditionSeparator) {
        if (this.getLabel() != null) {
            return this.getLabel() + ":(" + this.conditionsToString(conditionSeparator) + ")";
        }
        if (this.useParentheses()) {
            return "(" + this.conditionsToString(conditionSeparator) + ")";
        }
        return this.conditionsToString(conditionSeparator);
    }

    protected final String conditionsToString(String conditionSeparator) {
        StringBuilder buffer = new StringBuilder();
        Iterator<Condition> i = this.conditionIterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(conditionSeparator);
        }
        return buffer.toString();
    }

    protected final boolean allSubConditionsMatches(RuleEvaluation e) {
        Iterator<Condition> i = this.conditionIterator();
        while (i.hasNext()) {
            Condition subCondition = i.next();
            if (subCondition.matches(e)) continue;
            return false;
        }
        return true;
    }
}

