/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.RuleBaseException;
import com.yahoo.prelude.semantics.engine.Evaluation;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.ProductionRule;
import com.yahoo.prelude.semantics.rule.ReplacingProductionRule;
import com.yahoo.search.Query;
import java.util.ListIterator;

public class RuleEngine {
    private RuleBase rules;

    public RuleEngine(RuleBase rules) {
        this.rules = rules;
    }

    public String evaluate(Query query, int traceLevel) {
        boolean matchedAnything = false;
        Evaluation evaluation = new Evaluation(query, traceLevel);
        evaluation.setStemming(this.rules.getStemming());
        if (traceLevel >= 2) {
            evaluation.trace(2, "Evaluating query '" + evaluation.getQuery().getModel().getQueryTree().getRoot() + "':");
        }
        ListIterator<ProductionRule> i = this.rules.ruleIterator();
        while (i.hasNext()) {
            evaluation.reset();
            ProductionRule rule = i.next();
            boolean matched = this.matchRuleAtAllStartPoints(evaluation, rule);
            matchedAnything |= matched;
        }
        if (!matchedAnything) {
            return null;
        }
        String error = QueryCanonicalizer.canonicalize(query);
        query.trace("SemanticSearcher: Rewrote query", true, 1);
        return error;
    }

    private boolean matchRuleAtAllStartPoints(Evaluation evaluation, ProductionRule rule) {
        boolean matchedAtLeastOnce = false;
        int iterationCount = 0;
        boolean removalRule = false;
        if (rule instanceof ReplacingProductionRule && rule.getProduction().toString().length() == 0) {
            removalRule = true;
            evaluation.setToLast();
        }
        int loopLimit = Math.max(15, evaluation.getQuerySize() * 3);
        while (evaluation.currentItem() != null) {
            boolean matched = this.matchRule(evaluation, rule);
            if (matched) {
                if (removalRule) {
                    evaluation.resetToLast();
                } else {
                    evaluation.reset();
                }
                matchedAtLeastOnce = true;
                if (rule.isLoop()) {
                    break;
                }
            } else if (removalRule) {
                evaluation.previous();
            } else {
                evaluation.next();
            }
            if (!matched || iterationCount++ <= loopLimit) continue;
            throw new RuleBaseException("Rule '" + rule + "' has matched '" + evaluation.getQuery().getModel().getQueryTree().getRoot() + "' " + loopLimit + " times, aborting");
        }
        return matchedAtLeastOnce;
    }

    private boolean matchRule(Evaluation evaluation, ProductionRule rule) {
        RuleEvaluation ruleEvaluation = evaluation.freshRuleEvaluation();
        ruleEvaluation.indentTrace();
        if (ruleEvaluation.getTraceLevel() >= 3) {
            ruleEvaluation.trace(3, "Evaluating rule '" + rule + "' on '" + ruleEvaluation.getEvaluation().getQuery().getModel().getQueryTree().getRoot() + "' at '" + ruleEvaluation.currentItem() + "':");
        }
        ruleEvaluation.indentTrace();
        boolean matches = rule.matches(ruleEvaluation);
        boolean matchedBefore = false;
        int currentMatchDigest = ruleEvaluation.calculateMatchDigest(rule);
        if (evaluation.hasMatchDigest(currentMatchDigest)) {
            matchedBefore = true;
        }
        boolean queryGotShorter = false;
        if (evaluation.getPreviousQuerySize() > evaluation.getQuerySize()) {
            queryGotShorter = true;
        }
        boolean doProduction = !matchedBefore || queryGotShorter;
        ruleEvaluation.unindentTrace();
        if (ruleEvaluation.getTraceLevel() >= 2) {
            if (matches && doProduction) {
                ruleEvaluation.trace(2, "Matched rule '" + rule + "' at " + ruleEvaluation.previousItem());
            } else if (!matches) {
                ruleEvaluation.trace(2, "Did not match rule '" + rule + "' at " + ruleEvaluation.currentItem());
            } else {
                ruleEvaluation.trace(2, "Ignoring repeated match of '" + rule + "'");
            }
        }
        ruleEvaluation.unindentTrace();
        if (!matches || !doProduction) {
            return false;
        }
        evaluation.addMatchDigest(currentMatchDigest);
        String preQuery = null;
        if (evaluation.getTraceLevel() >= 1) {
            preQuery = evaluation.getQuery().getModel().getQueryTree().getRoot().toString();
        }
        rule.produce(ruleEvaluation);
        if (evaluation.getTraceLevel() >= 1) {
            evaluation.trace(1, "Transforming '" + preQuery + "' to '" + evaluation.getQuery().getModel().getQueryTree().getRoot().toString() + "' since '" + rule + "' matched");
        }
        return true;
    }
}

