/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.List;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class NonPhrasingSearcher
extends Searcher {
    private static final CompoundName suggestonly = new CompoundName("suggestonly");
    private PhraseMatcher phraseMatcher;

    public NonPhrasingSearcher(ComponentId id, QrSearchersConfig config) {
        super(id);
        this.setupAutomatonFile(config.com().yahoo().prelude().querytransform().NonPhrasingSearcher().automatonfile());
    }

    public NonPhrasingSearcher(String phraseAutomatonFile) {
        this.setupAutomatonFile(phraseAutomatonFile);
    }

    private void setupAutomatonFile(String phraseAutomatonFile) {
        this.phraseMatcher = phraseAutomatonFile == null || phraseAutomatonFile.trim().equals("") ? PhraseMatcher.getNullMatcher() : new PhraseMatcher(phraseAutomatonFile);
    }

    @Override
    public Result search(Query query, Execution execution) {
        List<PhraseMatcher.Phrase> phrases = this.phraseMatcher.matchPhrases(query.getModel().getQueryTree().getRoot());
        if (phrases != null && !query.properties().getBoolean(suggestonly, false)) {
            this.remove(phrases);
            query.trace("Removing stop words", true, 2);
        }
        return execution.search(query);
    }

    private void remove(List<PhraseMatcher.Phrase> phrases) {
        for (int i = phrases.size() - 1; i >= 0; --i) {
            PhraseMatcher.Phrase phrase = phrases.get(i);
            if (phrase.getLength() >= phrase.getOwner().getItemCount()) continue;
            phrase.remove();
        }
    }
}

