/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;

public class MarkerWordItem
extends WordItem {
    private final String markerWord;
    private static final String startAnchor = "^";
    private static final String endAnchor = "$";

    private MarkerWordItem(String publicSymbol, String markerWord, String indexName) {
        super(publicSymbol, indexName);
        this.markerWord = markerWord;
    }

    public boolean isStartAnchor() {
        return this.getWord().equals(startAnchor);
    }

    public boolean isEndAnchor() {
        return this.getWord().equals(endAnchor);
    }

    @Override
    protected String getEncodedWord() {
        return this.markerWord;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MarkerWordItem)) {
            return false;
        }
        MarkerWordItem other = (MarkerWordItem)o;
        return this.markerWord.equals(other.markerWord);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 499 * this.markerWord.hashCode();
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("markerWord", this.markerWord);
    }

    public static MarkerWordItem createStartOfHost(String indexName) {
        return new MarkerWordItem(startAnchor, "StArThOsT", indexName);
    }

    public static MarkerWordItem createStartOfHost() {
        return MarkerWordItem.createStartOfHost("");
    }

    public static MarkerWordItem createEndOfHost(String indexName) {
        return new MarkerWordItem(endAnchor, "EnDhOsT", indexName);
    }

    public static MarkerWordItem createEndOfHost() {
        return MarkerWordItem.createEndOfHost("");
    }
}

